/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties.parse;

import com.ibm.xsl.composer.properties.parse.ParseException;
import java.util.Stack;
import java.util.StringTokenizer;

public class ParseBase {
    public static final boolean STRICT = true;
    public static final boolean RELAXED = false;
    public static final int NO_OPTIONS = 0;
    public static final int IDENTIFY_QUOTED_TOKENS = 1;
    public static final int USING_COMMA_SEPERATORS = 2;
    private static boolean parseStrictness = true;
    protected String parseString = "";
    protected Stack stack = new Stack();
    protected boolean quoteOption = false;
    protected boolean commaOption = false;
    private static final String QUOTE = "\"";
    public boolean successMessagesAlso = false;
    private boolean strict = parseStrictness;

    public ParseBase() {
        this.setStrictness(parseStrictness);
    }

    public void addToken(Stack stack, String token) {
        token = token.trim();
        stack.push(token);
    }

    public void addTokens(Stack theStack, StringTokenizer st) {
        while (st.hasMoreElements()) {
            this.addToken(theStack, st.nextToken());
        }
    }

    public void dontUnderstand(String item) throws ParseException {
        this.parseError("Warning: " + item + " was not understood skipping ...");
    }

    public void dontUnderstand(String property, String item) throws ParseException {
        this.parseError("Warning: " + property + "=\"" + item + "\" was not understood skipping ...");
    }

    public String getParseString() {
        return new String(this.parseString);
    }

    public boolean getStrictness() {
        return this.strict;
    }

    public static boolean isStrict() {
        return parseStrictness;
    }

    public String nextToken() {
        if (!this.stack.empty()) {
            return (String)this.stack.pop();
        }
        return null;
    }

    public boolean parseError(int type, String error) throws ParseException {
        if (this.strict) {
            throw new ParseException(type, "ParseError:" + error);
        }
        this.parseWarning(type, error);
        return false;
    }

    public boolean parseError(String error) throws ParseException {
        if (this.strict) {
            throw new ParseException("ParseError:" + error);
        }
        this.parseWarning(error);
        return false;
    }

    public void parseWarning(int type, String warning) {
        System.out.println("ParseWarning: type:" + type + " warning:" + warning);
    }

    public void parseWarning(String warning) {
        System.out.println("ParseWarning: warning:" + warning);
    }

    public void scanAndTokenize() {
        this.scanAndTokenize(0);
    }

    public void scanAndTokenize(int options) {
        this.scanAndTokenize(options, this.parseString);
    }

    public void scanAndTokenize(int options, String s) {
        this.setTokenizationOptions(options);
        this.stack.clear();
        Stack stack2 = new Stack();
        if (this.quoteOption) {
            String remainder = "";
            while (s != null) {
                int firstQuote = s.indexOf(QUOTE);
                int secondQuote = -1;
                if (firstQuote != -1) {
                    if (s.length() - 1 == firstQuote) {
                        this.toStack(stack2, s.substring(0, firstQuote));
                        this.stack.push(QUOTE);
                        break;
                    }
                    remainder = s.substring(firstQuote + 1);
                    secondQuote = remainder.indexOf(QUOTE);
                }
                if (firstQuote >= 0 && secondQuote == -1) {
                    System.out.println("NOTE: first but no second quote");
                    this.toStack(stack2, s);
                    s = null;
                    continue;
                }
                if (firstQuote >= 0 && secondQuote >= 0) {
                    String firstPart = s.substring(0, firstQuote);
                    this.toStack(stack2, firstPart);
                    this.toStackNoTokenization(stack2, QUOTE + remainder.substring(0, secondQuote) + QUOTE);
                    if (remainder.length() - 1 == secondQuote) {
                        s = null;
                        continue;
                    }
                    s = remainder.substring(secondQuote + 1);
                    continue;
                }
                this.toStack(stack2, s);
                s = null;
            }
        } else {
            this.toStack(stack2, this.parseString);
        }
        while (!stack2.empty()) {
            this.stack.push((String)stack2.pop());
        }
    }

    public static void setParseStrictness(boolean strictness) {
        parseStrictness = strictness;
    }

    public void setParseString(String parseString) {
        this.parseString = parseString.trim();
    }

    public void setStrictness(boolean strict) {
        this.strict = strict;
    }

    public void setSuccessMessagesAlso(boolean successMessagesAlso) {
        this.successMessagesAlso = successMessagesAlso;
    }

    private void setTokenizationOptions(int options) {
        this.quoteOption = (options & 1) > 0;
        this.commaOption = (options & 2) > 0;
    }

    public void successFail(String property, boolean success) {
        String s = String.valueOf(property) + "=" + QUOTE + this.getParseString() + QUOTE;
        if (!success) {
            System.out.println("Parse failed for property:" + s);
            return;
        }
        if (this.successMessagesAlso) {
            System.out.println("Parse successful for property:" + s);
        }
    }

    public void toStack(Stack theStack, String string) {
        String delimiter = this.commaOption ? "," : " ";
        this.toStack(theStack, string, delimiter);
    }

    public void toStack(Stack theStack, String tokenString, String delimiters) {
        this.addTokens(theStack, new StringTokenizer(tokenString, delimiters));
    }

    public void toStackNoTokenization(Stack stack, String string) {
        this.addToken(stack, string);
    }
}

