/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.csstypes.LengthPlus;
import com.ibm.xsl.composer.csstypes.SpaceCDT;
import com.ibm.xsl.composer.properties.parse.ParseBase;
import com.ibm.xsl.composer.properties.parse.ParseException;
import com.ibm.xsl.composer.properties.parse.SPParseMargin;

public class MarginProperty {
    private boolean inheritMarginBottom = false;
    private boolean inheritMarginTop = false;
    private boolean inheritMarginLeft = false;
    private boolean inheritMarginRight = false;
    private boolean inheritSpaceBefore = false;
    private boolean inheritSpaceAfter = false;
    private boolean inheritStartIndent = true;
    private boolean inheritEndIndent = true;
    private boolean inheritSpaceEnd = false;
    private boolean inheritSpaceStart = false;
    private static final String[] allowedList = new String[]{"auto"};
    private LengthPlus marginBottom = new LengthPlus(allowedList);
    private LengthPlus marginTop = new LengthPlus(allowedList);
    private LengthPlus marginLeft = new LengthPlus(allowedList);
    private LengthPlus marginRight = new LengthPlus(allowedList);
    private SpaceCDT spaceBefore = new SpaceCDT();
    private SpaceCDT spaceAfter = new SpaceCDT();
    private CSSLength startIndent = new CSSLength();
    private CSSLength endIndent = new CSSLength();
    private SpaceCDT spaceEnd = new SpaceCDT();
    private SpaceCDT spaceStart = new SpaceCDT();

    public boolean cmpMarginProperty(MarginProperty mp) {
        return !(this.inheritMarginBottom != mp.inheritMarginBottom || !this.inheritMarginBottom && !mp.marginBottom.equals(this.marginBottom) || this.inheritMarginTop != mp.inheritMarginTop || !this.inheritMarginTop && !mp.marginTop.equals(this.marginTop) || this.inheritMarginLeft != mp.inheritMarginLeft || !this.inheritMarginLeft && !mp.marginLeft.equals(this.marginLeft) || this.inheritMarginRight != mp.inheritMarginRight || !this.inheritMarginRight && !mp.marginRight.equals(this.marginRight) || this.inheritSpaceBefore != mp.inheritSpaceBefore || !this.inheritSpaceBefore && !mp.spaceBefore.equals(this.spaceBefore) || this.inheritSpaceAfter != mp.inheritSpaceAfter || !this.inheritSpaceAfter && !mp.spaceAfter.equals(this.spaceAfter) || this.inheritStartIndent != mp.inheritStartIndent || !this.inheritStartIndent && !mp.startIndent.equals(this.startIndent) || this.inheritEndIndent != mp.inheritEndIndent || !this.inheritEndIndent && !mp.endIndent.equals(this.endIndent) || this.inheritSpaceEnd != mp.inheritSpaceEnd || !this.inheritSpaceEnd && !mp.spaceEnd.equals(this.spaceEnd) || this.inheritSpaceStart != mp.inheritSpaceStart || !this.inheritSpaceStart && !mp.spaceStart.equals(this.spaceStart));
    }

    private static boolean decodeLength(String value, CSSLength length) {
        boolean inherited;
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            inherited = true;
        } else {
            inherited = false;
            length.setLength(value);
        }
        return inherited;
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (this == obj) {
            isEquals = true;
        } else if (obj != null && obj instanceof MarginProperty) {
            isEquals = this.cmpMarginProperty((MarginProperty)obj);
        }
        return isEquals;
    }

    public CSSLength getEndIndent() {
        return this.endIndent;
    }

    public String getEndIndentAttribute() {
        return this.inheritEndIndent ? "inherit" : this.endIndent.getLength();
    }

    public LengthPlus getMarginBottom() {
        return this.marginBottom;
    }

    public String getMarginBottomAttribute() {
        return this.inheritMarginBottom ? "inherit" : this.marginBottom.getLength();
    }

    public LengthPlus getMarginLeft() {
        return this.marginLeft;
    }

    public String getMarginLeftAttribute() {
        return this.inheritMarginLeft ? "inherit" : this.marginLeft.getLength();
    }

    public LengthPlus getMarginRight() {
        return this.marginRight;
    }

    public String getMarginRightAttribute() {
        return this.inheritMarginRight ? "inherit" : this.marginRight.getLength();
    }

    public LengthPlus getMarginTop() {
        return this.marginTop;
    }

    public String getMarginTopAttribute() {
        return this.inheritMarginTop ? "inherit" : this.marginTop.getLength();
    }

    public SpaceCDT getSpaceAfter() {
        return this.spaceAfter;
    }

    public String getSpaceAfterAttribute() {
        return this.inheritSpaceAfter ? "inherit" : this.spaceAfter.getAttributeString();
    }

    public SpaceCDT getSpaceBefore() {
        return this.spaceBefore;
    }

    public String getSpaceBeforeAttribute() {
        return this.inheritSpaceBefore ? "inherit" : this.spaceBefore.getAttributeString();
    }

    public SpaceCDT getSpaceEnd() {
        return this.spaceEnd;
    }

    public String getSpaceEndAttribute() {
        return this.inheritSpaceEnd ? "inherit" : this.spaceEnd.getAttributeString();
    }

    public SpaceCDT getSpaceStart() {
        return this.spaceStart;
    }

    public String getSpaceStartAttribute() {
        return this.inheritSpaceStart ? "inherit" : this.spaceStart.getAttributeString();
    }

    public CSSLength getStartIndent() {
        return this.startIndent;
    }

    public String getStartIndentAttribute() {
        return this.inheritStartIndent ? "inherit" : this.startIndent.getLength();
    }

    public boolean inherit(MarginProperty mp) {
        boolean altered = false;
        if (this.inheritMarginBottom && !mp.marginBottom.equals(this.marginBottom)) {
            this.marginBottom.copy(mp.marginBottom);
            altered = true;
        }
        if (this.inheritMarginTop && !mp.marginTop.equals(this.marginTop)) {
            this.marginTop.copy(mp.marginTop);
            altered = true;
        }
        if (this.inheritMarginLeft && !mp.marginLeft.equals(this.marginLeft)) {
            this.marginLeft.copy(mp.marginLeft);
            altered = true;
        }
        if (this.inheritMarginRight && !mp.marginRight.equals(this.marginRight)) {
            this.marginRight.copy(mp.marginRight);
            altered = true;
        }
        if (this.inheritSpaceBefore && !mp.spaceBefore.equals(this.spaceBefore)) {
            this.spaceBefore.copy(mp.spaceBefore);
            altered = true;
        }
        if (this.inheritSpaceAfter && !mp.spaceAfter.equals(this.spaceAfter)) {
            this.spaceAfter.copy(mp.spaceAfter);
            altered = true;
        }
        if (this.inheritStartIndent && !mp.startIndent.equals(this.startIndent)) {
            this.startIndent.copy(mp.startIndent);
            altered = true;
        }
        if (this.inheritEndIndent && !mp.endIndent.equals(this.endIndent)) {
            this.endIndent.copy(mp.endIndent);
            altered = true;
        }
        if (this.inheritSpaceEnd && !mp.spaceEnd.equals(this.spaceEnd)) {
            this.spaceEnd.copy(mp.spaceEnd);
            altered = true;
        }
        if (this.inheritSpaceStart && !mp.spaceStart.equals(this.spaceStart)) {
            this.spaceStart.copy(mp.spaceStart);
            altered = true;
        }
        return altered;
    }

    public void setEndIndent(String value) {
        this.inheritEndIndent = MarginProperty.decodeLength(value, this.endIndent);
    }

    public void setMarginBottom(String value) {
        this.inheritMarginBottom = MarginProperty.decodeLength(value, this.marginBottom);
    }

    public void setMarginLeft(String value) {
        this.inheritMarginLeft = MarginProperty.decodeLength(value, this.marginLeft);
    }

    public void setMarginRight(String value) {
        this.inheritMarginRight = MarginProperty.decodeLength(value, this.marginRight);
    }

    public void setMarginShorthandProperty(String margin) {
        boolean success;
        String property = "margin";
        SPParseMargin parseMargin = new SPParseMargin(this);
        parseMargin.setStrictness(true);
        try {
            success = parseMargin.spMargin(margin);
        }
        catch (ParseException parseException) {
            success = false;
        }
        if (!success) {
            new ParseBase().dontUnderstand("margin", margin);
        }
    }

    public void setMarginTop(String value) {
        this.inheritMarginTop = MarginProperty.decodeLength(value, this.marginTop);
    }

    public void setSpaceAfter(String value) {
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            this.inheritSpaceAfter = true;
        } else {
            this.inheritSpaceAfter = false;
            this.spaceAfter.setLength(value);
        }
    }

    public void setSpaceAfterConditionality(String conditionality) {
        this.spaceAfter.setConditionality(conditionality);
    }

    public void setSpaceAfterMaximum(String maximum) {
        this.spaceAfter.setMaximum(maximum);
    }

    public void setSpaceAfterMinimum(String minimum) {
        this.spaceAfter.setMinimum(minimum);
    }

    public void setSpaceAfterOptimum(String optimum) {
        this.spaceAfter.setOptimum(optimum);
    }

    public void setSpaceAfterPrecedence(String precedence) {
        this.spaceAfter.setPrecedence(precedence);
    }

    public void setSpaceBefore(String value) {
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            this.inheritSpaceBefore = true;
        } else {
            this.inheritSpaceBefore = false;
            this.spaceBefore.setLength(value);
        }
    }

    public void setSpaceBeforeConditionality(String conditionality) {
        this.spaceBefore.setConditionality(conditionality);
    }

    public void setSpaceBeforeMaximum(String maximum) {
        this.spaceBefore.setMaximum(maximum);
    }

    public void setSpaceBeforeMinimum(String minimum) {
        this.spaceBefore.setMinimum(minimum);
    }

    public void setSpaceBeforeOptimum(String optimum) {
        this.spaceBefore.setOptimum(optimum);
    }

    public void setSpaceBeforePrecedence(String precedence) {
        this.spaceBefore.setPrecedence(precedence);
    }

    public void setSpaceEnd(String value) {
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            this.inheritSpaceEnd = true;
        } else {
            this.inheritSpaceEnd = false;
            this.spaceEnd.setLength(value);
        }
    }

    public void setSpaceEndConditionality(String conditionality) {
        this.spaceEnd.setConditionality(conditionality);
    }

    public void setSpaceEndMaximum(String maximum) {
        this.spaceEnd.setMaximum(maximum);
    }

    public void setSpaceEndMinimum(String minimum) {
        this.spaceEnd.setMinimum(minimum);
    }

    public void setSpaceEndOptimum(String optimum) {
        this.spaceEnd.setOptimum(optimum);
    }

    public void setSpaceEndPrecedence(String precedence) {
        this.spaceEnd.setPrecedence(precedence);
    }

    public void setSpaceStart(String value) {
        if ((value = value.trim().toLowerCase()).equals("inherit")) {
            this.inheritSpaceStart = true;
        } else {
            this.inheritSpaceStart = false;
            this.spaceStart.setLength(value);
        }
    }

    public void setSpaceStartConditionality(String conditionality) {
        this.spaceStart.setConditionality(conditionality);
    }

    public void setSpaceStartMaximum(String maximum) {
        this.spaceStart.setMaximum(maximum);
    }

    public void setSpaceStartMinimum(String minimum) {
        this.spaceStart.setMinimum(minimum);
    }

    public void setSpaceStartOptimum(String optimum) {
        this.spaceStart.setOptimum(optimum);
    }

    public void setSpaceStartPrecedence(String precedence) {
        this.spaceStart.setPrecedence(precedence);
    }

    public void setStartIndent(String value) {
        this.inheritStartIndent = MarginProperty.decodeLength(value, this.startIndent);
    }
}

