/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.properties;

import com.ibm.xsl.composer.csstypes.CSSLength;
import com.ibm.xsl.composer.prim.ShortMap;
import com.ibm.xsl.composer.properties.parse.ParseBase;

public class AbsolutePositionProperty {
    public static final short ABSOLUTE_POSITION_INHERIT = 0;
    public static final short ABSOLUTE_POSITION_AUTO = 1;
    public static final short ABSOLUTE_POSITION_ABSOLUTE = 2;
    public static final short ABSOLUTE_POSITION_FIXED = 3;
    private static final ShortMap absolutePositionMap = new ShortMap(new String[]{"inherit", "auto", "absolute", "fixed"});
    public short absolutePositionValue = 1;
    public static final short TBRL_INHERIT = 0;
    public static final short TBRL_AUTO = 1;
    public static final short TBRL_ISLENGTH = 2;
    private static final ShortMap extentMap = new ShortMap(new String[]{"inherit", "auto"});
    public short topValue = 1;
    public final CSSLength topLength = new CSSLength(3);
    public short bottomValue = 1;
    public final CSSLength bottomLength = new CSSLength(3);
    public short rightValue = 1;
    public final CSSLength rightLength = new CSSLength(3);
    public short leftValue = 1;
    public final CSSLength leftLength = new CSSLength(3);
    public static final short POSITION_INHERIT = 0;
    public static final short POSITION_STATIC = 1;
    public static final short POSITION_RELATIVE = 2;
    public static final short POSITION_ABSOLUTE = 3;
    public static final short POSITION_FIXED = 4;
    private static final ShortMap positionMap = new ShortMap(new String[]{"inherit", "static", "relative", "absolute", "fixed"});
    public short positionValue = 1;

    public boolean cmpAbsolutePosProperty(AbsolutePositionProperty ap) {
        boolean isEquals = false;
        if (this.absolutePositionValue == ap.absolutePositionValue && this.positionValue == ap.positionValue && this.topValue == ap.topValue && (this.topValue != 2 ? true : this.topLength.equals(ap.topLength)) && this.bottomValue == ap.bottomValue & (this.bottomValue != 2 ? true : this.bottomLength.equals(ap.bottomLength)) && this.leftValue == ap.leftValue & (this.leftValue != 2 ? true : this.leftLength.equals(ap.leftLength)) && this.rightValue == ap.rightValue & (this.rightValue != 2 ? true : this.rightLength.equals(ap.rightLength))) {
            isEquals = true;
        }
        return isEquals;
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (this == obj) {
            isEquals = true;
        } else if (obj != null && obj instanceof AbsolutePositionProperty) {
            isEquals = this.cmpAbsolutePosProperty((AbsolutePositionProperty)obj);
        }
        return isEquals;
    }

    public String getAbsolutePosition() {
        return absolutePositionMap.getName(this.absolutePositionValue);
    }

    public String getAbsolutePositionAttribute() {
        return this.getAbsolutePosition();
    }

    public String getBottom() {
        return extentMap.getName(this.bottomValue);
    }

    public String getBottomAttribute() {
        return this.getBottom();
    }

    public String getLeft() {
        return extentMap.getName(this.leftValue);
    }

    public String getLeftAttribute() {
        return this.getLeft();
    }

    public String getPosition() {
        return positionMap.getName(this.positionValue);
    }

    public String getPositionAtribute() {
        return this.getPosition();
    }

    public String getRight() {
        return extentMap.getName(this.rightValue);
    }

    public String getRightAttribute() {
        return this.getRight();
    }

    public String getTop() {
        return extentMap.getName(this.topValue);
    }

    public String getTopAttribute() {
        return this.getTop();
    }

    public boolean inherit(AbsolutePositionProperty parent) {
        boolean altered = false;
        if (this.absolutePositionValue == 0) {
            this.absolutePositionValue = parent.absolutePositionValue;
            altered = true;
        }
        if (this.positionValue == 0) {
            this.positionValue = parent.positionValue;
            altered = true;
        }
        if (this.topValue == 0) {
            this.topValue = parent.topValue;
            this.topLength.copy(parent.topLength);
            altered = true;
        }
        if (this.bottomValue == 0) {
            this.bottomValue = parent.bottomValue;
            this.bottomLength.copy(parent.bottomLength);
            altered = true;
        }
        if (this.rightValue == 0) {
            this.rightValue = parent.rightValue;
            this.rightLength.copy(parent.rightLength);
            altered = true;
        }
        if (this.leftValue == 0) {
            this.leftValue = parent.leftValue;
            this.leftLength.copy(parent.leftLength);
            altered = true;
        }
        return altered;
    }

    public void setAbsolutePosition(String pos) {
        String value = pos.trim().toLowerCase();
        try {
            this.absolutePositionValue = absolutePositionMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new ParseBase().dontUnderstand("absolute-position", value);
        }
    }

    public void setBottom(String bottom) {
        String value = bottom.trim().toLowerCase();
        try {
            this.bottomValue = extentMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 3)) {
                this.bottomValue = (short)2;
                this.bottomLength.setLength(value);
            }
            new ParseBase().dontUnderstand("bottom", value);
        }
    }

    public void setLeft(String left) {
        String value = left.trim().toLowerCase();
        try {
            this.leftValue = extentMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 3)) {
                this.leftValue = (short)2;
                this.leftLength.setLength(value);
            }
            new ParseBase().dontUnderstand("left", value);
        }
    }

    public void setPositionShorthandProperty(String position) {
        String value = position.trim().toLowerCase();
        try {
            this.positionValue = positionMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new ParseBase().dontUnderstand("position", value);
        }
    }

    public void setRight(String right) {
        String value = right.trim().toLowerCase();
        try {
            this.rightValue = extentMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 3)) {
                this.rightValue = (short)2;
                this.rightLength.setLength(value);
            }
            new ParseBase().dontUnderstand("right", value);
        }
    }

    public void setTop(String top) {
        String value = top.trim().toLowerCase();
        try {
            this.topValue = extentMap.decodeName(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (CSSLength.isValid(value, 3)) {
                this.topValue = (short)2;
                this.topLength.setLength(value);
            }
            new ParseBase().dontUnderstand("top", value);
        }
    }
}

