/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.prim;

import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class Transform {
    private AffineTransform aft;
    private WritingMode mode;
    private short referenceOrientation;

    public Transform() {
        this.aft = new AffineTransform();
        this.mode = new WritingMode();
    }

    public Transform(Transform transform) {
        this.aft = new AffineTransform(transform.aft);
        this.mode = new WritingMode();
        this.mode.copy(transform.mode);
        this.referenceOrientation = transform.referenceOrientation;
    }

    private void effectTransform(Extent content) {
        short bpd = this.mode.getBlockProgressionDirection();
        switch (this.mode.getInlineProgressionDirection()) {
            case 2: {
                if (bpd == 1) {
                    this.aft.scale(-1.0, 1.0);
                    this.aft.translate(-content.ipd, 0.0);
                    break;
                }
                this.aft.scale(-1.0, -1.0);
                this.aft.translate(-content.ipd, -content.bpd);
                break;
            }
            case 1: {
                if (bpd == 2) {
                    this.aft.rotate(1.5707963267948966);
                    this.aft.translate(0.0, -content.ipd);
                    break;
                }
                this.aft.scale(-1.0, 1.0);
                this.aft.rotate(1.5707963267948966);
                break;
            }
            case 0: {
                if (bpd != 3) break;
                this.aft.scale(1.0, -1.0);
                this.aft.translate(0.0, -content.bpd);
                break;
            }
            case 3: {
                this.aft.rotate(1.5707963267948966);
                if (bpd == 2) {
                    this.aft.scale(-1.0, 1.0);
                    this.aft.translate(-content.bpd, -content.ipd);
                    break;
                }
                this.aft.scale(-1.0, -1.0);
                this.aft.translate(-content.bpd, 0.0);
                break;
            }
        }
    }

    public short getBlockProgressionDirection() {
        return this.mode.getBlockProgressionDirection();
    }

    public short getInlineProgressionDirection() {
        return this.mode.getInlineProgressionDirection();
    }

    public WritingMode getWritingMode() {
        return this.mode;
    }

    private void normalizeTransform(Extent content) {
        short bpd = this.mode.getBlockProgressionDirection();
        switch (this.mode.getInlineProgressionDirection()) {
            case 2: {
                if (bpd == 3) {
                    this.aft.translate(content.ipd, content.bpd);
                    this.aft.scale(-1.0, -1.0);
                    break;
                }
                this.aft.translate(content.ipd, 0.0);
                this.aft.scale(-1.0, 1.0);
                break;
            }
            case 1: {
                this.aft.rotate(-1.5707963267948966);
                if (bpd == 2) break;
                this.aft.scale(-1.0, 1.0);
                break;
            }
            case 0: {
                if (bpd != 3) break;
                this.aft.translate(0.0, content.bpd);
                this.aft.scale(1.0, -1.0);
                break;
            }
            case 3: {
                this.aft.rotate(-1.5707963267948966);
                if (bpd == 2) {
                    this.aft.scale(-1.0, 1.0);
                    this.aft.translate(content.bpd, content.ipd);
                    break;
                }
                this.aft.translate(0.0, content.bpd);
                break;
            }
        }
    }

    private void referenceOrientationTransform(Extent content, FLOPoint location) {
        long adjust = Math.abs(location.before - location.start);
        switch (this.referenceOrientation) {
            case 90: {
                this.aft.rotate(-1.5707963267948966);
                this.aft.translate(-content.bpd - adjust, -location.before);
                break;
            }
            case 180: {
                this.aft.rotate(Math.PI);
                this.aft.translate(-content.ipd, -content.bpd);
                break;
            }
            case 270: {
                this.aft.rotate(1.5707963267948966);
                this.aft.translate(-location.start, -content.ipd + adjust);
                break;
            }
        }
    }

    public void scale(long x, long y) {
        this.aft.scale(x, y);
    }

    public void setReferenceOrientation(short orientation, Extent content, FLOPoint location) {
        if (this.referenceOrientation != orientation) {
            this.referenceOrientation = orientation;
            this.referenceOrientationTransform(content, location);
        }
    }

    public void setWritingMode(WritingMode mode, Extent content) {
        if (!this.mode.equals(mode)) {
            this.normalizeTransform(content);
            this.mode.copy(mode);
            this.effectTransform(content);
        }
    }

    public String toString() {
        return "[Transform  aft:" + this.aft + " mode:" + this.mode + "]";
    }

    public CSSPoint transform(long x, long y) {
        Point2D.Double pt = new Point2D.Double(x, y);
        this.aft.transform(pt, pt);
        CSSPoint result = new CSSPoint(Math.round(pt.x), Math.round(pt.y));
        return result;
    }

    public CSSPoint transform(CSSPoint p) {
        return this.transform(p.x, p.y);
    }

    public void transformRectangle(CSSPoint location, CSSExtent extent) {
        CSSPoint tLocation = this.transform(location.x, location.y);
        CSSPoint tExtent = this.transform(location.x + extent.width, location.y + extent.height);
        location.x = Math.min(tLocation.x, tExtent.x);
        location.y = Math.min(tLocation.y, tExtent.y);
        extent.width = Math.abs(tLocation.x - tExtent.x);
        extent.height = Math.abs(tLocation.y - tExtent.y);
    }

    public void translate(long x, long y) {
        this.aft.translate(x, y);
    }
}

