/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.prim;

import com.ibm.xsl.composer.prim.Size;

public class Space {
    public Size request;
    public static final int TYPE_FORCE = 0;
    public static final int TYPE_VALUE = 1;
    public int precedenceType;
    public int precedenceLevel;
    public static final int COND_RETAIN = 0;
    public static final int COND_DISCARD = 1;
    public static final Space EMPTY = new Space(0L, 0);
    private static final String RETAIN = "retain";
    private static final String DISCARD = "discard";
    private static final String FORCE = "force";
    public int conditionality;

    public Space() {
        this.request = new Size();
        this.setDefault();
    }

    public Space(long size) {
        this.request = new Size(size);
        this.defaultPC();
    }

    public Space(long size, int prec) {
        this.request = new Size(size);
        this.setPrecedence(prec);
        this.conditionality = 1;
    }

    public Space(Size size) {
        this.request = new Size(size);
        this.defaultPC();
    }

    public Size combine(Space addSpace) {
        Size combined;
        if (this.precedenceType == 0 && addSpace.precedenceType == 1) {
            combined = new Size(this.request);
        } else if (this.precedenceType == 1 && addSpace.precedenceType == 0) {
            combined = new Size(addSpace.request);
        } else if (this.precedenceType == 0 && addSpace.precedenceType == 0) {
            combined = new Size(this.request);
            combined.sum(addSpace.request);
        } else if (this.precedenceLevel < addSpace.precedenceLevel) {
            combined = new Size(addSpace.request);
        } else if (this.precedenceLevel > addSpace.precedenceLevel) {
            combined = new Size(this.request);
        } else if (this.request.optimum < addSpace.request.optimum) {
            combined = new Size(addSpace.request);
        } else if (this.request.optimum > addSpace.request.optimum) {
            combined = new Size(this.request);
        } else if (this.request.optimum == addSpace.request.optimum) {
            combined = new Size(this.request);
            combined.constrain(addSpace.request);
        } else {
            throw new IllegalArgumentException("Space type is invalid");
        }
        return combined;
    }

    public void copy(Space space) {
        this.request.copy(space.request);
        this.precedenceType = space.precedenceType;
        this.precedenceLevel = space.precedenceLevel;
        this.conditionality = space.conditionality;
    }

    private void defaultPC() {
        this.precedenceType = 1;
        this.conditionality = 0;
    }

    public String getConditionalityName() {
        String cond = this.conditionality == 0 ? RETAIN : (this.conditionality == 1 ? DISCARD : "INVALID");
        return cond;
    }

    public long getOptimum() {
        return this.request.optimum;
    }

    public String getPrecedenceTypeName() {
        String prec = this.precedenceType == 0 ? FORCE : Integer.toString(this.precedenceLevel);
        return prec;
    }

    public void max(Space merge) {
        if (this.conditionality == 1 && merge.conditionality != 1) {
            this.copy(merge);
        } else if (this.conditionality == 1 || merge.conditionality != 1) {
            this.request.max(merge.request);
            if (merge.precedenceType == 0) {
                this.precedenceType = 0;
            }
            this.precedenceLevel = Math.max(this.precedenceLevel, merge.precedenceLevel);
        }
    }

    public void setConditionality(int cond) {
        this.conditionality = cond;
    }

    public void setConditionality(String cond) {
        if ((cond = cond.trim().toLowerCase()).equals(RETAIN)) {
            this.setConditionality(0);
        } else {
            this.setConditionality(1);
        }
    }

    public void setDefault() {
        this.request.setDefault();
        this.defaultPC();
    }

    public void setPrecedence(int level) {
        this.precedenceLevel = level;
        this.precedenceType = 1;
    }

    public void setPrecedence(String level) {
        if ((level = level.trim().toLowerCase()).equals(FORCE)) {
            this.precedenceType = 0;
        } else {
            try {
                this.setPrecedence(Integer.parseInt(level));
            }
            catch (NumberFormatException numberFormatException) {
                this.setPrecedence(0);
            }
        }
    }

    public void setSize(long size) {
        this.request.setScalar(size);
    }

    public void setSize(Size size) {
        this.request.copy(size);
    }

    public String toString() {
        return "<space prec=\"" + this.getPrecedenceTypeName() + "\" cond=\"" + this.getConditionalityName() + "\">" + this.request + "</space>";
    }
}

