/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.prim;

public class Size {
    public long minimum;
    public long maximum;
    public long optimum;

    public Size() {
        this.setDefault();
    }

    public Size(long optimum) {
        this.setScalar(optimum);
    }

    public Size(long minimum, long maximum, long optimum) {
        this.setRange(minimum, maximum, optimum);
    }

    public Size(Size pattern) {
        this(pattern.minimum, pattern.maximum, pattern.optimum);
    }

    public void constrain(Size constraint) {
        this.minimum = this.minimum < constraint.minimum ? constraint.minimum : this.minimum;
        this.maximum = this.maximum > constraint.maximum ? constraint.maximum : this.maximum;
    }

    public void copy(Size s) {
        this.minimum = s.minimum;
        this.maximum = s.maximum;
        this.optimum = s.optimum;
    }

    public boolean doesFit(long test) {
        return this.minimum <= test && test <= this.maximum;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public long getOptimum() {
        return this.optimum;
    }

    public boolean isValid() {
        return this.minimum <= this.optimum && this.optimum <= this.maximum;
    }

    public static boolean isValid(long minimum, long optimum, long maximum) {
        return minimum <= optimum && optimum <= maximum;
    }

    public void max(Size merge) {
        this.minimum = Math.max(this.minimum, merge.minimum);
        this.maximum = Math.max(this.maximum, merge.maximum);
        this.optimum = Math.max(this.optimum, merge.optimum);
    }

    public void setDefault() {
        this.setScalar(0L);
    }

    public void setRange(long minimum, long maximum, long optimum) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.optimum = optimum;
        if (!this.isValid()) {
            throw new IllegalArgumentException("violated: minimum <= optimum <= maximum");
        }
    }

    public void setScalar(long optimum) {
        this.maximum = this.optimum = optimum;
        this.minimum = this.optimum;
    }

    public void sum(Size add) {
        this.minimum += add.minimum;
        this.maximum += add.maximum;
        this.optimum += add.optimum;
    }

    public String toString() {
        return "<size minimum=\"" + this.minimum + "\" optimum=\"" + this.optimum + "\" maximum=\"" + this.maximum + "\"/>";
    }
}

