/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.java2d;

import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.java2d.J2DFourEdgeBorder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class J2DOutsetInsetBorder
extends J2DFourEdgeBorder {
    public static final int NO_STYLE = 0;
    public static final int OUTSET = 1;
    public static final int INSET = 2;
    protected int bevelType;
    protected Color highlightOuter;
    protected Color highlightInner;
    protected Color shadowInner;
    protected Color shadowOuter;
    protected int topStyle = 0;
    protected int bottomStyle = 0;
    protected int rightStyle = 0;
    protected int leftStyle = 0;

    public J2DOutsetInsetBorder() {
        this.borderWidth = 2;
    }

    public J2DOutsetInsetBorder(int bevelType) {
        this.bevelType = bevelType;
        this.borderWidth = 2;
    }

    public J2DOutsetInsetBorder(int bevelType, int borderWidth) {
        this(bevelType);
        this.borderWidth = borderWidth;
    }

    public J2DOutsetInsetBorder(int bevelType, Color highlight, Color shadow) {
        this(bevelType, highlight.brighter(), highlight, shadow, shadow.brighter());
    }

    public J2DOutsetInsetBorder(int bevelType, Color highlightOuter, Color highlightInner, Color shadowOuter, Color shadowInner) {
        this(bevelType);
        this.highlightOuter = highlightOuter;
        this.highlightInner = highlightInner;
        this.shadowOuter = shadowOuter;
        this.shadowInner = shadowInner;
    }

    protected void drawBottom(Graphics g, Color outerColor, Color innerColor, int borderWidth, int w, int h) {
        g.setColor(outerColor);
        int outerWidth = borderWidth / 2;
        int i = 0;
        while (i <= outerWidth) {
            g.drawLine(i, h - 1 - i, w - 1 - i, h - 1 - i);
            ++i;
        }
        g.setColor(innerColor);
        while (i < borderWidth) {
            g.drawLine(i, h - 1 - i, w - 1 - i, h - 1 - i);
            ++i;
        }
    }

    protected void drawLeft(Graphics g, Color outerColor, Color innerColor, int borderWidth, int w, int h) {
        g.setColor(outerColor);
        int outerWidth = borderWidth / 2;
        int i = 0;
        while (i <= outerWidth) {
            g.drawLine(i, i, i, h - 1 - i);
            ++i;
        }
        g.setColor(innerColor);
        while (i < borderWidth) {
            g.drawLine(i, i, i, h - 1 - i);
            ++i;
        }
    }

    protected void drawRight(Graphics g, Color outerColor, Color innerColor, int borderWidth, int w, int h) {
        g.setColor(outerColor);
        int outerWidth = borderWidth / 2;
        int i = 0;
        while (i <= outerWidth) {
            g.drawLine(w - 1 - i, i, w - 1 - i, h - 1 - i);
            ++i;
        }
        g.setColor(innerColor);
        while (i < borderWidth) {
            g.drawLine(w - 1 - i, i, w - 1 - i, h - 1 - i);
            ++i;
        }
    }

    protected void drawTop(Graphics g, Color outerColor, Color innerColor, int borderWidth, int w, int h) {
        g.setColor(outerColor);
        int outerWidth = borderWidth / 2;
        int i = 0;
        while (i <= outerWidth) {
            g.drawLine(i, i, w - 1 - i, i);
            ++i;
        }
        g.setColor(innerColor);
        while (i < borderWidth) {
            g.drawLine(i, i, w - 1 - i, i);
            ++i;
        }
    }

    public int getBevelType() {
        return this.bevelType;
    }

    public Color getHighlightInnerColor(Color color) {
        return color.brighter();
    }

    public Color getHighlightOuterColor(Color color) {
        return color.brighter().brighter();
    }

    public Color getShadowInnerColor(Color color) {
        return color.darker();
    }

    public Color getShadowOuterColor(Color color) {
        return color.darker().darker();
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Graphics2D g, int x, int y, int width, int height) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke());
        if (this.topEdge && this.topStyle == 1 && this.topWidth > 0) {
            this.paintTopOutset(g, x, y, width, height);
        }
        if (this.bottomEdge && this.bottomStyle == 1 && this.bottomWidth > 0) {
            this.paintBottomOutset(g, x, y, width, height);
        }
        if (this.rightEdge && this.rightStyle == 1 && this.rightWidth > 0) {
            this.paintRightOutset(g, x, y, width, height);
        }
        if (this.leftEdge && this.leftStyle == 1 && this.leftWidth > 0) {
            this.paintLeftOutset(g, x, y, width, height);
        }
        if (this.topEdge && this.topStyle == 2 && this.topWidth > 0) {
            this.paintTopInset(g, x, y, width, height);
        }
        if (this.bottomEdge && this.bottomStyle == 2 && this.bottomWidth > 0) {
            this.paintBottomInset(g, x, y, width, height);
        }
        if (this.rightEdge && this.rightStyle == 2 && this.rightWidth > 0) {
            this.paintRightInset(g, x, y, width, height);
        }
        if (this.leftEdge && this.leftStyle == 2 && this.leftWidth > 0) {
            this.paintLeftInset(g, x, y, width, height);
        }
        g.setStroke(oldStroke);
    }

    protected void paintBottomInset(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color outerColor = this.getHighlightOuterColor(this.bottomColor);
        Color innerColor = this.getHighlightInnerColor(this.bottomColor);
        this.drawBottom(g, outerColor, innerColor, this.bottomWidth, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintBottomOutset(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color outerColor = this.getShadowOuterColor(this.bottomColor);
        Color innerColor = this.getShadowInnerColor(this.bottomColor);
        this.drawBottom(g, outerColor, innerColor, this.bottomWidth, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintLeftInset(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color outerColor = this.getShadowInnerColor(this.leftColor);
        Color innerColor = this.getShadowOuterColor(this.leftColor);
        this.drawLeft(g, outerColor, innerColor, this.leftWidth, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintLeftOutset(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color outerColor = this.getHighlightOuterColor(this.leftColor);
        Color innerColor = this.getHighlightInnerColor(this.leftColor);
        this.drawLeft(g, outerColor, innerColor, this.leftWidth, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintRightInset(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color outerColor = this.getHighlightOuterColor(this.rightColor);
        Color innerColor = this.getHighlightInnerColor(this.rightColor);
        this.drawRight(g, outerColor, innerColor, this.rightWidth, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintRightOutset(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color outerColor = this.getShadowOuterColor(this.rightColor);
        Color innerColor = this.getShadowInnerColor(this.rightColor);
        this.drawRight(g, outerColor, innerColor, this.rightWidth, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintTopInset(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color outerColor = this.getShadowInnerColor(this.topColor);
        Color innerColor = this.getShadowOuterColor(this.topColor);
        this.drawTop(g, outerColor, innerColor, this.topWidth, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    protected void paintTopOutset(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        Color outerColor = this.getHighlightOuterColor(this.topColor);
        Color innerColor = this.getHighlightInnerColor(this.topColor);
        this.drawTop(g, outerColor, innerColor, this.topWidth, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public void setBottomEdge(CSSColor color, int width, int style) {
        super.setBottomEdge(color, width);
        this.bottomStyle = style;
    }

    public void setLeftEdge(CSSColor color, int width, int style) {
        super.setLeftEdge(color, width);
        this.leftStyle = style;
    }

    public void setRightEdge(CSSColor color, int width, int style) {
        super.setRightEdge(color, width);
        this.rightStyle = style;
    }

    public void setTopEdge(CSSColor color, int width, int style) {
        super.setTopEdge(color, width);
        this.topStyle = style;
    }
}

