/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.java2d;

import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.framework.ExtendedFont;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Hashtable;

public class J2DExtendedFont
implements ExtendedFont {
    private FontRenderContext fontRenderContext;
    private Font font;
    private String faceName;
    private String style;
    private int weight;
    private String variance;
    private int size;
    private Hashtable fontsAndSizes;
    private long ascent;
    private long descent;
    private long height;
    private long leading;
    private long unitsPerPixel;
    public static String defaultFont;
    private static Hashtable systemFonts;
    private static HashMap fontNameConversion;
    private static char[] glyph;

    static {
        glyph = new char[1];
        J2DExtendedFont.setDefaultSystemFonts();
    }

    public J2DExtendedFont(Graphics2D j2dgraphics, String sFaceName, String nStyle, int nWeight, String nVariance, int nSize, long unitsPerPixel) {
        this.fontRenderContext = j2dgraphics.getFontRenderContext();
        this.faceName = sFaceName;
        this.style = nStyle;
        this.weight = nWeight;
        this.variance = nVariance;
        this.size = nSize;
        sFaceName = J2DExtendedFont.getDefaultSystemFont(sFaceName);
        int style = 0;
        if (nWeight >= 700) {
            style = 1;
        }
        this.font = new Font(sFaceName, style, nSize);
        FontMetrics fm = j2dgraphics.getFontMetrics(this.font);
        this.ascent = (long)fm.getAscent() * unitsPerPixel;
        this.descent = (long)fm.getDescent() * unitsPerPixel;
        this.height = (long)fm.getHeight() * unitsPerPixel;
        this.leading = (long)fm.getLeading() * unitsPerPixel;
        this.fontsAndSizes = new Hashtable(0);
        this.unitsPerPixel = unitsPerPixel;
    }

    private void computeCharacterMetrics(char ch) {
        J2DExtendedFont.glyph[0] = ch;
        GlyphVector glyphVector = this.font.createGlyphVector(this.fontRenderContext, glyph);
        GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
        float lsb = glyphMetrics.getLSB();
        float rsb = glyphMetrics.getRSB();
        Rectangle2D blackBox = glyphMetrics.getBounds2D();
        long fDepth = this.descent;
        if (fDepth < 0L) {
            fDepth = 0L;
        }
        FontSizesAtom fontSizesAtom = new FontSizesAtom();
        fontSizesAtom.depths = fDepth;
        fontSizesAtom.heights = (long)(blackBox.getHeight() * (double)this.unitsPerPixel);
        fontSizesAtom.widths = (long)((blackBox.getWidth() + (double)lsb + (double)rsb) * (double)this.unitsPerPixel);
        this.fontsAndSizes.put(new String(glyph), fontSizesAtom);
    }

    public long getAscent() {
        return this.ascent;
    }

    public long getCharacterDepth(char ch) {
        J2DExtendedFont.glyph[0] = ch;
        String useString = new String(glyph);
        if (!this.fontsAndSizes.containsKey(useString)) {
            this.computeCharacterMetrics(ch);
        }
        return ((FontSizesAtom)this.fontsAndSizes.get(useString)).depths;
    }

    public long getCharacterHeight(char ch) {
        J2DExtendedFont.glyph[0] = ch;
        String useString = new String(glyph);
        if (!this.fontsAndSizes.containsKey(useString)) {
            this.computeCharacterMetrics(ch);
        }
        return ((FontSizesAtom)this.fontsAndSizes.get(useString)).heights;
    }

    public long getCharacterVerticalThickness(char ch) {
        return this.getCharacterHeight(ch) + this.getCharacterDepth(ch);
    }

    public long getCharacterWidth(char ch) {
        J2DExtendedFont.glyph[0] = ch;
        String useString = new String(glyph);
        if (!this.fontsAndSizes.containsKey(useString)) {
            this.computeCharacterMetrics(ch);
        }
        return ((FontSizesAtom)this.fontsAndSizes.get(useString)).widths;
    }

    public static String getDefaultSystemFont(String systemFontSet) {
        String keyword = systemFontSet.toLowerCase();
        String conversion = (String)fontNameConversion.get(keyword);
        return conversion == null ? systemFontSet : conversion;
    }

    public long getDescent() {
        return this.descent;
    }

    public String getFaceName() {
        return this.faceName;
    }

    public Font getFont() {
        return this.font;
    }

    public long getHeight() {
        return this.height;
    }

    public long getLeading() {
        return this.leading;
    }

    public long getSize() {
        return this.size;
    }

    public String getStyle() {
        return this.style;
    }

    public CSSExtent getTextExtent(String string) {
        Rectangle2D extent = this.font.getStringBounds(string, this.fontRenderContext);
        return new CSSExtent((long)extent.getWidth() * this.unitsPerPixel, (long)extent.getHeight() * this.unitsPerPixel);
    }

    public String getVariance() {
        return this.variance;
    }

    public long getWeight() {
        return this.weight;
    }

    public int hashCode() {
        return this.font.hashCode();
    }

    private static String pickBestFont(String[] priorityList) {
        String bestFont = defaultFont;
        int index = 0;
        while (bestFont == defaultFont && index < priorityList.length) {
            String s = priorityList[index];
            if (systemFonts.get(s) != null) {
                bestFont = s;
            }
            ++index;
        }
        return bestFont;
    }

    public static void setDefaultSystemFonts() {
        systemFonts = new Hashtable();
        fontNameConversion = new HashMap();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] availableFonts = ge.getAvailableFontFamilyNames();
        int i = 0;
        while (i < availableFonts.length) {
            systemFonts.put(availableFonts[i], availableFonts[i]);
            ++i;
        }
        defaultFont = J2DExtendedFont.pickBestFont(new String[]{"Dialog", "dialog.bold", "dialog.bolditalic", "dialog.italic", "serif", "sans-serif", "system", "helvetica", "arial"});
        String[] fontNames = new String[]{"Dialog", "dialog.bold", "dialog.bolditalic", "dialog.italic"};
        fontNameConversion.put("caption", J2DExtendedFont.pickBestFont(fontNames));
        fontNameConversion.put("icon", J2DExtendedFont.pickBestFont(fontNames));
        fontNameConversion.put("menu", J2DExtendedFont.pickBestFont(fontNames));
        fontNameConversion.put("message-box", J2DExtendedFont.pickBestFont(fontNames));
        fontNameConversion.put("small-caption", J2DExtendedFont.pickBestFont(fontNames));
        fontNameConversion.put("monospace", J2DExtendedFont.pickBestFont(new String[]{"Courier", "Courier New", "monospaced"}));
    }

    public String toString() {
        return "[J2DExtendedFont " + this.faceName + " style:" + this.style + " weight:" + this.weight + " size:" + this.size + " ascent:" + this.ascent + " descent:" + this.descent + " height:" + this.height + " leading:" + this.leading + "]";
    }

    private class FontSizesAtom {
        private long depths = 0L;
        private long heights = 0L;
        private long widths = 0L;
    }
}

