/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.java2d;

import com.ibm.xsl.composer.java2d.ImageAtom;
import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class ImageHolder
implements Runnable {
    public static final int IMAGE_LOAD_TIMEOUT = 60000;
    public static final int IMAGE_REFRESH_TIMEOUT = 10000;
    private Hashtable uriMaster = new Hashtable();
    private Thread updateThread = new Thread(this);

    public ImageHolder() {
        this.updateThread.start();
    }

    public boolean getCompletionFlag(String uri) {
        boolean complete = false;
        ImageAtom imageAtom = (ImageAtom)this.uriMaster.get(uri);
        if (imageAtom != null) {
            complete = imageAtom.getCompletionFlag();
        }
        return complete;
    }

    public Dimension getDimension(String uri) {
        ImageAtom imageAtom = (ImageAtom)this.uriMaster.get(uri);
        if (imageAtom == null) {
            System.out.println("ImageHolder.getDimension: imageAtom was null:" + uri);
            return new Dimension(0, 0);
        }
        return imageAtom.getDimension();
    }

    public Image getImage(String uri) {
        Image image = null;
        ImageAtom imageAtom = (ImageAtom)this.uriMaster.get(uri);
        if (imageAtom != null) {
            image = imageAtom.getImage();
            if (image == null) {
                System.out.println("getImage: image was null for uri:" + uri);
            }
        } else {
            System.out.println("getImage: imageAtom was null");
        }
        return image;
    }

    public ImageAtom getImageAtom(String uri) {
        return (ImageAtom)this.uriMaster.get(uri);
    }

    public void insertURI(URL uri) {
        String imageName = uri.toExternalForm();
        ImageAtom imageAtom = new ImageAtom(imageName, 60000, false);
        this.uriMaster.put(imageName, imageAtom);
    }

    public void run() {
        boolean threadRun = true;
        block2: while (threadRun) {
            try {
                Thread.sleep(10000L);
                Enumeration e = this.uriMaster.elements();
                while (e.hasMoreElements()) {
                    ImageAtom ia = (ImageAtom)e.nextElement();
                    threadRun = false;
                    if (ia.getCompletionFlag() || ia.getImageDownLoadStatus()) continue;
                    String toDelete = ia.getUri();
                    this.uriMaster.remove(toDelete);
                    ImageAtom imageAtom = new ImageAtom(toDelete, 300000, false);
                    this.uriMaster.put(toDelete, imageAtom);
                    threadRun = true;
                    continue block2;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        this.updateThread = null;
    }
}

