/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.java2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class ImageAtom
extends JFrame {
    private String imageResource;
    private URL imageUri;
    private boolean imageComplete = false;
    private Image image;
    private Dimension imageDimension = new Dimension();
    private boolean debugLevel;
    private boolean startedDownloading = true;
    private int imageLoadTimeout;
    private MediaTracker tracker;

    public ImageAtom(String uri, int ilt, boolean debug) {
        this.debugLevel = debug;
        this.imageResource = uri;
        this.imageLoadTimeout = ilt;
        this.tracker = new MediaTracker(this);
        try {
            this.imageUri = new URL(this.imageResource);
            Image defaultLoadImage = Toolkit.getDefaultToolkit().getImage(this.imageUri);
            this.tracker.addImage(defaultLoadImage, 0);
            try {
                if (this.tracker.waitForAll(this.imageLoadTimeout)) {
                    this.image = defaultLoadImage;
                    ImageIcon ii = new ImageIcon(this.image);
                    if (this.debugLevel) {
                        this.iadebug(ii);
                    }
                    this.imageDimension = new Dimension(ii.getIconWidth(), ii.getIconHeight());
                    this.imageComplete = true;
                } else {
                    this.imageComplete = false;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new Error("Could not load " + this.imageUri);
            }
            this.setImageDownLoadStatus(false);
        }
        catch (MalformedURLException e) {
            System.err.println(String.valueOf(String.valueOf(e)) + " loading image, " + this.imageResource);
        }
    }

    public ImageAtom(URL imageUri, int ilt, boolean debug) {
        this.debugLevel = debug;
        this.imageResource = imageUri.toExternalForm();
        this.imageLoadTimeout = ilt;
        this.tracker = new MediaTracker(this);
        Image defaultLoadImage = Toolkit.getDefaultToolkit().getImage(imageUri);
        this.tracker.addImage(defaultLoadImage, 0);
        try {
            if (this.tracker.waitForAll(this.imageLoadTimeout)) {
                this.image = defaultLoadImage;
                ImageIcon ii = new ImageIcon(this.image);
                if (this.debugLevel) {
                    this.iadebug(ii);
                }
                this.imageDimension = new Dimension(ii.getIconWidth(), ii.getIconHeight());
                this.imageComplete = true;
            } else {
                this.imageComplete = false;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Could not load " + imageUri);
        }
        this.setImageDownLoadStatus(false);
    }

    public boolean exists(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public boolean getCompletionFlag() {
        return this.imageComplete;
    }

    public Dimension getDimension() {
        return this.imageDimension;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean getImageDownLoadStatus() {
        return this.startedDownloading;
    }

    public String getUri() {
        return this.imageResource;
    }

    private void iadebug(ImageIcon ii) {
        JScrollPane jsp = new JScrollPane(new JLabel(ii));
        this.getContentPane().add(jsp);
        ((Component)this).setSize(300, 250);
        ((Component)this).setVisible(true);
    }

    private void setImageDownLoadStatus(boolean status) {
        this.startedDownloading = status;
    }
}

