/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.framework;

import com.ibm.xsl.composer.flo.FLODocument;
import com.ibm.xsl.composer.framework.FLOBuildingDocHandler_Sax1;
import com.ibm.xsl.composer.framework.RelativeURL;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.DOMException;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParseXSLFO_Sax1 {
    private static String lastErrorMessage = "";

    static String copyright() {
        return "\n\nLicensed Materials - Property of IBM\nPackages: com.ibm.xsl.composer...\n(C) Copyright IBM Corp. 2000. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    public static String getLastErrorMessage() {
        return lastErrorMessage;
    }

    public static FLODocument processXSLFO(Reader source, URL referenceLocation) {
        FLODocument doc;
        block5: {
            doc = null;
            FLOBuildingDocHandler_Sax1 docHandler = new FLOBuildingDocHandler_Sax1();
            if (referenceLocation != null) {
                RelativeURL.setDocumentLocation(referenceLocation);
            }
            try {
                ParseXSLFO_Sax1.saxParseXML(source, (DocumentHandler)docHandler);
                doc = (FLODocument)((Object)docHandler.getDocument());
            }
            catch (IOException e) {
                System.out.println("Error reading XML stream.");
                System.out.println("IO error message is, " + e.getMessage());
            }
            catch (DOMException e) {
                System.out.println("Failed to import DOM. " + e.getMessage());
                e.printStackTrace();
            }
            catch (SAXException e) {
                System.out.println("Failed to import DOM. " + e.getMessage());
                e.printStackTrace();
                Exception ex = e.getException();
                if (ex == null) break block5;
                System.out.println("Embedded exception is, " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return doc;
    }

    public static FLODocument processXSLFO(String name) {
        FLODocument doc;
        block5: {
            doc = null;
            FLOBuildingDocHandler_Sax1 docHandler = new FLOBuildingDocHandler_Sax1();
            try {
                URL location = RelativeURL.getAbsoluteURLForName(name);
                RelativeURL.setDocumentLocation(location);
                ParseXSLFO_Sax1.saxParseXML(name, (DocumentHandler)docHandler);
                doc = (FLODocument)((Object)docHandler.getDocument());
            }
            catch (MalformedURLException exc) {
                lastErrorMessage = String.valueOf(String.valueOf(exc)) + " on name, " + name;
                System.out.println(lastErrorMessage);
            }
            catch (FileNotFoundException fileNotFoundException) {
                lastErrorMessage = "Missing XML file, " + name;
                System.out.println(lastErrorMessage);
            }
            catch (IOException e) {
                lastErrorMessage = "Error reading XML file, " + name;
                System.out.println(lastErrorMessage);
                System.out.println("IO error message is, " + e.getMessage());
            }
            catch (SAXException e) {
                lastErrorMessage = "Failed to parse input. " + e.getMessage();
                System.out.println(lastErrorMessage);
                e.printStackTrace();
                Exception ex = e.getException();
                if (ex == null) break block5;
                System.out.println("Embedded exception is, " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return doc;
    }

    public static void saxParseXML(Reader input, DocumentHandler docHandler) throws SAXException, SAXParseException, IOException {
        InputSource source = new InputSource(input);
        ParseXSLFO_Sax1.saxParseXML(source, docHandler);
    }

    public static void saxParseXML(String name, DocumentHandler docHandler) throws SAXException, SAXParseException, IOException {
        InputSource source = new InputSource(name);
        ParseXSLFO_Sax1.saxParseXML(source, docHandler);
    }

    public static void saxParseXML(InputSource source, DocumentHandler docHandler) throws SAXException, SAXParseException, IOException {
        SAXParser parser = new SAXParser();
        parser.setFeature("http://xml.org/sax/features/namespaces", true);
        parser.setDocumentHandler(docHandler);
        parser.parse(source);
    }
}

