/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo.table;

import com.ibm.xsl.composer.flo.table.FLOTableCell;
import com.ibm.xsl.composer.flo.table.FLOTableElement;
import com.ibm.xsl.composer.flo.table.FLOTableRowGroup;
import com.ibm.xsl.composer.prim.Size;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FLOTableRow
extends FLOTableElement {
    private int rowNumber = 0;
    private Size rpd = new Size();
    private boolean prevRowComputed;
    private FLOTableRow prevRow;
    private boolean follRowComputed;
    private FLOTableRow follRow;
    private List cellsIntersecting;
    private List cellsStarting;

    public FLOTableRow(DocumentImpl doc) {
        this(doc, "table-row");
    }

    public FLOTableRow(DocumentImpl doc, String name) {
        super(doc, name);
    }

    private FLOTableRow computeAdjacent(boolean following) {
        FLOTableRow r = this.computeAdjacentInGroup(following);
        if (r != null) {
            return r;
        }
        FLOTableRowGroup rg = this.getRowGroup().getAdjacent(following);
        if (rg != null) {
            return following ? rg.getLastRow() : rg.getFirstRow();
        }
        return null;
    }

    private FLOTableRow computeAdjacentInGroup(boolean following) {
        Element n;
        Element element = n = following ? this.getNextSiblingElement() : this.getPreviousSiblingElement();
        if (n instanceof FLOTableRow) {
            return (FLOTableRow)((Object)n);
        }
        if (n != null) {
            throw new IllegalStateException(n.toString());
        }
        return null;
    }

    private List findCells0(List l, Node n, boolean ignoreRowNumber, boolean startsInRow) {
        block4: {
            block2: {
                FLOTableCell c;
                block3: {
                    if (!(n instanceof FLOTableCell)) break block2;
                    c = (FLOTableCell)((Object)n);
                    if (!ignoreRowNumber) break block3;
                    l.add(n);
                    break block4;
                }
                if ((!startsInRow || !c.startsInRow(this)) && (startsInRow || !c.spansRow(this))) break block4;
                l.add(n);
                break block4;
            }
            if (n instanceof FLOTableRow) {
                NodeList nodes = n.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    this.findCells0(l, nodes.item(i), ignoreRowNumber, startsInRow);
                    ++i;
                }
            }
        }
        return l;
    }

    private List findCellsOrdered(boolean startsInRow) {
        TreeSet ss = new TreeSet(new ColumnComparator());
        ss.addAll(this.findCellsUnordered(false, startsInRow));
        return new Vector(ss);
    }

    private List findCellsUnordered(boolean ignoreRowNumber, boolean startsInRow) {
        return this.findCells0(new Vector(), (Node)((Object)this), ignoreRowNumber, startsInRow);
    }

    public FLOTableRow getAdjacent(boolean following) {
        if (following) {
            if (!this.follRowComputed) {
                this.follRow = this.computeAdjacent(true);
                this.follRowComputed = true;
            }
            return this.follRow;
        }
        if (!this.prevRowComputed) {
            this.prevRow = this.computeAdjacent(false);
            this.prevRowComputed = true;
        }
        return this.prevRow;
    }

    public List getCells() {
        return this.getCellsStarting();
    }

    public List getCellsIntersecting() {
        return this.cellsIntersecting != null ? this.cellsIntersecting : (this.cellsIntersecting = this.findCellsOrdered(false));
    }

    public List getCellsIntersectingUnordered() {
        return this.findCellsUnordered(false, false);
    }

    public List getCellsStarting() {
        return this.cellsStarting != null ? this.cellsStarting : (this.cellsStarting = this.findCellsOrdered(true));
    }

    public List getCellsStartingUnordered() {
        return this.findCellsUnordered(false, true);
    }

    public List getCellsUnordered() {
        return this.findCellsUnordered(true, false);
    }

    public Size getRPD() {
        return new Size(this.rpd);
    }

    public Size getRPDRef() {
        return this.rpd;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public long getWidth(long[] units) {
        throw new UnsupportedOperationException("explicit width not supported");
    }

    public boolean hasExplicitWidth() {
        return false;
    }

    public boolean isInRowGroup(FLOTableRowGroup rg) {
        return this.getRowGroup() == rg;
    }

    public void setRPD(Size rpd) {
        this.rpd.copy(rpd);
    }

    public void setRowNumber(int rowNumber) {
        if (this.rowNumber != 0) {
            throw new IllegalStateException();
        }
        this.rowNumber = rowNumber;
    }

    public String toString() {
        return "ROW[" + this.getRowNumber() + "]";
    }

    private class ColumnComparator
    implements Comparator {
        ColumnComparator() {
        }

        public int compare(Object o1, Object o2) {
            int cn2;
            int cn1 = ((FLOTableCell)o1).getColumnNumber();
            if (cn1 < (cn2 = ((FLOTableCell)o2).getColumnNumber())) {
                return -1;
            }
            if (cn1 > cn2) {
                return 1;
            }
            return 0;
        }
    }
}

