/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo.table;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.csstypes.CSSColorWithAlpha;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLODocument;
import com.ibm.xsl.composer.flo.table.AreaEdge;
import com.ibm.xsl.composer.flo.table.FLOTableCell;
import com.ibm.xsl.composer.flo.table.FLOTableColumn;
import com.ibm.xsl.composer.flo.table.FLOTableColumnGroup;
import com.ibm.xsl.composer.flo.table.FLOTableElement;
import com.ibm.xsl.composer.flo.table.FLOTableRow;
import com.ibm.xsl.composer.flo.table.FLOTableRowGroup;
import com.ibm.xsl.composer.flo.table.TableBorderBehavior;
import com.ibm.xsl.composer.flo.table.TableBorderBehaviorCollapse;
import com.ibm.xsl.composer.flo.table.TableBorderBehaviorSeparate;
import com.ibm.xsl.composer.flo.table.TableLayoutBehavior;
import com.ibm.xsl.composer.flo.table.TableLayoutBehaviorAuto;
import com.ibm.xsl.composer.flo.table.TableLayoutBehaviorFixed;
import com.ibm.xsl.composer.framework.EndElementHandler;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.Size;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FLOTable
extends FLOTableElement {
    private Size rpd = new Size();
    private Size cpd = new Size();
    private List rows;
    private List columns;
    private GeneralArea area;
    private boolean synthesizedImpliedColumns;
    private boolean synthesizedImpliedRows;
    private static Set initEndElementHandlerForDocuments = new HashSet();

    public FLOTable(DocumentImpl doc) {
        this(doc, "table");
    }

    public FLOTable(DocumentImpl doc, String name) {
        super(doc, name);
        this.maybeInitEndElementHandler(doc);
    }

    protected void addBehaviorsForArea(GeneralArea a, ComposeInfo ci) {
        super.addBehaviorsForArea(a, ci);
    }

    protected void addTraitsForArea(GeneralArea a, ComposeInfo ci) {
        super.addTraitsForArea(a, ci);
    }

    private int compose(ComposeInfo ci, Extent ae, SpaceRequest r, GeneralArea a) {
        TableBorderBehavior bb = this.createBorderBehavior(ci);
        bb.performBehavior();
        TableLayoutBehavior lb = this.createLayoutBehavior(ci, ae);
        lb.performBehavior();
        return this.composeRows(ci, ae, r, a);
    }

    public GeneralArea composeAreas(ComposeInfo ci, Extent ae, SpaceRequest r) {
        GeneralArea a = this.area;
        if (a == null) {
            throw new IllegalStateException();
        }
        this.generateDescendentAreas(ci, ae, r, a);
        this.addProgeny(a);
        return a;
    }

    private int composeRows(ComposeInfo ci, Extent ae, SpaceRequest r, GeneralArea a) {
        Iterator it = this.getRows().iterator();
        while (it.hasNext()) {
            FLOTableRow row = (FLOTableRow)it.next();
            Size rpd = row.getRPDRef();
            SpaceRequest rr = new SpaceRequest(row, null);
            rr.setAreaMinimumOptimumMaximum(rpd.getMinimum(), rpd.getOptimum(), rpd.getMaximum());
            Iterator cit = row.getCells().iterator();
            while (cit.hasNext()) {
                FLOTableCell c = (FLOTableCell)cit.next();
                Extent ce = new Extent(rpd.getOptimum(), c.getCPDRef().getOptimum());
                SpaceAlternatives sa = c.composeRequest(ci, ce, null);
                rr.addRequest(sa.getFirstBodyRequest());
            }
            r.incorporateRequest(rr);
        }
        return 0;
    }

    protected GeneralArea createArea(ComposeInfo ci, Extent ea) {
        this.area = new GeneralArea();
        return this.area;
    }

    private TableBorderBehavior createBorderBehavior(ComposeInfo ci) {
        if (this.isCollapsingBorders()) {
            return new TableBorderBehaviorCollapse(ci.context, this, true);
        }
        return new TableBorderBehaviorSeparate(ci.context, this);
    }

    private TableLayoutBehavior createLayoutBehavior(ComposeInfo ci, Extent ae) {
        if (this.isAutoLayout()) {
            return new TableLayoutBehaviorAuto(ci.context, this, ae);
        }
        return new TableLayoutBehaviorFixed(ci.context, this, ae);
    }

    private void endElement() {
        this.numberColumns();
        this.numberRows();
        this.numberCells();
    }

    private List findColumns() {
        if (!this.synthesizedImpliedColumns) {
            this.synthesizeImpliedColumns();
        }
        return this.findColumns0(new Vector(), (Node)((Object)this));
    }

    private List findColumns0(List l, Node n) {
        block3: {
            block4: {
                block2: {
                    if (!(n instanceof FLOTableColumn)) break block2;
                    l.add(n);
                    break block3;
                }
                if (!(n instanceof FLOTableColumnGroup)) break block4;
                NodeList nodes = n.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    this.findColumns0(l, nodes.item(i));
                    ++i;
                }
                break block3;
            }
            if (!(n instanceof FLOTable)) break block3;
            NodeList nodes = n.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                this.findColumns0(l, nodes.item(i));
                ++i;
            }
        }
        return l;
    }

    private List findRows() {
        if (!this.synthesizedImpliedRows) {
            this.synthesizeImpliedRows();
        }
        return this.findRows0(new Vector(), (Node)((Object)this));
    }

    private List findRows0(List l, Node n) {
        block3: {
            block4: {
                block2: {
                    if (!(n instanceof FLOTableRow)) break block2;
                    l.add(n);
                    break block3;
                }
                if (!(n instanceof FLOTableRowGroup)) break block4;
                NodeList nodes = n.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    this.findRows0(l, nodes.item(i));
                    ++i;
                }
                break block3;
            }
            if (!(n instanceof FLOTable)) break block3;
            NodeList nodes = n.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                this.findRows0(l, nodes.item(i));
                ++i;
            }
        }
        return l;
    }

    private void generateDescendentAreas(ComposeInfo ci, Extent ae, SpaceRequest r, GeneralArea a) {
        FLOPoint pt = new FLOPoint();
        Iterator it = r.getChildRequests();
        while (it.hasNext()) {
            SpaceRequest rr = (SpaceRequest)it.next();
            FLOTableRow row = (FLOTableRow)rr.getFormatter();
            Size rpd = row.getRPDRef();
            pt.start = 0L;
            Iterator cit = rr.getChildRequests();
            while (cit.hasNext()) {
                Extent ce;
                SpaceRequest cr = (SpaceRequest)cit.next();
                FLOTableCell c = (FLOTableCell)cr.getFormatter();
                GeneralArea ca = c.composeAreas(ci, ce = new Extent(rpd.getOptimum(), c.getCPDRef().getOptimum()), cr);
                if (ca != null) {
                    ca.setLocation(pt);
                    a.addChild(ca);
                }
                pt.start += c.getCPDRef().getOptimum();
            }
            pt.before += rpd.getOptimum();
        }
    }

    protected int generateRequest(SpaceRequest r, ComposeInfo ci, Extent ae, SpaceRequest pr) {
        GeneralArea a = this.area;
        if (a == null) {
            throw new IllegalStateException();
        }
        Extent ce = new Extent(ae);
        a.adjustAvailable(ce);
        int fit = this.compose(ci, ae, r, a);
        a.elaborateRequest(r, 1);
        return fit;
    }

    public Size getCPD() {
        return new Size(this.cpd);
    }

    public Size getCPDRef() {
        return this.cpd;
    }

    public List getColumns() {
        return this.columns != null ? this.columns : (this.columns = this.findColumns());
    }

    public Size getRPD() {
        return new Size(this.rpd);
    }

    public Size getRPDRef() {
        return this.rpd;
    }

    public List getRows() {
        return this.rows != null ? this.rows : (this.rows = this.findRows());
    }

    protected void initialize() {
        super.initialize();
    }

    public boolean isAutoLayout() {
        return this.getProperties().getTableProperty().getTableLayout().equals("auto");
    }

    public boolean isCollapsingBorders() {
        return this.getProperties().getTableProperty().getBorderCollapse().equals("collapse");
    }

    private void maybeInitEndElementHandler(DocumentImpl doc) {
        if (!initEndElementHandlerForDocuments.contains(doc)) {
            ((FLODocument)doc).addEndElementHandler(this.getTagName(), new TableEndElementHandler());
            initEndElementHandlerForDocuments.add(doc);
        }
    }

    private void numberCells() {
        List rows = this.getRows();
        boolean rowNum = true;
        Iterator rit = rows.iterator();
        while (rit.hasNext()) {
            FLOTableRow r = (FLOTableRow)rit.next();
            int rn = r.getRowNumber();
            List cells = r.getCellsUnordered();
            FLOTableCell lc = null;
            FLOTableCell c = null;
            Iterator cit = cells.iterator();
            while (cit.hasNext()) {
                c = (FLOTableCell)cit.next();
                c.setRowNumber(rn);
                c.setColumnNumber(lc == null ? 1 : lc.getColumnNumber() + lc.getNumberColumnsSpanned());
                lc = c;
            }
        }
    }

    private void numberColumns() {
        List cols = this.getColumns();
        int colNum = 1;
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            ((FLOTableColumn)it.next()).setColumnNumber(colNum++);
        }
    }

    private void numberRows() {
        List rows = this.getRows();
        int rowNum = 1;
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            ((FLOTableRow)it.next()).setRowNumber(rowNum++);
        }
    }

    public void setBorderTraits(AreaEdge edge, CSSColorWithAlpha color, long width, int style) {
    }

    public void setCPD(Size cpd) {
        this.cpd.copy(cpd);
    }

    public void setRPD(Size rpd) {
        this.rpd.copy(rpd);
    }

    private void synthesizeImpliedColumns() {
    }

    private void synthesizeImpliedRows() {
    }

    public String toString() {
        return "TBL";
    }

    private static class TableEndElementHandler
    implements EndElementHandler {
        TableEndElementHandler() {
        }

        public void endElement(Element e) {
            if (e instanceof FLOTable) {
                ((FLOTable)((Object)e)).endElement();
            }
        }
    }
}

