/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo.table;

import com.ibm.xsl.composer.areas.BorderBehavior;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.flo.table.AreaEdge;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.prim.Border;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class CollapsingBorderBehavior
extends BorderBehavior {
    private static final int[] borderStylePrecedence;
    private static final CSSColor black;

    static {
        int[] nArray = new int[10];
        nArray[1] = 9;
        nArray[2] = 5;
        nArray[3] = 6;
        nArray[4] = 7;
        nArray[5] = 8;
        nArray[6] = 2;
        nArray[7] = 4;
        nArray[8] = 1;
        nArray[9] = 3;
        borderStylePrecedence = nArray;
        black = new CSSColor();
    }

    private Map computePaintOrder() {
        TreeMap<Border, AreaEdge> m = new TreeMap<Border, AreaEdge>(new BorderComparator());
        m.put(this.borderBefore, AreaEdge.BEFORE);
        m.put(this.borderAfter, AreaEdge.AFTER);
        m.put(this.borderStart, AreaEdge.START);
        m.put(this.borderEnd, AreaEdge.END);
        return m;
    }

    protected void doPaint(Context context, CSSPoint pt, CSSExtent e) {
        Map m = this.computePaintOrder();
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Border b = (Border)it.next();
            this.paintBorder(context, pt, e, b, (AreaEdge)m.get(b));
        }
    }

    public static int mapBorderStyleToPrecedence(int style) {
        if (style >= 0 && style <= 9) {
            return borderStylePrecedence[style];
        }
        throw new IllegalArgumentException();
    }

    private void paintBorder(Context context, CSSPoint pt, CSSExtent e, Border b, AreaEdge edge) {
        Border bb = new Border(black, this.borderBefore.width, 1);
        Border ba = new Border(black, this.borderAfter.width, 1);
        Border bs = new Border(black, this.borderStart.width, 1);
        Border be = new Border(black, this.borderEnd.width, 1);
        if (edge == AreaEdge.BEFORE) {
            bb = b;
        } else if (edge == AreaEdge.AFTER) {
            ba = b;
        } else if (edge == AreaEdge.START) {
            bs = b;
        } else if (edge == AreaEdge.END) {
            be = b;
        } else {
            throw new IllegalArgumentException();
        }
        context.drawBorder(bb, bs, ba, be, new CSSPoint(pt), new CSSExtent(e));
    }

    public void setBorderTraits(AreaEdge edge, Border b) {
        if (edge == AreaEdge.BEFORE) {
            this.borderBefore = b;
        } else if (edge == AreaEdge.AFTER) {
            this.borderAfter = b;
        } else if (edge == AreaEdge.START) {
            this.borderStart = b;
        } else if (edge == AreaEdge.END) {
            this.borderEnd = b;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private class BorderComparator
    implements Comparator {
        BorderComparator() {
        }

        public int compare(Object o1, Object o2) {
            Border b1 = (Border)o1;
            Border b2 = (Border)o2;
            int d = this.compareWidths(b1, b2);
            if (d != 0) {
                return d;
            }
            d = this.compareStyles(b1, b2);
            if (d != 0) {
                return d;
            }
            d = this.compareColors(b1, b2);
            if (d != 0) {
                return d;
            }
            return this.compareHashcodes(b1, b2);
        }

        private int compareColors(Border b1, Border b2) {
            short y2;
            short y1 = this.computeLuminance(b1.color);
            if (y1 > (y2 = this.computeLuminance(b2.color))) {
                return -1;
            }
            if (y1 < y2) {
                return 1;
            }
            return 0;
        }

        private int compareHashcodes(Border b1, Border b2) {
            int h2;
            int h1 = b1.hashCode();
            if (h1 < (h2 = b2.hashCode())) {
                return -1;
            }
            if (h1 > h2) {
                return 1;
            }
            return 0;
        }

        private int compareStyles(Border b1, Border b2) {
            int p2;
            int p1 = CollapsingBorderBehavior.mapBorderStyleToPrecedence(b1.style);
            if (p1 < (p2 = CollapsingBorderBehavior.mapBorderStyleToPrecedence(b2.style))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int compareWidths(Border b1, Border b2) {
            if (b1.width < b2.width) {
                return -1;
            }
            if (b1.width > b2.width) {
                return 1;
            }
            return 0;
        }

        private short computeLuminance(CSSColor c) {
            return (short)(0.299 * (double)c.red + 0.587 * (double)c.green + 0.114 * (double)c.blue);
        }
    }
}

