/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ColumnFormatter;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import java.util.Iterator;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class RowFormatter
extends FLOElement {
    private ChildNodeWalker walker;
    private SpaceRequest lastChildRequest;

    public RowFormatter(DocumentImpl ownerDocument) {
        super(ownerDocument, "table-body");
    }

    public RowFormatter(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        GeneralArea blockArea = chosenRequest.getRequestorArea();
        SpaceRequest totalHeight = new SpaceRequest();
        FLOPoint curPoint = new FLOPoint(0L, 0L);
        Extent childAllocation = new Extent(allocated);
        Iterator rowRequests = chosenRequest.getChildRequests();
        ComposeInfo childComposeInfo = new ComposeInfo(composeInfo, allocated);
        while (rowRequests.hasNext()) {
            SpaceRequest rowRequest = (SpaceRequest)rowRequests.next();
            ColumnFormatter blockNode = (ColumnFormatter)rowRequest.getFormatter();
            childAllocation.setBPD(rowRequest.getOptimum());
            GeneralArea childArea = blockNode.composeAreas(childComposeInfo, childAllocation, rowRequest);
            curPoint.before += totalHeight.getInterSpace(rowRequest).getOptimum();
            childArea.setLocation(curPoint);
            blockArea.addChild(childArea);
            totalHeight.appendRequest(rowRequest);
            curPoint.before = totalHeight.getAreaOptimum();
        }
        return blockArea;
    }

    public SpaceAlternatives composeRequest(ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        SpaceAlternatives alternatives = new SpaceAlternatives();
        alternatives.setFit(0);
        if (priorRequest != null) {
            this.walker.setCurrentNode((Node)priorRequest.getCursor());
            this.lastChildRequest = priorRequest.getLastChildRequest();
        } else {
            this.walker = new ChildNodeWalker((Node)((Object)this));
            this.walker.getNext();
            this.skipToAColumnFormatter();
        }
        ComposeInfo childComposeInfo = new ComposeInfo(composeInfo, available);
        if (this.walker.getCurrentNode() != null) {
            GeneralArea blockArea = new GeneralArea();
            blockArea.initializeTraits(composeInfo, this.properties);
            blockArea.setProgenitor(this);
            blockArea.adjustAvailable(available);
            SpaceRequest returnRequest = new SpaceRequest(this, blockArea);
            boolean exceeded = false;
            boolean progress = false;
            SpaceRequest totalBPD = new SpaceRequest();
            Extent remaining = new Extent(available);
            SpaceAlternatives nextAlternatives = this.generateNextAlternatives(childComposeInfo, remaining);
            while (!(nextAlternatives == null || progress && exceeded)) {
                SpaceRequest request;
                int fit = nextAlternatives.getFit();
                if (fit == 0) {
                    request = nextAlternatives.getFirstBodyRequest();
                    totalBPD.appendRequest(request);
                    returnRequest.incorporateRequest(request);
                    returnRequest.setCursor(this.walker.getCurrentNode());
                    this.lastChildRequest = request;
                    long consumed = totalBPD.getOptimum();
                    remaining.setBPD(available.bpd - consumed);
                    nextAlternatives = this.generateNextAlternatives(childComposeInfo, remaining);
                    progress = true;
                    continue;
                }
                if (fit == 2) {
                    nextAlternatives = this.generateNextAlternatives(childComposeInfo, remaining);
                    continue;
                }
                if (fit != 1) continue;
                if (!progress) {
                    request = nextAlternatives.getFirstBodyRequest();
                    totalBPD.appendRequest(request);
                    returnRequest.incorporateRequest(request);
                    returnRequest.setCursor(this.walker.getCurrentNode());
                    this.lastChildRequest = request;
                    progress = true;
                    alternatives.setFit(1);
                }
                exceeded = true;
            }
            if (nextAlternatives == null && !progress) {
                alternatives.setFit(2);
            }
            alternatives.addSpaceRequest(returnRequest);
        } else {
            alternatives.setFit(2);
        }
        return alternatives;
    }

    private SpaceAlternatives generateNextAlternatives(ComposeInfo composeInfo, Extent available) {
        SpaceAlternatives alternatives;
        if (this.walker.getCurrentNode() != null) {
            alternatives = ((ColumnFormatter)((Object)this.walker.getCurrentNode())).composeRequest(composeInfo, available, this.lastChildRequest);
            if (alternatives.getFit() == 2) {
                this.walker.getNext();
                this.skipToAColumnFormatter();
            }
        } else {
            alternatives = null;
        }
        return alternatives;
    }

    public void reset() {
        super.reset();
    }

    private void skipToAColumnFormatter() {
        while (this.walker.getCurrentNode() != null && !(this.walker.getCurrentNode() instanceof ColumnFormatter)) {
            this.walker.getNext();
        }
        this.lastChildRequest = null;
    }

    public String toString() {
        return "[fo:table(RowFormatter) " + this.hashCode() + "]";
    }
}

