/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.GlyphBehavior;
import com.ibm.xsl.composer.areas.LineArea;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLO;
import com.ibm.xsl.composer.flo.FLODocument;
import com.ibm.xsl.composer.flo.InlineContent;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.Space;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BlockAndLineRelatedProperty;
import com.ibm.xsl.composer.properties.FontProperty;
import com.ibm.xsl.composer.properties.Propertied;
import com.ibm.xsl.composer.properties.PropertyHolder;
import com.ibm.xsl.composer.properties.PropertyMap;
import com.ibm.xsl.composer.util.CharacterSource;
import com.ibm.xsl.composer.util.IgnoreCharacterSource;
import com.ibm.xsl.composer.util.ReplaceCharacterSource;
import com.ibm.xsl.composer.util.SpaceCollapseCharacterSource;
import com.ibm.xsl.composer.util.SpaceIgnoreAfterCharacterSource;
import com.ibm.xsl.composer.util.SpaceIgnoreBeforeCharacterSource;
import com.ibm.xsl.composer.util.StringCharacterSource;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.Node;

public class FLOText
extends TextImpl
implements FLO,
InlineContent,
Propertied {
    protected PropertyHolder propertyHolder = new PropertyHolder(this);
    private StringBuffer charsInText = new StringBuffer();
    private String rawText;
    private int currentChar;
    private boolean haveInitialized = false;
    private int spaceCount = 0;
    private Space spaceAfter = Space.EMPTY;
    boolean whiteSpaceCollapse;
    private ArrayList progeny = new ArrayList();
    protected PropertyMap properties = new PropertyMap(this.propertyHolder);

    public FLOText(DocumentImpl ownerDocument, String text, FLODocument masterDocument, Node parent) {
        super(ownerDocument, text);
        this.rawText = text;
    }

    public final void addProgeny(GeneralArea areaSubtree) {
        this.progeny.add(areaSubtree);
    }

    private int advanceSpaces() {
        int start = this.currentChar;
        while (this.currentChar < this.charsInText.length() && this.charsInText.charAt(this.currentChar) == ' ') {
            ++this.currentChar;
        }
        return this.currentChar - start;
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        LineArea inlineArea = (LineArea)chosenRequest.getRequestorArea();
        SpaceRequest totalWidth = new SpaceRequest();
        FLOPoint curPoint = new FLOPoint(0L, 0L);
        Iterator glyphs = chosenRequest.getChildRequests();
        while (glyphs.hasNext()) {
            SpaceRequest glyphRequest = (SpaceRequest)glyphs.next();
            GeneralArea glyphArea = glyphRequest.getRequestorArea();
            glyphArea.setLocation(curPoint);
            inlineArea.addChild(glyphArea);
            inlineArea.extendContentArea(curPoint, glyphArea.getExtent());
            totalWidth.appendRequest(glyphRequest);
            curPoint.start = totalWidth.getAreaOptimum();
        }
        inlineArea.alignChildren();
        this.addProgeny(inlineArea);
        return inlineArea;
    }

    public SpaceAlternatives composeRequest(ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        SpaceRequest nextWord;
        if (!this.haveInitialized) {
            this.initialize();
        }
        this.currentChar = priorRequest == null ? 0 : (Integer)priorRequest.getCursor();
        LineArea inlineArea = new LineArea();
        SpaceAlternatives result = new SpaceAlternatives();
        result.setFit(2);
        boolean haveWord = false;
        if (this.hasNextGlyphArea() && this.getCurrent() == '\n') {
            nextWord = new SpaceRequest(this, inlineArea);
            nextWord.setAreaOptimum(Integer.MAX_VALUE);
            ++this.currentChar;
        } else {
            nextWord = this.getNextWord(composeInfo);
        }
        if (nextWord != null) {
            result.addSpaceRequest(nextWord);
            result.setFit(0);
            if (available.ipd < nextWord.getOptimum()) {
                result.setFit(1);
            }
            nextWord.setRequestorArea(inlineArea);
            nextWord.setCursor(new Integer(this.currentChar));
        }
        return result;
    }

    private char getCurrent() {
        return this.charsInText.charAt(this.currentChar);
    }

    private GeneralArea getNextGlyphArea(ExtendedFont font) {
        char tempchar = this.getCurrent();
        GeneralArea area = new GeneralArea();
        area.setProgenitor(this);
        GlyphBehavior glyph = new GlyphBehavior(font, tempchar);
        area.addBehavior(glyph);
        ++this.currentChar;
        return area;
    }

    private SpaceRequest getNextWord(ComposeInfo composeInfo) {
        SpaceRequest wordRequest = null;
        FontProperty fp = this.properties.getFontProperty();
        ExtendedFont font = composeInfo.context.getExtendedFont(fp);
        boolean haveWord = false;
        boolean progress = false;
        Space spaceBefore = Space.EMPTY;
        int count = this.advanceSpaces();
        if (count != 0) {
            spaceBefore = new Space(font.getCharacterWidth(' ') * (long)count);
        }
        while (!haveWord && this.hasNextGlyphArea()) {
            char ch = this.getCurrent();
            boolean bl = haveWord = progress && ch == ' ';
            if (!haveWord) {
                if (ch == ' ' || ch == '\n') continue;
                GeneralArea chArea = this.getNextGlyphArea(font);
                if (wordRequest == null) {
                    wordRequest = new SpaceRequest(this, chArea);
                }
                chArea.initializeTraits(composeInfo, this.properties);
                Extent areaSize = chArea.getExtent();
                SpaceRequest glyphRequest = new SpaceRequest(this, chArea);
                glyphRequest.setAreaOptimum(areaSize.ipd);
                wordRequest.incorporateRequest(glyphRequest);
                progress = true;
                continue;
            }
            count = this.advanceSpaces();
            if (count != this.spaceCount) {
                this.spaceAfter = count > 0 ? new Space(font.getCharacterWidth(' ') * (long)count, 1) : Space.EMPTY;
                this.spaceCount = count;
            }
            wordRequest.setBefore(spaceBefore);
            wordRequest.setAfter(this.spaceAfter);
        }
        return wordRequest;
    }

    public Propertied getParent() {
        return (Propertied)((Object)this.getParentNode());
    }

    public final ListIterator getProgeny() {
        return ((AbstractList)this.progeny).listIterator();
    }

    public PropertyMap getProperties() {
        return this.properties;
    }

    public PropertyHolder getPropertyHolder() {
        return this.propertyHolder;
    }

    public String getText() {
        if (!this.haveInitialized) {
            this.initialize();
        }
        return this.charsInText.toString();
    }

    private boolean hasNextGlyphArea() {
        return this.currentChar < this.charsInText.length();
    }

    private void initialize() {
        BlockAndLineRelatedProperty blrp = this.properties.getBlockAndLineRelatedProperty();
        CharacterSource rawTextSource = new StringCharacterSource(this.rawText);
        switch (blrp.getLinefeedTreatment()) {
            case 0: {
                rawTextSource = new IgnoreCharacterSource(rawTextSource, 10);
                break;
            }
            case 2: {
                rawTextSource = new ReplaceCharacterSource(rawTextSource, 10, 32);
                break;
            }
        }
        switch (blrp.getSpaceTreatment()) {
            case 0: {
                rawTextSource = new IgnoreCharacterSource(rawTextSource, 32);
                break;
            }
            case 2: {
                rawTextSource = new SpaceIgnoreBeforeCharacterSource(rawTextSource);
                break;
            }
            case 3: {
                rawTextSource = new SpaceIgnoreAfterCharacterSource(rawTextSource);
                break;
            }
            case 4: {
                rawTextSource = new SpaceIgnoreBeforeCharacterSource(rawTextSource);
                rawTextSource = new SpaceIgnoreAfterCharacterSource(rawTextSource);
                break;
            }
        }
        this.whiteSpaceCollapse = blrp.getWhiteSpaceCollapse();
        if (this.whiteSpaceCollapse) {
            rawTextSource = new SpaceCollapseCharacterSource(rawTextSource);
            rawTextSource = new SpaceIgnoreBeforeCharacterSource(rawTextSource);
            rawTextSource = new SpaceIgnoreAfterCharacterSource(rawTextSource);
        }
        int next = rawTextSource.next();
        while (next != -1) {
            this.charsInText.append((char)next);
            next = rawTextSource.next();
        }
        this.currentChar = 0;
        this.haveInitialized = true;
    }

    public void propogateAttributes(PropertyMap parentValues) {
        this.properties.propogateAttributes((Node)((Object)this), parentValues);
    }

    public void reset() {
        this.progeny.clear();
    }

    public String toString() {
        return "[fo:text " + Integer.toHexString(this.hashCode()) + "]";
    }
}

