/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.flo.BlockContent;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.flo.FLOFormattable;
import com.ibm.xsl.composer.flo.RowFormatter;
import com.ibm.xsl.composer.prim.ColumnSpecs;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.PropertyMap;
import java.util.Iterator;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOTable
extends FLOFormattable
implements BlockContent {
    private RowFormatter body;
    private RowFormatter header;
    private RowFormatter footer;
    private ColumnSpecs columns = new ColumnSpecs();

    public FLOTable(DocumentImpl ownerDocument) {
        this(ownerDocument, "table");
    }

    public FLOTable(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        GeneralArea areaSubtree = chosenRequest.getRequestorArea();
        SpaceRequest totalHeight = new SpaceRequest();
        FLOPoint curPoint = new FLOPoint(0L, 0L);
        Extent childAllocation = new Extent(allocated);
        Iterator tableRequests = chosenRequest.getChildRequests();
        ComposeInfo childComposeInfo = new ComposeInfo(composeInfo);
        childComposeInfo.columns = this.columns;
        while (tableRequests.hasNext()) {
            SpaceRequest tableRequest = (SpaceRequest)tableRequests.next();
            RowFormatter blockNode = (RowFormatter)tableRequest.getFormatter();
            childAllocation.setBPD(tableRequest.getOptimum());
            GeneralArea childArea = blockNode.composeAreas(childComposeInfo, childAllocation, tableRequest);
            curPoint.before += totalHeight.getInterSpace(tableRequest).getOptimum();
            childArea.setLocation(curPoint);
            areaSubtree.addChild(childArea);
            totalHeight.appendRequest(tableRequest);
            curPoint.before = totalHeight.getAreaOptimum();
        }
        this.addProgeny(areaSubtree);
        return areaSubtree;
    }

    protected GeneralArea createArea(ComposeInfo composeInfo, Extent available) {
        GeneralArea area = new GeneralArea();
        return area;
    }

    protected int generateRequest(SpaceRequest request, ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        request.getRequestorArea().adjustAvailable(available);
        SpaceRequest bodySpaceRequest = null;
        if (priorRequest != null) {
            bodySpaceRequest = priorRequest.getLastChildRequest();
        }
        ComposeInfo childComposeInfo = new ComposeInfo(composeInfo);
        childComposeInfo.columns = this.columns;
        SpaceAlternatives bodyAlternatives = this.body.composeRequest(childComposeInfo, available, bodySpaceRequest);
        int bodyFit = bodyAlternatives.getFit();
        if (bodyFit != 2) {
            SpaceRequest bodyRequest = bodyAlternatives.getFirstBodyRequest();
            request.incorporateRequest(bodyRequest);
        }
        return bodyFit;
    }

    protected void initialize() {
        ChildNodeWalker walker = new ChildNodeWalker((Node)((Object)this));
        Node child = walker.getNext();
        while (child != null) {
            String childName = child.getLocalName();
            if (childName != null) {
                if (childName.equals("table-column")) {
                    PropertyMap columnProperties = ((FLOElement)((Object)child)).getProperties();
                    this.columns.addColumn(columnProperties);
                } else if (childName.equals("table-body")) {
                    this.body = (RowFormatter)((Object)child);
                } else if (childName.equals("table-header")) {
                    this.header = (RowFormatter)((Object)child);
                } else if (childName.equals("table-footer")) {
                    this.footer = (RowFormatter)((Object)child);
                }
            }
            child = walker.getNext();
        }
    }

    protected boolean isExhausted(SpaceRequest priorRequest) {
        return false;
    }

    public String toString() {
        return "[fo:table " + this.hashCode() + "]";
    }
}

