/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.AreaTree;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.FLOElement;
import com.ibm.xsl.composer.flo.FLOLayoutMasterSet;
import com.ibm.xsl.composer.flo.FLOPageSequence;
import com.ibm.xsl.composer.flo.PageMasterIterator;
import com.ibm.xsl.composer.framework.Context;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLORoot
extends FLOElement {
    private FLOLayoutMasterSet foLayoutMasterSet;

    public FLORoot(DocumentImpl ownerDocument) {
        this(ownerDocument, "root");
    }

    public FLORoot(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
    }

    private void checkInit() {
        if (this.foLayoutMasterSet == null) {
            this.initialize();
        }
    }

    public AreaTree composeDocument(Context context) {
        this.checkInit();
        AreaTree result = new AreaTree();
        ChildNodeWalker walker = new ChildNodeWalker((Node)((Object)this));
        Node child = walker.getNext();
        while (child != null) {
            if (child instanceof FLOPageSequence) {
                FLOPageSequence flowPageSequence = (FLOPageSequence)((Object)child);
                String masterName = flowPageSequence.getMasterName();
                PageMasterIterator pmi = this.foLayoutMasterSet.getPageMaster(masterName);
                if (pmi == null) {
                    System.err.println("There is no page master named, '" + masterName + ".'");
                } else {
                    flowPageSequence.appendPages(context, result, pmi, this.foLayoutMasterSet);
                }
            }
            child = walker.getNext();
        }
        return result;
    }

    private void initialize() {
        ChildNodeWalker walker = new ChildNodeWalker((Node)((Object)this));
        Node child = walker.getNext();
        while (child != null) {
            if (child instanceof FLOLayoutMasterSet && this.foLayoutMasterSet == null) {
                this.foLayoutMasterSet = (FLOLayoutMasterSet)((Object)child);
            }
            child = walker.getNext();
        }
        if (this.foLayoutMasterSet == null) {
            String message = "There is no fo:layout-master-set.\nProcessing cannot continue.";
            throw new IllegalArgumentException(message);
        }
    }
}

