/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOCharacter;
import com.ibm.xsl.composer.flo.FLOFormattable;
import com.ibm.xsl.composer.flo.InlineContent;
import com.ibm.xsl.composer.flo.NestedInlinePacker;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOPageNumber
extends FLOFormattable
implements InlineContent {
    private NestedInlinePacker nestedInlinePacker = new NestedInlinePacker();

    public FLOPageNumber(DocumentImpl ownerDocument) {
        this(ownerDocument, "page-number");
    }

    public FLOPageNumber(DocumentImpl ownerDocument, String name) {
        super(ownerDocument, name);
        this.reset();
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        GeneralArea areaSubtree = this.nestedInlinePacker.composeAreas(composeInfo, allocated, chosenRequest);
        this.addProgeny(areaSubtree);
        return areaSubtree;
    }

    protected String createStringForDisplay(ComposeInfo composeInfo) {
        long pageNumber = composeInfo.pageNumber;
        String pageNumberString = String.valueOf(pageNumber);
        return pageNumberString;
    }

    protected int generateRequest(SpaceRequest request, ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        this.nestedInlinePacker.initialize((Node)((Object)this), null, this.properties);
        String stringForDisplay = this.createStringForDisplay(composeInfo);
        int i = 0;
        while (i < stringForDisplay.length()) {
            FLOCharacter flochar = (FLOCharacter)((Object)this.getOwnerDocument().createElement("fo:character"));
            flochar.setAttribute("character", stringForDisplay.substring(i, i + 1));
            flochar.propogateAttributes(this.properties);
            SpaceAlternatives flocharAlternatives = flochar.composeRequest(composeInfo, available, null);
            request.incorporateRequest(flocharAlternatives.getFirstBodyRequest());
            request.getRequestorArea().addChild(flocharAlternatives.getFirstBodyRequest().getRequestorArea());
            ++i;
        }
        return this.fitOrNoFit(true);
    }

    public String toString() {
        return "[fo:page-number]";
    }
}

