/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.LineArea;
import com.ibm.xsl.composer.areas.RuleBehavior;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLO;
import com.ibm.xsl.composer.flo.FLOCharacter;
import com.ibm.xsl.composer.flo.FLOFormattable;
import com.ibm.xsl.composer.flo.InlineContent;
import com.ibm.xsl.composer.flo.NestedInlinePacker;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.LeaderAndRuleProperty;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOLeader
extends FLOFormattable
implements InlineContent {
    private NestedInlinePacker inline = new NestedInlinePacker();
    private FLOCharacter dotCharacter;

    public FLOLeader(DocumentImpl ownerDocument) {
        this(ownerDocument, "page-number");
    }

    public FLOLeader(DocumentImpl ownerDocument, String name) {
        super(ownerDocument, name);
        this.reset();
    }

    protected void addBehaviorsForArea(GeneralArea area, ComposeInfo composeInfo) {
        LeaderAndRuleProperty larp = this.properties.getLeaderAndRuleProperty();
        if (larp.getLeaderPattern().equalsIgnoreCase("rule")) {
            area.addBehavior(new RuleBehavior());
        }
        this.addStandardBorderAndBackgroundBehavior(area);
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        LeaderAndRuleProperty larp = this.properties.getLeaderAndRuleProperty();
        LineArea inlineArea = (LineArea)chosenRequest.getRequestorArea();
        long sizeDesired = chosenRequest.area.getMaximum();
        if (allocated.getIPD() < chosenRequest.area.getMaximum()) {
            sizeDesired = allocated.getIPD();
        }
        if (larp.getLeaderPattern().equalsIgnoreCase("dots")) {
            if (this.dotCharacter == null) {
                this.dotCharacter = (FLOCharacter)((Object)this.getOwnerDocument().createElement("fo:character"));
                this.dotCharacter.setAttribute("character", ".");
                this.dotCharacter.propogateAttributes(this.properties);
            }
            SpaceAlternatives characterAlternatives = this.dotCharacter.composeRequest(composeInfo, allocated, null);
            SpaceRequest characterRequest = characterAlternatives.getFirstBodyRequest();
            long characterIPD = characterRequest.getOptimum();
            long characterCount = sizeDesired / characterIPD;
            SpaceRequest totalWidth = new SpaceRequest();
            FLOPoint curPoint = new FLOPoint(0L, 0L);
            Extent childAllocation = new Extent(allocated);
            childAllocation.setIPD(characterIPD);
            long i = 0L;
            while (i < characterCount) {
                SpaceAlternatives characterAlternatives1 = this.dotCharacter.composeRequest(composeInfo, allocated, null);
                SpaceRequest characterRequest1 = characterAlternatives1.getFirstBodyRequest();
                GeneralArea glyphArea = this.dotCharacter.composeAreas(composeInfo, childAllocation, characterRequest1);
                glyphArea.setLocation(curPoint);
                inlineArea.addChild(glyphArea);
                inlineArea.extendContentArea(curPoint, glyphArea.getExtent());
                totalWidth.appendRequest(characterRequest1);
                curPoint.start = totalWidth.getAreaOptimum();
                ++i;
            }
            inlineArea.alignChildren();
        }
        if (larp.getLeaderPattern().equalsIgnoreCase("use-content")) {
            long repetitionCount = sizeDesired / this.getIPDForContent(composeInfo, allocated);
            SpaceRequest totalWidth = new SpaceRequest();
            FLOPoint curPoint = new FLOPoint(0L, 0L);
            Extent childAllocation = new Extent(allocated);
            long i = 0L;
            while (i < repetitionCount) {
                ChildNodeWalker walker = new ChildNodeWalker((Node)((Object)this));
                walker.getNext();
                while (walker.getCurrentNode() != null) {
                    FLO flo = (FLO)((Object)walker.getCurrentNode());
                    SpaceAlternatives characterAlternatives1 = flo.composeRequest(composeInfo, allocated, null);
                    SpaceRequest characterRequest1 = characterAlternatives1.getFirstBodyRequest();
                    GeneralArea glyphArea = flo.composeAreas(composeInfo, childAllocation, characterRequest1);
                    glyphArea.setLocation(curPoint);
                    inlineArea.addChild(glyphArea);
                    inlineArea.extendContentArea(curPoint, glyphArea.getExtent());
                    totalWidth.appendRequest(characterRequest1);
                    curPoint.start = totalWidth.getAreaOptimum();
                    walker.getNext();
                }
                ++i;
            }
            inlineArea.alignChildren();
        } else {
            GeneralArea childArea = new GeneralArea();
            childArea.setProgenitor(this);
            childArea.initializeTraits(composeInfo, this.properties);
            childArea.setContentIPD(sizeDesired);
            inlineArea.addChild(childArea);
            inlineArea.extendContentArea(childArea.getLocation(), childArea.getExtent());
        }
        this.addProgeny(inlineArea);
        return inlineArea;
    }

    protected int generateRequest(SpaceRequest request, ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        long max;
        LeaderAndRuleProperty larp = this.properties.getLeaderAndRuleProperty();
        long[] units = composeInfo.getUnitsForProperties(this.properties);
        long min = larp.getLeaderLengthMinimum().getNormalizedLength(units);
        long opt = larp.getLeaderLengthOptimum().getNormalizedLength(units);
        if (opt > (max = larp.getLeaderLengthMaximum().getNormalizedLength(units))) {
            opt = max;
        }
        request.setAreaMinimumOptimumMaximum(min, opt, max);
        return this.fitOrNoFit(available.ipd >= opt);
    }

    private long getIPDForContent(ComposeInfo composeInfo, Extent allocated) {
        long ipd = 0L;
        ChildNodeWalker walker = new ChildNodeWalker((Node)((Object)this));
        walker.getNext();
        while (walker.getCurrentNode() != null) {
            FLO flo = (FLO)((Object)walker.getCurrentNode());
            SpaceAlternatives childAlternatives = flo.composeRequest(composeInfo, allocated, null);
            SpaceRequest childRequest = childAlternatives.getFirstBodyRequest();
            ipd += childRequest.getOptimum();
            walker.getNext();
        }
        return ipd;
    }

    public String toString() {
        return "[fo:leader " + Integer.toHexString(this.hashCode()) + "]";
    }
}

