/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.TextFieldBehavior;
import com.ibm.xsl.composer.csstypes.CSSColor;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOFormattable;
import com.ibm.xsl.composer.flo.FLOText;
import com.ibm.xsl.composer.flo.InlineContent;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.java2d.J2DContext;
import com.ibm.xsl.composer.java2d.J2DExtendedFont;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.ColorRelatedProperty;
import com.ibm.xsl.composer.properties.FontProperty;
import com.ibm.xsl.composer.properties.PaginationAndLayoutProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.swing.JComponent;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOInput
extends FLOFormattable
implements InlineContent,
TextListener {
    public TextField tf = null;
    private long fontAscent;
    private int tfLength;
    public long unitsPerPixel;

    public FLOInput(DocumentImpl dom) {
        this(dom, "input");
    }

    public FLOInput(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
        BorderPaddingBackgroundProperty bp = this.properties.getBorderPaddingBackgroundProperty();
        bp.setDefaults();
        this.properties.getBlockAndLineRelatedProperty().setWhiteSpaceCollapse("false");
    }

    protected void addBehaviorsForArea(GeneralArea area, ComposeInfo composeInfo) {
        PaginationAndLayoutProperty pp = this.properties.getPaginationAndLayoutProperty();
        String pagePosition = pp.getPagePosition();
        ColorRelatedProperty cp = this.properties.getColorRelatedProperty();
        CSSColor color = cp.getColor();
        BorderPaddingBackgroundProperty bp = this.properties.getBorderPaddingBackgroundProperty();
        CSSColor colorb = bp.getBackgroundColor();
        FontProperty fp = this.properties.getFontProperty();
        ExtendedFont font = composeInfo.context.getExtendedFont(fp);
        this.fontAscent = font.getAscent();
        JComponent jsp = ((J2DContext)composeInfo.context).getParentView();
        ActionListener listener = ((J2DContext)composeInfo.context).getListener();
        Node nextChild = null;
        nextChild = this.getFirstChild();
        if (nextChild instanceof FLOText) {
            FLOText floText = (FLOText)((Object)nextChild);
            String textString = floText.getText();
            this.tfLength = textString.length();
            this.tf = new TextField(textString, this.tfLength);
            this.tf.setVisible(false);
            this.tf.addTextListener(this);
            J2DExtendedFont ef = (J2DExtendedFont)composeInfo.context.getExtendedFont(fp);
            this.tf.setFont(ef.getFont());
            this.tf.setForeground(new Color(color.red, color.green, color.blue));
            ((Component)this.tf).setBackground(new Color(colorb.red, colorb.green, colorb.blue));
            this.tf.setName(pagePosition.substring(1));
            if (pagePosition.substring(0, 1).equals("h")) {
                this.tf.setText("");
                this.tf.setEchoChar('*');
                this.tfLength = 0;
            }
            jsp.add(this.tf);
            ((J2DContext)composeInfo.context).textFieldVector.add(this.tf);
            if (listener != null) {
                this.tf.addActionListener(listener);
            }
            FLOPoint curPoint = new FLOPoint(0L, 0L);
            this.unitsPerPixel = composeInfo.context.getUnitsPerPixel();
            long width = font.getTextExtent(textString).getWidth();
            long height = font.getHeight();
            this.tf.setSize((int)(width / this.unitsPerPixel + 6L), (int)(height / this.unitsPerPixel + 1L));
            Extent size = new Extent(height, width);
            area.extendContentArea(curPoint, size);
            TextFieldBehavior tfb = new TextFieldBehavior(this);
            area.addBehavior(tfb);
        }
    }

    protected GeneralArea createArea(ComposeInfo composeInfo, Extent available) {
        GeneralArea area = new GeneralArea();
        return area;
    }

    protected int generateRequest(SpaceRequest request, ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        Extent graphExtent = request.getRequestorArea().getExtent();
        request.setAreaOptimum(graphExtent.ipd);
        return this.fitOrNoFit(available.doesFit(graphExtent));
    }

    public long getHeight() {
        return this.fontAscent;
    }

    public void textValueChanged(TextEvent e) {
        String newText = this.tf.getText();
        if (newText.length() > this.tfLength) {
            int cpos = this.tf.getCaretPosition();
            if (cpos == newText.length()) {
                this.tfLength = newText.length();
            } else {
                this.tf.setText(String.valueOf(newText.substring(0, cpos)) + newText.substring(cpos + 1));
            }
            this.tf.setCaretPosition(cpos);
        } else {
            this.tfLength = newText.length();
        }
    }

    public String toString() {
        return "[ibm:input]";
    }
}

