/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.areas.ReferenceBehavior;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOBlock;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.AbsolutePositionProperty;
import com.ibm.xsl.composer.properties.LayoutRelatedProperty;
import com.ibm.xsl.composer.properties.WritingModeRelatedProperty;
import org.apache.xerces.dom.DocumentImpl;

public class FLOBlockContainer
extends FLOBlock {
    private short referenceOrientation;
    private WritingMode writingMode;

    public FLOBlockContainer(DocumentImpl ownerDocument) {
        this(ownerDocument, "block-container");
    }

    public FLOBlockContainer(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
        WritingModeRelatedProperty wm = this.properties.getWritingModeRelatedProperty();
        wm.setDefaults();
        this.writingMode = wm.getWritingMode();
    }

    protected void addBehaviors(GeneralArea area) {
        super.addBehaviors(area);
        area.addBehavior(new ReferenceBehavior());
    }

    private void adjustAreaForAbsolutePosition(ComposeInfo composeInfo, Extent allocated, GeneralArea area, AbsolutePositionProperty app) {
        long before;
        long start;
        long[] units = composeInfo.getUnitsForProperties(this.properties);
        boolean heightSpecified = false;
        boolean widthSpecified = false;
        if (app.topValue == 2) {
            if (app.bottomValue == 2) {
                start = app.topLength.getNormalizedLength(units);
                heightSpecified = true;
                long height = composeInfo.getEnclosingBlockBPD() - app.bottomLength.getNormalizedLength(units) - start;
            } else {
                start = app.topLength.getNormalizedLength(units);
            }
        } else {
            start = app.bottomValue == 2 ? composeInfo.getEnclosingBlockBPD() - allocated.getBPD() - app.bottomLength.getNormalizedLength(units) : 0L;
        }
        if (app.leftValue == 2) {
            if (app.rightValue == 2) {
                before = app.leftLength.getNormalizedLength(units);
                widthSpecified = true;
                long width = composeInfo.getEnclosingBlockIPD() - app.rightLength.getNormalizedLength(units) - before;
            } else {
                before = app.leftLength.getNormalizedLength(units);
            }
        } else if (app.rightValue == 2) {
            long areaIPD = area.getExtent().getIPD();
            long enclosingIPD = composeInfo.getEnclosingBlockIPD();
            long rightLength = app.rightLength.getNormalizedLength(units);
            before = enclosingIPD - areaIPD - rightLength;
        } else {
            before = 0L;
        }
        area.setLocation(start, before);
    }

    protected void adjustAvailable(Extent available) {
        if (this.writingMode.isVertical() || this.referenceOrientation == 90 || this.referenceOrientation == 270) {
            available.invert();
        }
    }

    protected void adjustRequest(SpaceRequest request, Extent available) {
        if (this.writingMode.isVertical() || this.referenceOrientation == 90 || this.referenceOrientation == 270) {
            request.setAreaOptimum(available.ipd);
        }
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        GeneralArea areaSubtree = null;
        areaSubtree = super.composeAreas(composeInfo, allocated, chosenRequest);
        if (areaSubtree.isAbsolutePositioned) {
            ComposeInfo childComposeInfo = new ComposeInfo(composeInfo, allocated);
            AbsolutePositionProperty app = this.properties.getAbsolutePositionProperty();
            this.adjustAreaForAbsolutePosition(childComposeInfo, allocated, areaSubtree, app);
        }
        return areaSubtree;
    }

    public SpaceAlternatives composeRequest(ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        short ctxtReference = composeInfo.getReferenceOrientation();
        LayoutRelatedProperty lrp = this.properties.getLayoutRelatedProperty();
        this.referenceOrientation = lrp.getReferenceOrientation();
        if (ctxtReference != 0 && this.referenceOrientation == 0) {
            this.referenceOrientation = ctxtReference;
        }
        composeInfo.setReferenceOrientation(this.referenceOrientation);
        WritingMode ctxtWM = composeInfo.getWritingMode();
        if (ctxtWM != null && this.writingMode.getInlineProgressionDirection() == 0 && this.writingMode.getBlockProgressionDirection() == 1) {
            this.writingMode = ctxtWM;
        }
        SpaceAlternatives alternatives = null;
        alternatives = super.composeRequest(composeInfo, available, priorRequest);
        AbsolutePositionProperty app = this.properties.getAbsolutePositionProperty();
        if (app.absolutePositionValue == 2) {
            alternatives.getFirstBodyRequest().setAreaOptimum(0L);
            alternatives.getFirstBodyRequest().getRequestorArea().isAbsolutePositioned = true;
        }
        return alternatives;
    }

    public String toString() {
        return "[fo:block-container]";
    }
}

