/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.areas.BackgroundBehavior;
import com.ibm.xsl.composer.areas.BackgroundImageBehavior;
import com.ibm.xsl.composer.areas.BorderBehavior;
import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.flo.BlockContent;
import com.ibm.xsl.composer.flo.BlockStacker;
import com.ibm.xsl.composer.flo.ChildNodeWalker;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.flo.FLOFormattable;
import com.ibm.xsl.composer.flo.FLOListItemBody;
import com.ibm.xsl.composer.flo.FLOListItemLabel;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.SpaceAlternatives;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.properties.BorderPaddingBackgroundProperty;
import com.ibm.xsl.composer.properties.KeepsBreaksProperty;
import com.ibm.xsl.composer.properties.MarginProperty;
import com.ibm.xsl.composer.properties.WritingModeRelatedProperty;
import java.util.NoSuchElementException;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Node;

public class FLOBlock
extends FLOFormattable
implements BlockContent {
    public WritingMode writingMode;
    private WritingMode writingModeFromParent = new WritingMode();
    private long startIndent;
    private long endIndent;
    private BlockStacker stacker = new BlockStacker();

    public FLOBlock(DocumentImpl ownerDocument) {
        this(ownerDocument, "block");
    }

    public FLOBlock(DocumentImpl ownerDocument, String elementName) {
        super(ownerDocument, elementName);
        BorderPaddingBackgroundProperty bp = this.properties.getBorderPaddingBackgroundProperty();
        bp.setDefaults();
        WritingModeRelatedProperty wm = this.properties.getWritingModeRelatedProperty();
        wm.setDefaults();
        this.writingMode = wm.getWritingMode();
    }

    protected void addBehaviors(GeneralArea blockArea) {
        BorderPaddingBackgroundProperty bp = this.properties.getBorderPaddingBackgroundProperty();
        if (!bp.isTransparent()) {
            blockArea.addBehavior(new BackgroundBehavior());
        }
        if (bp.getBackgroundImage() != null) {
            blockArea.addBehavior(new BackgroundImageBehavior());
        }
        blockArea.addBehavior(new BorderBehavior());
    }

    protected void adjustAvailable(Extent available) {
        if (this.writingModeFromParent.isVertical()) {
            available.invert();
        }
    }

    protected void adjustRequest(SpaceRequest request, Extent available) {
    }

    public GeneralArea composeAreas(ComposeInfo composeInfo, Extent allocated, SpaceRequest chosenRequest) {
        GeneralArea areaSubtree = chosenRequest.getRequestorArea();
        Extent childAllocation = new Extent(allocated);
        areaSubtree.adjustAvailable(childAllocation);
        if (!areaSubtree.isAbsolutePositioned) {
            areaSubtree.setContentBPD(childAllocation.bpd);
            areaSubtree.setContentIPD(childAllocation.ipd);
        }
        this.adjustAvailable(childAllocation);
        ComposeInfo childComposeInfo = new ComposeInfo(composeInfo, allocated);
        try {
            this.stacker.arrangeChildren(childComposeInfo, childAllocation, chosenRequest.getFirstChildRequest(), areaSubtree);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        this.addProgeny(areaSubtree);
        return areaSubtree;
    }

    public SpaceAlternatives composeRequest(ComposeInfo composeInfo, Extent available, SpaceRequest priorRequest) {
        KeepsBreaksProperty kbp;
        MarginProperty mp;
        SpaceAlternatives blockAlternatives = new SpaceAlternatives();
        GeneralArea blockArea = new GeneralArea();
        blockArea.setProgenitor(this);
        long[] units = composeInfo.getUnitsForProperties(this.properties);
        ChildNodeWalker walker = new ChildNodeWalker((Node)((Object)this));
        if (walker.getCurrentNode() instanceof FLOListItemLabel) {
            mp = this.properties.getMarginProperty();
            this.startIndent = mp.getStartIndent().getNormalizedLength(units);
        }
        if (walker.getCurrentNode() instanceof FLOListItemBody) {
            mp = this.properties.getMarginProperty();
            this.endIndent = mp.getEndIndent().getNormalizedLength(units);
            available.ipd -= this.endIndent;
        }
        if (this.writingMode.getInlineProgressionDirection() == 0 && this.writingMode.getBlockProgressionDirection() == 1 && composeInfo.getWritingMode() != null) {
            this.writingModeFromParent = composeInfo.getWritingMode();
        }
        if ((kbp = this.properties.getKeepsBreaksProperty()).getKeepWithNextWithinPage().equals("always")) {
            System.out.println("keep with next within page = always");
        }
        if (priorRequest == null && kbp.getBreakBefore().equals("page") && composeInfo.isPageDirty) {
            SpaceRequest request = new SpaceRequest(this, blockArea);
            request.addBreakBefore(2);
            request.addBreakAfter(2);
            blockAlternatives.addSpaceRequest(request);
            blockAlternatives.setFit(0);
            return blockAlternatives;
        }
        this.addBehaviors(blockArea);
        blockArea.initializeTraits(composeInfo, this.properties);
        blockArea.adjustAvailable(available);
        this.adjustAvailable(available);
        Extent childAllocation = new Extent(available);
        SpaceRequest requestForStacker = null;
        if (priorRequest != null && priorRequest.getBreakBefore() == 0) {
            requestForStacker = priorRequest.getLastChildRequest();
        }
        ComposeInfo childComposeInfo = new ComposeInfo(composeInfo, available);
        SpaceAlternatives alternatives = this.stacker.composeRequestForArea(childComposeInfo, childAllocation, requestForStacker, blockArea);
        SpaceRequest stackerRequest = alternatives.getFirstBodyRequest();
        SpaceRequest blockRequest = new SpaceRequest(this, blockArea);
        blockRequest.incorporateRequest(stackerRequest);
        if (stackerRequest.getBreakAfter() >= 2) {
            blockRequest.addBreakAfter(stackerRequest.getBreakAfter());
        }
        if (this.writingModeFromParent.isVertical() || this.writingMode.isVertical()) {
            if (available.ipd < blockRequest.getAreaOptimum()) {
                blockAlternatives.setFit(1);
            } else {
                blockAlternatives.setFit(alternatives.getFit());
            }
        } else {
            blockAlternatives.setFit(alternatives.getFit());
        }
        this.adjustRequest(blockRequest, available);
        blockArea.elaborateRequest(blockRequest, 1);
        blockAlternatives.addSpaceRequest(blockRequest);
        blockAlternatives.setStartIndent(this.startIndent);
        blockAlternatives.setEndIndent(this.endIndent);
        if (kbp.getBreakAfter().equals("page")) {
            blockRequest.addBreakAfter(2);
        }
        return blockAlternatives;
    }

    public void reset() {
        this.stacker.initialize((Node)((Object)this), this.properties);
        super.reset();
    }

    public String toString() {
        return "[fo:block " + Integer.toHexString(this.hashCode()) + "]";
    }
}

