/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.flo;

import com.ibm.xsl.composer.csstypes.WritingMode;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.ExtendedFont;
import com.ibm.xsl.composer.prim.ColumnSpecs;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.properties.FontProperty;
import com.ibm.xsl.composer.properties.PropertyMap;
import java.util.HashMap;
import java.util.Map;

public class ComposeInfo {
    public Context context;
    private Extent enclosingBlockExtent;
    private boolean isEnclosingBlockBPDFixed;
    public long pageNumber;
    public ColumnSpecs columns;
    public boolean isPageDirty;
    private short referenceOrientation;
    private WritingMode writingMode;
    private Map auxState;

    public ComposeInfo(ComposeInfo composeInfo) {
        this.copy(composeInfo);
    }

    public ComposeInfo(ComposeInfo composeInfo, Extent newEnclosingBlockExtent) {
        this.copy(composeInfo);
        this.setEnclosingBlockExtent(newEnclosingBlockExtent);
    }

    public ComposeInfo(Context newContext) {
        this.context = newContext;
        this.enclosingBlockExtent = new Extent(0L, 0L);
        this.pageNumber = 0L;
        this.isEnclosingBlockBPDFixed = true;
        this.columns = null;
        this.isPageDirty = false;
    }

    public ComposeInfo(Context newContext, Extent newEnclosingBlockExtent) {
        this.context = newContext;
        this.setEnclosingBlockExtent(newEnclosingBlockExtent);
        this.pageNumber = 0L;
        this.isEnclosingBlockBPDFixed = true;
        this.columns = null;
        this.isPageDirty = false;
    }

    public void copy(ComposeInfo composeInfo) {
        this.context = composeInfo.context;
        this.enclosingBlockExtent = new Extent(composeInfo.enclosingBlockExtent);
        this.pageNumber = composeInfo.pageNumber;
        this.isEnclosingBlockBPDFixed = composeInfo.isEnclosingBlockBPDFixed;
        this.columns = composeInfo.columns;
        this.isPageDirty = composeInfo.isPageDirty;
        this.referenceOrientation = composeInfo.referenceOrientation;
        this.writingMode = composeInfo.writingMode;
    }

    public Object getAuxState(Class c) {
        return this.auxState != null ? this.auxState.get(c) : null;
    }

    public long getEnclosingBlockBPD() {
        return this.enclosingBlockExtent.getBPD();
    }

    public long getEnclosingBlockIPD() {
        return this.enclosingBlockExtent.getIPD();
    }

    public short getReferenceOrientation() {
        return this.referenceOrientation;
    }

    public long[] getUnitsForProperties(PropertyMap properties) {
        FontProperty fp = properties.getFontProperty();
        ExtendedFont font = this.context.getExtendedFont(fp);
        long[] units = new long[6];
        units[1] = this.context.getUnitsPerPoint();
        units[3] = font.getCharacterHeight('x');
        units[2] = font.getCharacterWidth('m');
        units[0] = this.context.getUnitsPerPixel();
        units[4] = this.enclosingBlockExtent.getIPD();
        units[5] = font.getHeight();
        return units;
    }

    public WritingMode getWritingMode() {
        return this.writingMode;
    }

    public boolean isEnclosingBlockBPDFixed() {
        return this.isEnclosingBlockBPDFixed;
    }

    public void putAuxState(Class c, Object o) {
        if (this.auxState != null) {
            this.auxState = new HashMap();
        }
        this.auxState.put(c, o);
    }

    public void setEnclosingBlockExtent(Extent extent) {
        this.enclosingBlockExtent = new Extent(extent);
    }

    public void setIsEnclosingBlockBPDFixed(boolean value) {
        this.isEnclosingBlockBPDFixed = value;
    }

    public void setReferenceOrientation(short orientation) {
        this.referenceOrientation = orientation;
    }

    public void setWritingMode(WritingMode mode) {
        this.writingMode = mode;
    }

    public String toString() {
        return "[ComposeInfo " + Integer.toHexString(this.hashCode()) + "]";
    }
}

