/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.csstypes;

import com.ibm.xsl.composer.prim.ShortMap;

public class CSSAlign {
    public static final int START = 0;
    public static final int RELATIVE = 1;
    public static final int CENTER = 2;
    public static final int END = 3;
    public static final int JUSTIFY = 4;
    public static final int INSIDE = 5;
    public static final int OUTSIDE = 6;
    public static final int STRING = 7;
    private static final String[] alignmentNames = new String[]{"start", "left", "relative", "center", "end", "right", "inside", "outside", "justify"};
    private static final short[] alignmentTypes;
    private static final ShortMap map;
    private short alignmentType = 0;
    private String alignmentString;

    static {
        short[] sArray = new short[9];
        sArray[2] = 1;
        sArray[3] = 2;
        sArray[4] = 3;
        sArray[5] = 3;
        sArray[6] = 4;
        sArray[7] = 5;
        sArray[8] = 6;
        alignmentTypes = sArray;
        map = new ShortMap(alignmentNames, alignmentTypes);
    }

    public void copy(CSSAlign alignment) {
        this.alignmentType = alignment.alignmentType;
        this.alignmentString = alignment.alignmentString;
    }

    public boolean equals(Object o) {
        boolean isEqual;
        boolean bl = isEqual = this == o;
        if (!isEqual && o instanceof CSSAlign) {
            CSSAlign align = (CSSAlign)o;
            isEqual = align.alignmentType == this.alignmentType && (this.alignmentType != 7 || align.alignmentString.equals(this.alignmentString));
        }
        return isEqual;
    }

    public short getAlignment() {
        return this.alignmentType;
    }

    public String getAlignmentString() {
        return this.alignmentString;
    }

    public String getAlignmentValue() {
        String name = this.alignmentType == 7 ? this.alignmentString : map.getName(this.alignmentType);
        return name;
    }

    public void setAlignment(String value) {
        try {
            this.alignmentType = map.decodeName(value.trim().toLowerCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.alignmentType = (short)7;
            this.alignmentString = value;
        }
    }
}

