/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaBehavior;
import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.RelativeURL;
import com.ibm.xsl.composer.prim.Extent;
import java.net.MalformedURLException;
import java.net.URL;

public class GraphBehavior
extends AreaBehavior {
    private URL theUri = null;
    private Context context;

    public GraphBehavior(Context context, String uri) {
        super("graph");
        this.context = context;
        try {
            this.theUri = RelativeURL.getAbsoluteURLForName(uri);
        }
        catch (MalformedURLException malformedURLException) {
            this.theUri = null;
            System.out.println("GraphBehavior: Bad URL");
        }
        context.notifyGraphic(this.theUri);
    }

    public String diagnostic() {
        return this.theUri.toExternalForm();
    }

    protected long doAdjustBaseline(long cur) {
        CSSExtent imageSize = this.context.getGraphicDimension(this.theUri.toExternalForm());
        return cur += imageSize.height;
    }

    protected void doPaint(Context context, CSSPoint location, CSSExtent extent) {
        context.drawGraphic(this.theUri.toExternalForm(), location, extent);
    }

    public Extent getExtent() {
        CSSExtent imageSize = this.context.getGraphicDimension(this.theUri.toExternalForm());
        return new Extent(imageSize.height, imageSize.width);
    }
}

