/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaTreeVisitor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ListIterator;

public class AreaTreeNode {
    private AreaTreeNode parent;
    private Object progenitor;
    private ArrayList children = new ArrayList();

    public AreaTreeNode() {
    }

    public AreaTreeNode(Object progenitor) {
        this();
        this.setProgenitor(progenitor);
    }

    public void addChild(AreaTreeNode child) {
        int index = this.children.indexOf(child);
        if (index < 0) {
            child.setParent(this);
            this.children.add(child);
        }
    }

    public final void clear() {
        ListIterator li = this.getChildren();
        while (li.hasNext()) {
            AreaTreeNode child = (AreaTreeNode)li.next();
            child.clear();
            child.parent = null;
        }
        this.progenitor = null;
        this.children.clear();
    }

    public final int getChildCount() {
        return this.children.size();
    }

    public final ListIterator getChildren() {
        return ((AbstractList)this.children).listIterator();
    }

    public Object getProgenitor() {
        return this.progenitor;
    }

    public void removeChild(AreaTreeNode child) {
        int index = this.children.indexOf(child);
        if (index >= 0) {
            this.children.remove(index);
            child.parent = null;
        }
    }

    private void setParent(AreaTreeNode parent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
    }

    public void setProgenitor(Object progenitor) {
        this.progenitor = progenitor;
    }

    public String toString() {
        return "<area-tree-node>" + this.children.size() + "</area-tree-node>";
    }

    public final void traverse(AreaTreeVisitor v) {
        this.visitBefore(v);
        ListIterator li = this.getChildren();
        while (li.hasNext()) {
            ((AreaTreeNode)li.next()).traverse(v);
        }
        this.visitAfter(v);
    }

    protected void visitAfter(AreaTreeVisitor v) {
        v.afterAreaTreeNode(this);
    }

    protected void visitBefore(AreaTreeVisitor v) {
        v.beforeAreaTreeNode(this);
    }
}

