/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.areas.AreaTreeNode;
import com.ibm.xsl.composer.areas.AreaTreeVisitor;
import com.ibm.xsl.composer.areas.GeneralArea;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.prim.Transform;
import java.util.ListIterator;

public class AreaTree {
    private GeneralArea root = new GeneralArea();

    public void append(AreaTreeNode fragment) {
        this.root.addChild(fragment);
    }

    public final void clear() {
        this.root.clear();
    }

    public void draw(Context context) {
        context.startDocument();
        Transform tf = new Transform();
        this.root.draw(context, tf);
        context.endDocument();
    }

    public void drawPage(Context context, int pageNumber) {
        GeneralArea page = this.findSubtreeForPage(pageNumber);
        if (page != null) {
            context.startDocument();
            page.draw(context, new Transform());
            context.endDocument();
        }
    }

    public AreaTreeNode findNodeAtLocation(Context context, CSSPoint point, int pageNumber) {
        AreaTreeNode atn = null;
        GeneralArea page = this.findSubtreeForPage(pageNumber);
        if (page != null) {
            Transform tf = new Transform();
            atn = page.findNodeAtLocation(context, tf, point);
        }
        return atn;
    }

    private GeneralArea findSubtreeForPage(int pageNumber) {
        GeneralArea page = null;
        ListIterator pages = this.root.getChildren();
        while (pageNumber > 0 && pages.hasNext()) {
            page = (GeneralArea)pages.next();
            --pageNumber;
        }
        return page;
    }

    public int getPageCount() {
        return this.root.getChildCount();
    }

    public void visit(AreaTreeVisitor v) {
        this.root.traverse(v);
    }
}

