/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xsl.composer.areas;

import com.ibm.xsl.composer.csstypes.CSSExtent;
import com.ibm.xsl.composer.csstypes.CSSPoint;
import com.ibm.xsl.composer.flo.ComposeInfo;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.prim.Extent;
import com.ibm.xsl.composer.prim.FLOPoint;
import com.ibm.xsl.composer.prim.SpaceRequest;
import com.ibm.xsl.composer.prim.Transform;
import com.ibm.xsl.composer.properties.PropertyMap;

public class AreaBehavior {
    private AreaBehavior adornment;
    private String name;

    public AreaBehavior() {
        this("area-behavior");
    }

    public AreaBehavior(String name) {
        this.name = name;
    }

    public final void addBehavior(AreaBehavior behavior) {
        if (this.adornment == null) {
            this.adornment = behavior;
        } else {
            this.adornment.addBehavior(behavior);
        }
    }

    public final void adjustAvailable(Extent extent) {
        this.doAdjustAvailable(extent);
        if (this.adornment != null) {
            this.adornment.adjustAvailable(extent);
        }
    }

    public final long adjustBaseline(long baseline) {
        long modBaseline = this.adornment != null ? this.adornment.adjustBaseline(baseline) : baseline;
        return this.doAdjustBaseline(modBaseline);
    }

    public final void adjustExtent(Extent extent) {
        if (this.adornment != null) {
            this.adornment.adjustExtent(extent);
        }
        this.doAdjustExtent(extent);
    }

    public void adjustTransform(Transform tf, Extent content, FLOPoint location) {
        if (this.adornment != null) {
            this.adornment.adjustTransform(tf, content, location);
        }
        this.doAdjustTransform(tf, content, location);
    }

    public final String describe() {
        String result = "<" + this.name + ">" + this.diagnostic();
        if (this.adornment != null) {
            result = String.valueOf(result) + this.adornment.describe();
        }
        result = String.valueOf(result) + "</" + this.name + ">";
        return result;
    }

    public String diagnostic() {
        return "";
    }

    protected void doAdjustAvailable(Extent cur) {
    }

    protected long doAdjustBaseline(long cur) {
        return cur;
    }

    protected void doAdjustExtent(Extent cur) {
    }

    protected void doAdjustTransform(Transform tf, Extent content, FLOPoint locaiton) {
    }

    protected void doElaborateRequest(SpaceRequest request, int direction) {
    }

    protected void doInitializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
    }

    protected void doPaint(Context context, CSSPoint location, CSSExtent extent) {
    }

    public final void elaborateRequest(SpaceRequest request, int direction) {
        if (this.adornment != null) {
            this.adornment.elaborateRequest(request, direction);
        }
        this.doElaborateRequest(request, direction);
    }

    public void initializeTraits(ComposeInfo composeInfo, PropertyMap properties) {
        if (this.adornment != null) {
            this.adornment.initializeTraits(composeInfo, properties);
        }
        this.doInitializeTraits(composeInfo, properties);
    }

    public void paint(Context context, CSSPoint location, CSSExtent extent) {
        this.doPaint(context, location, extent);
        if (this.adornment != null) {
            this.adornment.paint(context, location, extent);
        }
    }
}

