/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SQLResultSetMetaData
implements RowMetaData,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 6743260415904796964L;
    private transient ResultSetMetaData metadata_;
    private String[] columnLabels_;
    private boolean isCached_ = false;
    private int columnCount_ = -1;
    private int[] columnDisplaySize_;
    private String[] columnName_;
    private int[] columnType_;
    private String[] columnTypeName_;
    private int[] columnPrecision_;
    private int[] columnScale_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private String[] columnAlignment_;
    private String[] columnDirection_;

    public SQLResultSetMetaData() {
    }

    public SQLResultSetMetaData(ResultSetMetaData resultSetMetaData) throws RowDataException {
        try {
            this.setMetaData(resultSetMetaData);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public String getColumnAlignment(int n) throws RowDataException {
        this.validateColumnIndex(n);
        return this.columnAlignment_[n];
    }

    public String getColumnDirection(int n) throws RowDataException {
        this.validateColumnIndex(n);
        return this.columnDirection_[n];
    }

    public int getColumnCount() throws RowDataException {
        try {
            if (this.isCached_) {
                return this.columnCount_;
            }
            this.validateMetaData("Attempting to get the column count");
            return this.metadata_.getColumnCount();
        }
        catch (SQLException sQLException) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(sQLException);
        }
    }

    public int getColumnDisplaySize(int n) throws RowDataException {
        this.validateColumnIndex(n);
        try {
            if (this.isCached_) {
                return this.columnDisplaySize_[n];
            }
            this.validateMetaData("Attempting to get the column display size");
            return this.metadata_.getColumnDisplaySize(n + 1);
        }
        catch (SQLException sQLException) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(sQLException);
        }
    }

    public String getColumnLabel(int n) throws RowDataException {
        if (!this.isCached_) {
            this.validateMetaData("Attempting to get the column label");
        }
        this.validateColumnIndex(n);
        return this.columnLabels_[n];
    }

    public String getColumnName(int n) throws RowDataException {
        this.validateColumnIndex(n);
        try {
            if (this.isCached_) {
                return this.columnName_[n];
            }
            this.validateMetaData("Attempting to get the column name");
            return this.metadata_.getColumnName(n + 1);
        }
        catch (SQLException sQLException) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(sQLException);
        }
    }

    public int getColumnType(int n) throws RowDataException {
        this.validateColumnIndex(n);
        try {
            if (this.isCached_) {
                return this.columnType_[n];
            }
            this.validateMetaData("Attempting to get the column type");
            return this.metadata_.getColumnType(n + 1);
        }
        catch (SQLException sQLException) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(sQLException);
        }
    }

    public String getColumnTypeName(int n) throws RowDataException {
        this.validateColumnIndex(n);
        try {
            if (this.isCached_) {
                return this.columnTypeName_[n];
            }
            this.validateMetaData("Attempting to get the column type name");
            return this.metadata_.getColumnTypeName(n + 1);
        }
        catch (SQLException sQLException) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(sQLException);
        }
    }

    public ResultSetMetaData getMetaData() {
        return this.metadata_;
    }

    public int getPrecision(int n) throws RowDataException {
        this.validateColumnIndex(n);
        try {
            if (this.isCached_) {
                return this.columnPrecision_[n];
            }
            this.validateMetaData("Attempting to get the precision");
            return this.metadata_.getPrecision(n + 1);
        }
        catch (SQLException sQLException) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(sQLException);
        }
    }

    public int getScale(int n) throws RowDataException {
        this.validateColumnIndex(n);
        try {
            if (this.isCached_) {
                return this.columnScale_[n];
            }
            this.validateMetaData("Attempting to get the scale");
            return this.metadata_.getScale(n + 1);
        }
        catch (SQLException sQLException) {
            Trace.log(3, "Rethrowing SQLException.");
            throw new RowDataException(sQLException);
        }
    }

    public boolean isNumericData(int n) throws RowDataException {
        this.validateColumnIndex(n);
        switch (this.getColumnType(n)) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 1111: {
                return this.getColumnTypeName(n).equals("DECFLOAT");
            }
        }
        return false;
    }

    public boolean isTextData(int n) throws RowDataException {
        this.validateColumnIndex(n);
        switch (this.getColumnType(n)) {
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.metadata_ = null;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setMetaData(ResultSetMetaData resultSetMetaData) throws PropertyVetoException, RowDataException {
        if (resultSetMetaData == null) {
            throw new NullPointerException("metadata");
        }
        ResultSetMetaData resultSetMetaData2 = this.metadata_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("metadata", resultSetMetaData2, resultSetMetaData);
        }
        try {
            this.metadata_ = resultSetMetaData;
            int n = this.getColumnCount();
            this.columnLabels_ = new String[n];
            for (int i = 0; i < this.columnLabels_.length; ++i) {
                this.columnLabels_[i] = this.metadata_.getColumnLabel(i + 1);
            }
            this.columnAlignment_ = new String[n];
            this.columnDirection_ = new String[n];
        }
        catch (SQLException sQLException) {
            throw new RowDataException(sQLException);
        }
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("metadata", resultSetMetaData2, resultSetMetaData);
        }
        if (this.isCached_) {
            this.columnCount_ = -1;
            this.columnDisplaySize_ = null;
            this.columnName_ = null;
            this.columnType_ = null;
            this.columnTypeName_ = null;
            this.columnPrecision_ = null;
            this.columnScale_ = null;
            this.isCached_ = false;
        }
    }

    public void setColumnAlignment(int n, String string) throws RowDataException {
        this.validateColumnIndex(n);
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        if (!(string.equals("left") || string.equals("right") || string.equals("center") || string.equals("justify"))) {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
        this.columnAlignment_[n] = string;
    }

    public void setColumnDirection(int n, String string) throws RowDataException {
        this.validateColumnIndex(n);
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.columnDirection_[n] = string;
    }

    public void setColumnLabel(int n, String string) throws RowDataException {
        if (string == null) {
            throw new NullPointerException("label");
        }
        this.validateColumnIndex(n);
        this.columnLabels_[n] = string;
    }

    private void validateColumnIndex(int n) throws RowDataException {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
    }

    private void validateMetaData(String string) {
        if (this.metadata_ == null) {
            Trace.log(2, string + " before setting the metadata.");
            throw new ExtendedIllegalStateException("metadata", 4);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, RowDataException {
        if (this.metadata_ != null) {
            this.columnCount_ = this.getColumnCount();
            this.columnDisplaySize_ = new int[this.columnCount_];
            this.columnName_ = new String[this.columnCount_];
            this.columnType_ = new int[this.columnCount_];
            this.columnTypeName_ = new String[this.columnCount_];
            this.columnPrecision_ = new int[this.columnCount_];
            this.columnScale_ = new int[this.columnCount_];
            this.columnAlignment_ = new String[this.columnCount_];
            this.columnDirection_ = new String[this.columnCount_];
            for (int i = 0; i < this.columnCount_; ++i) {
                this.columnDisplaySize_[i] = this.getColumnDisplaySize(i);
                this.columnName_[i] = this.getColumnName(i);
                this.columnType_[i] = this.getColumnType(i);
                this.columnTypeName_[i] = this.getColumnTypeName(i);
                this.columnPrecision_[i] = this.getPrecision(i);
                this.columnScale_[i] = this.getScale(i);
                this.columnAlignment_[i] = this.getColumnAlignment(i);
                this.columnDirection_[i] = this.getColumnDirection(i);
            }
            this.isCached_ = true;
        }
        objectOutputStream.defaultWriteObject();
    }
}

