/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.RecordFormatMetaData;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowDataListener;
import com.ibm.as400.util.servlet.RowDataSupport;
import com.ibm.as400.util.servlet.RowMetaData;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class RecordListRowData
extends RowData
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 7785461189425222072L;
    private RecordFormat recordFormat_;
    private RecordFormatMetaData metadata_;
    private transient RowDataSupport rowdataSupport_;
    private transient Record currentRecord_;
    private transient int currentRecordIndex_ = -1;

    public RecordListRowData() {
    }

    public RecordListRowData(RecordFormat recordFormat) {
        this();
        try {
            this.setRecordFormat(recordFormat);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addRow(Record record) throws RowDataException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.addRow(record, new Vector[record.getRecordFormat().getNumberOfFields()]);
    }

    public void addRow(Record record, Vector[] vectorArray) {
        this.validateRecord(record);
        this.validateProperties(vectorArray);
        this.rows_.addElement(record);
        this.rowProperties_.addElement(vectorArray);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireAdded();
        }
    }

    public void addRow(Record record, int n) throws RowDataException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.addRow(record, n, new Vector[record.getRecordFormat().getNumberOfFields()]);
    }

    public void addRow(Record record, int n, Vector[] vectorArray) {
        this.validateRecord(record);
        this.validateRowIndex(n);
        this.validateProperties(vectorArray);
        this.rows_.insertElementAt(record, n);
        this.rowProperties_.insertElementAt(vectorArray, n);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireAdded();
        }
    }

    public void addRowDataListener(RowDataListener rowDataListener) {
        if (this.rowdataSupport_ == null) {
            this.rowdataSupport_ = new RowDataSupport(this);
        }
        this.rowdataSupport_.addRowDataListener(rowDataListener);
    }

    public RowMetaData getMetaData() {
        return this.metadata_;
    }

    public Object getObject(int n) throws RowDataException {
        String string = "Attempting to get the column object";
        this.validateRowList(string);
        if (n < 0 || n >= this.metadata_.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        this.validateListPosition(string);
        if (this.currentRecordIndex_ != this.position_) {
            this.currentRecord_ = (Record)this.rows_.elementAt(this.position_);
            this.currentRecordIndex_ = this.position_;
        }
        try {
            return this.currentRecord_.getField(n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.log(2, "Rethrowing UnsupportedEncodingException");
            throw new RowDataException(unsupportedEncodingException);
        }
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat_;
    }

    public Record getRow() {
        String string = "Attempting to get the row object";
        this.validateRowList(string);
        this.validateListPosition(string);
        return (Record)this.rows_.elementAt(this.position_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, RowDataException, PropertyVetoException {
        objectInputStream.defaultReadObject();
        this.currentRecordIndex_ = -1;
    }

    public void removeRowDataListener(RowDataListener rowDataListener) {
        if (rowDataListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.removeRowDataListener(rowDataListener);
        }
    }

    public void removeRow(int n) {
        this.validateRowList("Attempting to remove a row");
        if (n < 0 || n >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.rows_.removeElementAt(n);
        this.rowProperties_.removeElementAt(n);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireRemoved();
        }
    }

    public void setRow(Record record, int n) {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.setRow(record, n, new Vector[record.getRecordFormat().getNumberOfFields()]);
    }

    public void setRow(Record record, int n, Vector[] vectorArray) {
        this.validateRowList("Attempting to change the row");
        this.validateRecord(record);
        if (n < 0 || n >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.validateProperties(vectorArray);
        this.rows_.setElementAt(record, n);
        this.rowProperties_.setElementAt(vectorArray, n);
        if (this.rowdataSupport_ != null) {
            this.rowdataSupport_.fireChanged();
        }
    }

    public void setRecordFormat(RecordFormat recordFormat) throws PropertyVetoException {
        if (recordFormat == null) {
            throw new NullPointerException("recordFormat");
        }
        RecordFormat recordFormat2 = this.recordFormat_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("recordFormat", recordFormat2, recordFormat);
        }
        this.recordFormat_ = recordFormat;
        if (!this.rows_.isEmpty()) {
            this.rows_ = new Vector();
            this.rowProperties_ = new Vector();
        }
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("recordFormat", recordFormat2, recordFormat);
        }
        if (this.metadata_ == null) {
            this.metadata_ = new RecordFormatMetaData(this.recordFormat_);
        } else {
            this.metadata_.setRecordFormat(this.recordFormat_);
        }
    }

    private void validateProperties(Vector[] vectorArray) {
        if (vectorArray == null) {
            throw new NullPointerException("properties");
        }
        if (vectorArray.length != this.metadata_.getColumnCount()) {
            throw new ExtendedIllegalArgumentException("properties", 1);
        }
    }

    private void validateRecord(Record record) {
        if (record == null) {
            throw new NullPointerException("record");
        }
        try {
            if (this.recordFormat_ == null) {
                this.setRecordFormat(record.getRecordFormat());
            } else if (record.getRecordFormat() != this.recordFormat_) {
                Trace.log(2, "Parameter 'record' does not contain the correct record format.");
                throw new ExtendedIllegalArgumentException("record", 2);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void validateRowIndex(int n) {
        if (n < 0 || n > this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
    }
}

