/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPool;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.servlet.AuthenticationServlet;
import com.ibm.as400.util.servlet.ResourceBundleLoader_s;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Properties;

public abstract class AS400Servlet
extends AuthenticationServlet {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 8682226107563431693L;
    private String head_ = "<html>\n<body>\n";
    private String end_ = "</body>\n</html>\n";
    private boolean useConnectionPool_ = false;
    private static ResourceBundleLoader_s loader_;
    private static AS400ConnectionPool connectionPool_;

    public void destroy() {
        this.log(ResourceBundleLoader_s.getText("PROP_DESC_SHUTDOWN"));
        if (this.useConnectionPool_) {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_CLEANUP"));
            connectionPool_.close();
        }
        this.log(ResourceBundleLoader_s.getText("PROP_DESC_SHUTDOWNCOMP"));
    }

    public AS400Servlet() {
    }

    public AS400Servlet(boolean bl) {
        this.setUseConnectionPool(bl);
    }

    public AS400ConnectionPool getConnectionPool() {
        return connectionPool_;
    }

    public String getDocumentEnd() {
        return this.end_;
    }

    public String getDocumentHead() {
        return this.head_;
    }

    public AS400 getSystem() throws ConnectionPoolException {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        Properties properties = (Properties)this.getSessionData().get(string);
        String string2 = properties.getProperty("realm");
        String string3 = properties.getProperty("uid");
        String string4 = properties.getProperty("pwd");
        AS400 aS400 = connectionPool_ != null ? connectionPool_.getConnection(string2, string3, string4) : new AS400(string2, string3, string4);
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return aS400;
    }

    public AS400 getSystem(String string) throws ConnectionPoolException {
        Thread thread = Thread.currentThread();
        String string2 = thread.getName();
        Properties properties = (Properties)this.getSessionData().get(string2);
        String string3 = properties.getProperty("uid");
        String string4 = properties.getProperty("pwd");
        AS400 aS400 = connectionPool_ != null ? connectionPool_.getConnection(string, string3, string4) : new AS400(string, string3, string4);
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return aS400;
    }

    public AS400 getSystem(int n) throws AS400SecurityException, IOException, ConnectionPoolException {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        Properties properties = (Properties)this.getSessionData().get(string);
        String string2 = properties.getProperty("realm");
        String string3 = properties.getProperty("uid");
        String string4 = properties.getProperty("pwd");
        AS400 aS400 = null;
        try {
            if (connectionPool_ != null) {
                aS400 = connectionPool_.getConnection(string2, string3, string4, n);
                aS400.setGuiAvailable(false);
            } else {
                aS400 = new AS400(string2, string3, string4);
                aS400.setGuiAvailable(false);
                aS400.connectService(n);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return aS400;
    }

    public AS400 getSystem(String string, int n) throws AS400SecurityException, IOException, ConnectionPoolException {
        Thread thread = Thread.currentThread();
        String string2 = thread.getName();
        Properties properties = (Properties)this.getSessionData().get(string2);
        String string3 = properties.getProperty("uid");
        String string4 = properties.getProperty("pwd");
        AS400 aS400 = null;
        try {
            if (connectionPool_ != null) {
                aS400 = connectionPool_.getConnection(string, string3, string4, n);
                aS400.setGuiAvailable(false);
            } else {
                aS400 = new AS400(string, string3, string4);
                aS400.setGuiAvailable(false);
                aS400.connectService(n);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return aS400;
    }

    public AS400 getSystem(String string, String string2, String string3) throws ConnectionPoolException {
        AS400 aS400 = null;
        aS400 = connectionPool_ != null ? connectionPool_.getConnection(string, string2, string3) : new AS400(string, string2, string3);
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return aS400;
    }

    public AS400 getSystem(String string, String string2, String string3, int n) throws AS400SecurityException, IOException, ConnectionPoolException {
        AS400 aS400 = null;
        try {
            if (connectionPool_ != null) {
                this.log(ResourceBundleLoader_s.getText("PROP_DESC_USEPOOL"));
                aS400 = connectionPool_.getConnection(string, string2, string3, n);
                aS400.setGuiAvailable(false);
            } else {
                aS400 = new AS400(string, string2, string3);
                aS400.setGuiAvailable(false);
                aS400.connectService(n);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return aS400;
    }

    public boolean isUseConnectionPool() {
        return this.useConnectionPool_;
    }

    public void setDocumentEnd(String string) {
        if (string == null) {
            throw new NullPointerException("end");
        }
        this.end_ = string;
    }

    public void setDocumentHead(String string) {
        if (string == null) {
            throw new NullPointerException("head");
        }
        this.head_ = string;
    }

    public void setUseConnectionPool(boolean bl) {
        this.useConnectionPool_ = bl;
        if (this.useConnectionPool_) {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_USEPOOL"));
            if (connectionPool_ == null) {
                this.log(ResourceBundleLoader_s.getText("PROP_DESC_CREATEPOOL"));
                connectionPool_ = new AS400ConnectionPool();
            }
            connectionPool_.setLog(this.getLog());
        } else {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_NOTUSEPOOL"));
            if (connectionPool_ != null) {
                this.log(ResourceBundleLoader_s.getText("PROP_DESC_CLEANUPEXT"));
                connectionPool_.close();
                connectionPool_ = null;
            }
        }
    }

    public void returnSystem(AS400 aS400) {
        if (connectionPool_ == null) {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_NOTUSEPOOL"));
        } else {
            connectionPool_.returnConnectionToPool(aS400);
        }
    }

    public final boolean validateAuthority(String string, String string2, String string3) throws SecurityException, IOException {
        try {
            this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_AUTHENTICATE"), new String[]{string2, string}));
            string2 = string2.toUpperCase();
            string = string.toUpperCase();
            AS400 aS400 = new AS400(string, string2, string3);
            aS400.validateSignon();
            return true;
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_AUTHFAILED"));
            if (Trace.isTraceOn()) {
                Trace.log(2, extendedIllegalArgumentException);
            }
            throw new SecurityException(extendedIllegalArgumentException.getMessage());
        }
        catch (AS400SecurityException aS400SecurityException) {
            int n;
            this.log(ResourceBundleLoader_s.getText("PROP_DESC_AUTHFAILED"));
            if (Trace.isTraceOn()) {
                Trace.log(2, aS400SecurityException);
            }
            if (connectionPool_ != null && ((n = aS400SecurityException.getReturnCode()) == 32 || n == 8 || n == 31)) {
                connectionPool_.removeFromPool(string, string2);
            }
            throw new SecurityException(aS400SecurityException.getMessage());
        }
    }

    static {
        connectionPool_ = null;
    }
}

