/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.FileTreeElement;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLTreeElement;
import com.ibm.as400.util.html.HTMLVector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Collator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class HTMLTree
implements HTMLTagElement,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4170861562301214202L;
    private HTMLVector branches_;
    private HttpServletRequest request_;
    private boolean sort_ = true;
    private transient Collator collator_;
    private transient PropertyChangeSupport changes_;
    private transient Vector elementListeners_;

    public HTMLTree() {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception exception) {
            this.collator_ = null;
        }
        this.branches_ = new HTMLVector();
    }

    public HTMLTree(HttpServletRequest httpServletRequest) {
        this();
        this.setHttpServletRequest(httpServletRequest);
    }

    public void addElement(HTMLTreeElement hTMLTreeElement) {
        if (hTMLTreeElement == null) {
            throw new NullPointerException("element");
        }
        this.branches_.addElement(hTMLTreeElement);
        if (this.elementListeners_ != null) {
            this.fireElementEvent(0);
        }
    }

    public void addElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ == null) {
            this.elementListeners_ = new Vector();
        }
        this.elementListeners_.addElement(elementListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.collator_ = Collator.getInstance();
            this.collator_.setStrength(0);
        }
        catch (Exception exception) {
            this.collator_ = null;
        }
        objectInputStream.defaultReadObject();
    }

    public void removeElement(HTMLTreeElement hTMLTreeElement) {
        if (hTMLTreeElement == null) {
            throw new NullPointerException("element");
        }
        if (this.branches_.removeElement(hTMLTreeElement) && this.elementListeners_ != null) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners_ != null) {
            this.elementListeners_.removeElement(elementListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void fireElementEvent(int n) {
        Vector vector = (Vector)this.elementListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request_;
    }

    public Collator getCollator() {
        return this.collator_;
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLTree was here -->";
    }

    public String getTag() {
        if (this.request_ == null) {
            throw new ExtendedIllegalStateException("request", 4);
        }
        String string = this.request_.getParameter("hashcode");
        StringBuffer stringBuffer = new StringBuffer("<table cellpadding=\"0\" cellspacing=\"3\">\n");
        if (this.sort_) {
            HTMLTree.sort(this.collator_, this.branches_);
        }
        int n = this.branches_.getCount();
        Object[] objectArray = this.branches_.getData();
        for (int i = 0; i < n; ++i) {
            HTMLTreeElement hTMLTreeElement = (HTMLTreeElement)objectArray[i];
            if (string != null) {
                int n2 = Integer.parseInt(string);
                hTMLTreeElement.selected(n2);
            }
            stringBuffer.append(hTMLTreeElement.getTag());
        }
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }

    public void setCollator(Collator collator) {
        if (collator == null) {
            throw new NullPointerException("collator");
        }
        Collator collator2 = this.collator_;
        this.collator_ = collator;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("collator", collator2, this.collator_);
        }
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            throw new NullPointerException("request");
        }
        HttpServletRequest httpServletRequest2 = this.request_;
        this.request_ = httpServletRequest;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("request", httpServletRequest2, this.request_);
        }
    }

    public void sort(boolean bl) {
        this.sort_ = bl;
    }

    public static Vector sort(Collator collator, Vector vector) {
        HTMLTree.heapSort(collator, vector);
        return vector;
    }

    private static void heapSort(Collator collator, Vector vector) {
        int n = vector.size();
        Object e = null;
        if (n > 0) {
            int n2;
            for (n2 = n / 2; n2 != 0; --n2) {
                HTMLTree.adjustList(collator, vector, n2, n);
            }
            for (n2 = n - 1; n2 != 0; --n2) {
                e = vector.elementAt(n2);
                vector.setElementAt(vector.elementAt(0), n2);
                vector.setElementAt(e, 0);
                HTMLTree.adjustList(collator, vector, 1, n2);
            }
        }
    }

    private static void adjustList(Collator collator, Vector vector, int n, int n2) {
        Object e = vector.elementAt(n - 1);
        int n3 = n * 2;
        Object var6_6 = null;
        Object var7_7 = null;
        boolean bl = false;
        while (n3 <= n2 && !bl) {
            var7_7 = vector.elementAt(n3 - 1);
            if (n3 < n2 && HTMLTree.sortCompare(collator, var7_7, var6_6 = vector.elementAt(n3)) < 0) {
                ++n3;
                var7_7 = var6_6;
            }
            if (HTMLTree.sortCompare(collator, e, var7_7) >= 0) {
                bl = true;
                continue;
            }
            vector.setElementAt(vector.elementAt(n3 - 1), n3 / 2 - 1);
            n3 *= 2;
        }
        vector.setElementAt(e, n3 / 2 - 1);
    }

    private static int sortCompare(Collator collator, Object object, Object object2) {
        Object object3;
        Object object4;
        if (object instanceof FileTreeElement) {
            object4 = ((FileTreeElement)object).getFile().getName();
            object3 = ((FileTreeElement)object2).getFile().getName();
        } else if (object instanceof HTMLTreeElement) {
            object4 = ((HTMLTreeElement)object).getText();
            object3 = ((HTMLTreeElement)object2).getText();
        } else {
            object4 = object.toString();
            object3 = object2.toString();
        }
        if (object4 == null) {
            object4 = "";
        }
        if (object3 == null) {
            object3 = "";
        }
        int n = 0;
        n = collator != null ? collator.compare(object4.toString(), object3.toString()) : object4.toString().compareTo(object3.toString());
        return n;
    }
}

