/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLMeta
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7017914111994779942L;
    private String content_;
    private String name_;
    private String HttpEquiv_;
    private String url_;
    private String lang_;
    private String dir_;

    public HTMLMeta() {
    }

    public HTMLMeta(String string, String string2) {
        this.setHttpEquiv(string);
        this.setContent(string2);
    }

    public HTMLMeta(String string, String string2, String string3) {
        this.setHttpEquiv(string);
        this.setContent(string2);
        this.setUrl(string3);
    }

    public String getContent() {
        return this.content_;
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getHttpEquiv() {
        return this.HttpEquiv_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public String getName() {
        return this.name_;
    }

    public String getUrl() {
        return this.url_;
    }

    public String getTag() {
        if (this.content_ == null) {
            Trace.log(2, "Attempting to get tag before setting meta content.");
            throw new ExtendedIllegalStateException("content", 4);
        }
        if (this.name_ == null && this.HttpEquiv_ == null) {
            Trace.log(2, "Attempting to get tag before setting name or http-equiv attributes.");
            throw new ExtendedIllegalStateException("name/HttpEquiv", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<meta");
        if (this.HttpEquiv_ != null) {
            stringBuffer.append(" http-equiv=\"");
            stringBuffer.append(this.HttpEquiv_);
            stringBuffer.append("\"");
        } else {
            stringBuffer.append(" name=\"");
            stringBuffer.append(this.name_);
            stringBuffer.append("\"");
        }
        if (this.url_ != null) {
            stringBuffer.append(" content=\"");
            stringBuffer.append(this.content_);
            stringBuffer.append("; URL=");
            stringBuffer.append(this.url_);
            stringBuffer.append("\"");
        } else {
            stringBuffer.append(" content=\"");
            stringBuffer.append(this.content_);
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(" />\n");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- An HTMLMeta was here -->";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setContent(String string) {
        if (string == null) {
            throw new NullPointerException("content");
        }
        String string2 = this.content_;
        this.content_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("content", string2, string);
        }
    }

    public void setDirection(String string) {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setHttpEquiv(String string) {
        if (string == null) {
            throw new NullPointerException("HttpEquiv");
        }
        String string2 = this.HttpEquiv_;
        this.HttpEquiv_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("HttpEquiv", string2, string);
        }
    }

    public void setLanguage(String string) {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.name_;
        this.name_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, string);
        }
    }

    public void setUrl(String string) {
        if (string == null) {
            throw new NullPointerException("url");
        }
        String string2 = this.url_;
        this.url_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("url", string2, string);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

