/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLHead;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLDocument
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 1662839037165473585L;
    private Vector tag_ = new Vector();
    private HTMLHead head_ = null;
    private double height_ = 11.0;
    private double width_ = 8.5;
    private double margin_top_ = 0.5;
    private double margin_bottom_ = 0.5;
    private double margin_left_ = 0.5;
    private double margin_right_ = 0.5;
    private boolean useFO_ = false;
    private transient Vector tagListeners_;

    public HTMLDocument() {
    }

    public HTMLDocument(HTMLHead hTMLHead) {
        this.setHTMLHead(hTMLHead);
    }

    public void addElement(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("tag");
        }
        this.tag_.addElement(hTMLTagElement);
        this.fireAdded();
    }

    public void setHTMLHead(HTMLHead hTMLHead) {
        if (hTMLHead == null) {
            throw new NullPointerException("head");
        }
        this.head_ = hTMLHead;
        this.fireAdded();
    }

    public HTMLHead getHTMLHead() {
        return this.head_;
    }

    public void addElement(HTMLTagElement[] hTMLTagElementArray) {
        if (hTMLTagElementArray == null) {
            throw new NullPointerException("tag");
        }
        for (int i = 0; i < hTMLTagElementArray.length; ++i) {
            this.tag_.addElement(hTMLTagElementArray[i]);
            this.fireAdded();
        }
    }

    public String getFOTag() {
        boolean bl = this.useFO_;
        this.setUseFO(true);
        StringBuffer stringBuffer = new StringBuffer(this.getStartRootTag());
        stringBuffer.append("\n");
        int n = this.tag_.size();
        for (int i = 0; i < n; ++i) {
            HTMLTagElement hTMLTagElement = (HTMLTagElement)this.tag_.elementAt(i);
            stringBuffer.append(hTMLTagElement.getFOTag());
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("</fo:flow>\n");
        if (this.head_ != null) {
            stringBuffer.append(this.getHTMLHead().getFOTag());
        }
        stringBuffer.append(this.getEndRootTag());
        this.setUseFO(bl);
        return new String(stringBuffer);
    }

    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        this.setUseFO(false);
        StringBuffer stringBuffer = new StringBuffer("<html>\n");
        if (this.head_ != null) {
            stringBuffer.append(this.getHTMLHead().getTag());
        }
        StringBuffer stringBuffer2 = new StringBuffer("<body>\n");
        int n = this.tag_.size();
        for (int i = 0; i < n; ++i) {
            HTMLTagElement hTMLTagElement = (HTMLTagElement)this.tag_.elementAt(i);
            stringBuffer2.append(hTMLTagElement.getTag().toString());
            stringBuffer2.append("\n");
        }
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        return new String(stringBuffer);
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private String getStartRootTag() {
        StringBuffer stringBuffer = new StringBuffer("<fo:root xmlns:fo = 'http://www.w3.org/1999/XSL/Format'>\n");
        stringBuffer.append("<fo:layout-master-set>\n");
        stringBuffer.append("<fo:simple-page-master master-name='body-page' writing-mode='lr-tb'");
        stringBuffer.append(" page-width='" + this.width_ + "in'");
        stringBuffer.append(" page-height='" + this.height_ + "in'");
        stringBuffer.append(" margin-top='" + this.margin_top_ + "in'");
        stringBuffer.append(" margin-bottom='" + this.margin_bottom_ + "in'");
        stringBuffer.append(" margin-left='" + this.margin_left_ + "in'");
        stringBuffer.append(" margin-right='" + this.margin_right_ + "in'>\n");
        stringBuffer.append("<fo:region-body region-name='xsl-region-body'/>\n");
        stringBuffer.append("<fo:region-before region-name='xsl-region-before' precedence='true' extent='");
        stringBuffer.append(this.margin_top_ + "in'/>\n");
        stringBuffer.append("<fo:region-after region-name='xsl-region-after' precedence='true' extent='");
        stringBuffer.append(this.margin_bottom_ + "in'/>\n");
        stringBuffer.append("<fo:region-start region-name='xsl-region-start' extent='");
        stringBuffer.append(this.margin_left_ + "in'/>\n");
        stringBuffer.append("<fo:region-end region-name='xsl-region-end' extent='");
        stringBuffer.append(this.margin_right_ + "in'/>\n");
        stringBuffer.append("</fo:simple-page-master>\n");
        stringBuffer.append("</fo:layout-master-set>\n");
        stringBuffer.append("<fo:page-sequence master-name='body-page'>\n");
        stringBuffer.append("<fo:flow flow-name='xsl-region-body'>\n");
        return stringBuffer.toString();
    }

    private String getEndRootTag() {
        StringBuffer stringBuffer = new StringBuffer("</fo:page-sequence>\n");
        stringBuffer.append("</fo:root>");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getTag();
    }

    private void fireAdded() {
        if (this.tagListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.tagListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, 0);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            elementListener.elementAdded(elementEvent);
        }
    }

    private void fireRemoved() {
        if (this.tagListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.tagListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, 2);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            elementListener.elementRemoved(elementEvent);
        }
    }

    public void removeListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.tagListeners_ != null) {
            this.tagListeners_.removeElement(elementListener);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void addListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.tagListeners_ == null) {
            this.tagListeners_ = new Vector();
        }
        this.tagListeners_.addElement(elementListener);
    }

    public void setPageHeight(double d) {
        if (d < 0.0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        double d2 = this.height_;
        this.height_ = d;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", new Double(d2), new Double(d));
        }
    }

    public void setPageWidth(double d) {
        if (d < 0.0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        double d2 = this.width_;
        this.width_ = d;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", new Double(d2), new Double(d));
        }
    }

    public void setMarginTop(double d) {
        if (d < 0.0) {
            throw new ExtendedIllegalArgumentException("top", 4);
        }
        double d2 = this.margin_top_;
        this.margin_top_ = d;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("top", new Double(d2), new Double(d));
        }
    }

    public void setMarginBottom(double d) {
        if (d < 0.0) {
            throw new ExtendedIllegalArgumentException("bottom", 4);
        }
        double d2 = this.margin_bottom_;
        this.margin_bottom_ = d;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("bottom", new Double(d2), new Double(d));
        }
    }

    public void setMarginRight(double d) {
        if (d < 0.0) {
            throw new ExtendedIllegalArgumentException("right", 4);
        }
        double d2 = this.margin_right_;
        this.margin_right_ = d;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("right", new Double(d2), new Double(d));
        }
    }

    public void setMarginLeft(double d) {
        if (d < 0.0) {
            throw new ExtendedIllegalArgumentException("left", 4);
        }
        double d2 = this.margin_left_;
        this.margin_left_ = d;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("left", new Double(d2), new Double(d));
        }
    }

    public void removeElement(HTMLTagElement hTMLTagElement) {
        if (hTMLTagElement == null) {
            throw new NullPointerException("tag");
        }
        if (this.tag_.size() == 0) {
            Trace.log(2, "Attempting to remove an element when the document is empty.");
            throw new ExtendedIllegalStateException("tag", 4);
        }
        if (this.tag_.removeElement(hTMLTagElement)) {
            this.fireRemoved();
        }
    }

    public double getPageHeight() {
        return this.height_;
    }

    public double getPageWidth() {
        return this.width_;
    }

    public double getMarginTop() {
        return this.margin_top_;
    }

    public double getMarginBottom() {
        return this.margin_bottom_;
    }

    public double getMarginLeft() {
        return this.margin_left_;
    }

    public double getMarginRight() {
        return this.margin_right_;
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }
}

