/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import com.ibm.as400.access.UserEnumeration;
import com.ibm.as400.access.UserGroup;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class UserList
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 5L;
    public static final String ALL = "*ALL";
    public static final String USER = "*USER";
    public static final String GROUP = "*GROUP";
    public static final String MEMBER = "*MEMBER";
    public static final String NONE = "*NONE";
    public static final String NOGROUP = "*NOGROUP";
    private static final ProgramParameter ERROR_CODE = new ProgramParameter(new byte[8]);
    private AS400 system_ = null;
    private String userInfo_ = "*ALL";
    private String groupInfo_ = "*NONE";
    private String userProfile_ = "*ALL";
    private int length_ = 0;
    private byte[] handle_ = null;
    private boolean closeHandle_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public UserList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserList object.");
        }
    }

    public UserList(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserList object, system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public UserList(AS400 aS400, String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserList object, system: " + aS400 + ", user info: " + string + ", group info: " + string2);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'userInfo' is null.");
            throw new NullPointerException("userInfo");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'groupInfo' is null.");
            throw new NullPointerException("groupInfo");
        }
        if (string2.length() > 10) {
            Trace.log(2, "Length of parameter 'groupInfo' is not valid: '" + string2 + "'");
            throw new ExtendedIllegalArgumentException("groupInfo (" + string2 + ")", 1);
        }
        if (!(string.equals(ALL) || string.equals(USER) || string.equals(GROUP) || string.equals(MEMBER))) {
            Trace.log(2, "Value of parameter 'userInfo' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("userInfo (" + string + ")", 2);
        }
        if (string.equals(MEMBER) && string2.equals(NONE)) {
            Trace.log(2, "Value of parameter 'groupInfo' is not valid: " + string2);
            throw new ExtendedIllegalArgumentException("groupInfo (" + string2 + ")", 2);
        }
        if (!string.equals(MEMBER) && !string2.equals(NONE)) {
            Trace.log(2, "Value of parameter 'groupInfo' is not valid: " + string2);
            throw new ExtendedIllegalArgumentException("groupInfo (" + string2 + ")", 2);
        }
        this.system_ = aS400;
        this.userInfo_ = string;
        this.groupInfo_ = string2;
    }

    public UserList(AS400 aS400, String string, String string2, String string3) {
        this(aS400, string, string2);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserList object, userProfile: " + string3);
        }
        if (string3 == null) {
            Trace.log(2, "Parameter 'userProfile' is null.");
            throw new NullPointerException("userProfile");
        }
        if (string3.length() > 10) {
            Trace.log(2, "Length of parameter 'userProfile' is not valid: '" + string3 + "'");
            throw new ExtendedIllegalArgumentException("userProfile (" + string3 + ")", 1);
        }
        this.userProfile_ = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        UserList userList = this;
        synchronized (userList) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        UserList userList = this;
        synchronized (userList) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing user list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(this.handle_), ERROR_CODE};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYCLST.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        this.handle_ = null;
        this.closeHandle_ = false;
    }

    public String getGroupInfo() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting group info: " + this.groupInfo_);
        }
        return this.groupInfo_;
    }

    public synchronized int getLength() {
        block5: {
            if (Trace.traceOn_) {
                Trace.log(1, "Getting user list length.");
            }
            try {
                if (this.handle_ == null || this.closeHandle_) {
                    this.load();
                }
            }
            catch (Exception exception) {
                Trace.log(2, "Exception caught getting length of user list:", (Throwable)exception);
                if (!(exception instanceof ExtendedIllegalStateException)) break block5;
                throw (ExtendedIllegalStateException)exception;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public String getUserInfo() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user info: " + this.userInfo_);
        }
        return this.userInfo_;
    }

    public String getUserProfile() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user profile: " + this.userProfile_);
        }
        return this.userProfile_;
    }

    public synchronized Enumeration getUsers() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, RequestNotSupportedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        return new UserEnumeration(this, this.length_);
    }

    public synchronized User[] getUsers(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user list, list offset: " + n + ", number:", n2);
        }
        if (n < -1) {
            Trace.log(2, "Value of parameter 'listOffset' is not valid:", n);
            throw new ExtendedIllegalArgumentException("listOffset (" + n + ")", 4);
        }
        if (n2 < 0 && n != -1) {
            Trace.log(2, "Value of parameter 'number' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("number (" + n2 + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (n2 == 0 && n != -1) {
            return new User[0];
        }
        if (n == -1) {
            n2 = this.length_;
            n = 0;
        } else if (n + n2 > this.length_) {
            n2 = this.length_ - n;
        }
        int n3 = n2 * 62;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n3), new ProgramParameter(BinaryConverter.intToByteArray(n3)), new ProgramParameter(this.handle_), new ProgramParameter(80), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(BinaryConverter.intToByteArray(n + 1)), ERROR_CODE};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYGTLE.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray = programParameterArray[0].getOutputData();
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        User[] userArray = new User[n2];
        int n4 = 0;
        int n5 = 0;
        while (n4 < userArray.length) {
            String string = converter.byteArrayToString(byArray, n5, 10).trim();
            boolean bl = byArray[n5 + 10] == -15;
            boolean bl2 = byArray[n5 + 11] == -15;
            String string2 = converter.byteArrayToString(byArray, n5 + 12, 50).trim();
            userArray[n4] = bl ? new UserGroup(this.system_, string, bl2, string2) : new User(this.system_, string, bl2, string2);
            ++n4;
            n5 += 62;
        }
        return userArray;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Loading user list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.closeHandle_) {
            this.close();
        }
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        converter.stringToByteArray(this.userInfo_, byArray);
        byte[] byArray2 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        converter.stringToByteArray(this.groupInfo_.toUpperCase().trim(), byArray2);
        byte[] byArray3 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        converter.stringToByteArray(this.userProfile_.toUpperCase().trim(), byArray3);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(new byte[]{-63, -28, -29, -28, -16, -15, -11, -16}), new ProgramParameter(byArray), new ProgramParameter(byArray2), ERROR_CODE, new ProgramParameter(byArray3)};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYOLAUS.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray4 = programParameterArray[2].getOutputData();
        ListUtilities.checkListStatus(byArray4[30]);
        this.handle_ = new byte[4];
        System.arraycopy(byArray4, 8, this.handle_, 0, 4);
        this.length_ = BinaryConverter.byteArrayToInt(byArray4, 0);
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded user list, length: " + this.length_ + ", handle: ", this.handle_);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupInfo(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting group info: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'groupInfo' is null.");
            throw new NullPointerException("groupInfo");
        }
        if (string.length() > 10) {
            Trace.log(2, "Length of parameter 'groupInfo' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("groupInfo (" + string + ")", 1);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            UserList userList = this;
            synchronized (userList) {
                this.groupInfo_ = string;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String string2 = this.groupInfo_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("groupInfo", string2, string3);
        }
        UserList userList = this;
        synchronized (userList) {
            this.groupInfo_ = string;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("groupInfo", string2, string3);
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS400;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserInfo(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user info: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'userInfo' is null.");
            throw new NullPointerException("userInfo");
        }
        if (!(string.equals(ALL) || string.equals(USER) || string.equals(GROUP) || string.equals(MEMBER))) {
            Trace.log(2, "Value of parameter 'userInfo' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("userInfo", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            UserList userList = this;
            synchronized (userList) {
                this.userInfo_ = string;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String string2 = this.userInfo_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("userInfo", string2, string3);
        }
        UserList userList = this;
        synchronized (userList) {
            this.userInfo_ = string;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("userInfo", string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserProfile(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user profile: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'userProfile' is null.");
            throw new NullPointerException("userProfile");
        }
        if (string.length() > 10) {
            Trace.log(2, "Length of parameter 'userProfile' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("userProfile (" + string + ")", 1);
        }
        UserList userList = this;
        synchronized (userList) {
            this.userProfile_ = string;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }
}

