/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.UnixSocketImpl;
import java.io.FileInputStream;
import java.io.IOException;

class UnixSocketInputStream
extends FileInputStream {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private boolean eof;
    private UnixSocketImpl impl;
    private byte[] temp = new byte[1];

    UnixSocketInputStream(UnixSocketImpl unixSocketImpl) throws IOException {
        super(unixSocketImpl.getFileDescriptor());
        this.impl = unixSocketImpl;
    }

    private native int socketRead(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof) {
            return -1;
        }
        int n3 = this.socketRead(byArray, n, n2);
        if (n3 <= 0) {
            this.eof = true;
            return -1;
        }
        return n3;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        int n = this.read(this.temp, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    public long skip(long l) throws IOException {
        int n;
        long l2;
        if (l <= 0L) {
            return 0L;
        }
        int n2 = (int)Math.min(1024L, l2);
        byte[] byArray = new byte[n2];
        for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min((long)n2, l2))) >= 0; l2 -= (long)n) {
        }
        return l - l2;
    }

    public int available() throws IOException {
        return this.impl.available();
    }

    public void close() throws IOException {
        this.impl.close();
    }

    protected void finalize() {
    }
}

