/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ObjectList;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Subsystem {
    static final long serialVersionUID = 4L;
    private static final boolean DEBUG = false;
    public static final int NO_MAX = -1;
    public static final int NO_TIME_LIMIT = -1;
    private AS400 system_;
    private String path_;
    private String name_;
    private String library_;
    private String extendedStatus_;
    private int maxActiveJobs_;
    private int currentActiveJobs_;
    private String monitorJobName_;
    private String monitorJobUser_;
    private String monitorJobNumber_;
    private String descriptionText_;
    private String dspFileName_;
    private String dspFileLibrary_;
    private String langLibrary_;
    private SystemPool[] pools_;
    private transient ObjectDescription objectDescription_;
    private transient boolean refreshed_;

    public Subsystem(AS400 aS400, String string, String string2) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        this.system_ = aS400;
        this.path_ = QSYSObjectPathName.toPath(string, string2, "SBSD");
        this.library_ = string;
        this.name_ = string2;
    }

    public Subsystem(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        if (!qSYSObjectPathName.getObjectType().equalsIgnoreCase("SBSD")) {
            throw new ExtendedIllegalArgumentException("path", 2);
        }
        this.system_ = aS400;
        this.path_ = string;
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.name_ = qSYSObjectPathName.getObjectName();
    }

    public void assignPool(int n, String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("poolName");
        }
        if (n < 1 || n > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber", 4);
        }
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") POOLS((" + n + " " + string + "))");
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                throw new AS400Exception(aS400MessageArray);
            }
            throw new InternalErrorException("No messages returned from failed command.", 6);
        }
    }

    public void assignPool(int n, int n2, int n3) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (n < 1 || n > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber", 4);
        }
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") POOLS((" + n + " " + n2 + " " + n3 + "))");
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                throw new AS400Exception(aS400MessageArray);
            }
            throw new InternalErrorException("No messages returned from failed command.", 6);
        }
    }

    public void changeDescriptionText(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall commandCall;
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (string.length() == 0) {
            string = "*BLANK";
        }
        if (!(commandCall = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") TEXT('" + string + "')")).run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                throw new AS400Exception(aS400MessageArray);
            }
            throw new InternalErrorException("No messages returned from failed command.", 6);
        }
    }

    public void changeDisplayFilePath(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") SGNDSPF(" + qSYSObjectPathName.getLibraryName() + "/" + qSYSObjectPathName.getObjectName() + ")");
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                throw new AS400Exception(aS400MessageArray);
            }
            throw new InternalErrorException("No messages returned from failed command.", 6);
        }
    }

    public void changeLanguageLibrary(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall commandCall;
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (string.trim().length() == 0) {
            string = "*NONE";
        }
        if (!(commandCall = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") SYSLIBLE(" + string + ")")).run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                throw new AS400Exception(aS400MessageArray);
            }
            throw new InternalErrorException("No messages returned from failed command.", 6);
        }
    }

    public void changeMaximumActiveJobs(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = n == -1 ? "*NOMAX" : Integer.toString(n);
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") MAXJOBS(" + string + ")");
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                throw new AS400Exception(aS400MessageArray);
            }
            throw new InternalErrorException("No messages returned from failed command.", 6);
        }
    }

    public void create() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        this.create("*LIBCRTAUT");
    }

    public void create(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        if (string == null) {
            throw new NullPointerException("authority");
        }
        if (this.exists()) {
            throw new ObjectAlreadyExistsException(this.path_, 1);
        }
        String string2 = "QSYS/CRTSBSD SBSD(" + this.library_ + "/" + this.name_ + ") AUT(" + string + ") POOLS((1 *BASE))";
        CommandCall commandCall = new CommandCall(this.system_, string2);
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
    }

    public void delete() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/DLTSBSD SBSD(" + this.library_ + "/" + this.name_ + ")");
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                if (aS400MessageArray[0].getID() != null && !aS400MessageArray[0].getID().equals("CPF2105") && !aS400MessageArray[0].getID().equals("CPF2110")) {
                    throw new AS400Exception(aS400MessageArray);
                }
            } else {
                throw new InternalErrorException("No messages returned from failed command.", 6);
            }
        }
    }

    public void end(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Subsystem.end(this.system_, this.name_, false, n);
    }

    public static void endAllSubsystems(AS400 aS400, int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        Subsystem.end(aS400, "*ALL", false, n);
    }

    public static void endAllSubsystemsImmediately(AS400 aS400) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        Subsystem.end(aS400, "*ALL", true, -1);
    }

    public void endImmediately() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Subsystem.end(this.system_, this.name_, true, -1);
    }

    public boolean equals(Object object) {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        try {
            Subsystem subsystem = (Subsystem)object;
            if (!this.system_.equals(subsystem.getSystem())) {
                return false;
            }
            if (!this.library_.equals(subsystem.getLibrary())) {
                return false;
            }
            return this.name_.equals(subsystem.getName());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_.exists();
    }

    public int getCurrentActiveJobs() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        return this.currentActiveJobs_;
    }

    public String getDescriptionText() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        return this.descriptionText_;
    }

    public String getDisplayFilePath() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        if (this.dspFileLibrary_ == null) {
            return null;
        }
        return QSYSObjectPathName.toPath(this.dspFileLibrary_, this.dspFileName_, "FILE");
    }

    public String getLanguageLibrary() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        return this.langLibrary_;
    }

    public String getLibrary() {
        return this.library_;
    }

    public int getMaximumActiveJobs() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        return this.maxActiveJobs_;
    }

    public Job getMonitorJob() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        if (this.monitorJobName_ == null || this.monitorJobUser_ == null || this.monitorJobNumber_ == null || this.monitorJobName_.length() == 0) {
            return null;
        }
        return new Job(this.system_, this.monitorJobName_, this.monitorJobUser_, this.monitorJobNumber_);
    }

    public String getName() {
        return this.name_;
    }

    public ObjectDescription getObjectDescription() {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_;
    }

    public String getPath() {
        return this.path_;
    }

    public SystemPool getPool(int n) {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        if (n < 1 || n > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber", 4);
        }
        return this.pools_[n - 1];
    }

    public SystemPool[] getPools() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        return this.pools_;
    }

    public String getStatus() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, "The refresh() method has not yet been called.");
        }
        return this.extendedStatus_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public static Subsystem[] listAllSubsystems(AS400 aS400) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, RequestNotSupportedException {
        Subsystem[] subsystemArray;
        Vector<Subsystem> vector = new Vector<Subsystem>(20);
        ObjectList objectList = new ObjectList(aS400, "*ALL", "*ALL", "*SBSD");
        Enumeration enumeration = objectList.getObjects();
        while (enumeration.hasMoreElements()) {
            subsystemArray = (Subsystem[])enumeration.nextElement();
            Subsystem subsystem = new Subsystem(aS400, subsystemArray.getPath());
            vector.addElement(subsystem);
        }
        subsystemArray = new Subsystem[vector.size()];
        vector.toArray(subsystemArray);
        return subsystemArray;
    }

    public synchronized void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        int n2 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n2, null);
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        int n3 = 200;
        programParameterArray[0] = new ProgramParameter(n3);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("SBSI0200"));
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.path_);
        AS400Text aS400Text = new AS400Text(10, n2);
        byte[] byArray = new byte[20];
        aS400Text.toBytes(qSYSObjectPathName.getObjectName(), byArray, 0);
        aS400Text.toBytes(qSYSObjectPathName.getLibraryName(), byArray, 10);
        programParameterArray[3] = new ProgramParameter(byArray);
        programParameterArray[4] = new ProgramParameter(new byte[4]);
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QWDRSBSD.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray2 = programParameterArray[0].getOutputData();
        int n4 = BinaryConverter.byteArrayToInt(byArray2, 0);
        int n5 = BinaryConverter.byteArrayToInt(byArray2, 4);
        while (n4 < n5) {
            n3 += n5 * 2;
            try {
                programParameterArray[0].setOutputDataLength(n3);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n3));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byArray2 = programParameterArray[0].getOutputData();
            n4 = BinaryConverter.byteArrayToInt(byArray2, 0);
            n5 = BinaryConverter.byteArrayToInt(byArray2, 4);
        }
        int n6 = BinaryConverter.byteArrayToInt(byArray2, 8);
        int n7 = BinaryConverter.byteArrayToInt(byArray2, 12);
        int n8 = BinaryConverter.byteArrayToInt(byArray2, 16);
        this.name_ = convTable.byteArrayToString(byArray2, n6, 10).trim();
        this.library_ = convTable.byteArrayToString(byArray2, n6 + 10, 10).trim();
        this.extendedStatus_ = convTable.byteArrayToString(byArray2, n6 + 20, 12).trim();
        this.maxActiveJobs_ = BinaryConverter.byteArrayToInt(byArray2, n6 + 32);
        this.currentActiveJobs_ = BinaryConverter.byteArrayToInt(byArray2, n6 + 36);
        this.monitorJobName_ = convTable.byteArrayToString(byArray2, n6 + 40, 10).trim();
        this.monitorJobUser_ = convTable.byteArrayToString(byArray2, n6 + 50, 10).trim();
        this.monitorJobNumber_ = convTable.byteArrayToString(byArray2, n6 + 60, 6).trim();
        this.descriptionText_ = convTable.byteArrayToString(byArray2, n6 + 66, 50).trim();
        n3 = 500;
        programParameterArray[0] = new ProgramParameter(n3);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("SBSI0100"));
        programCall = new ProgramCall(this.system_, "/QSYS.LIB/QWDRSBSD.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byArray2 = programParameterArray[0].getOutputData();
        n4 = BinaryConverter.byteArrayToInt(byArray2, 0);
        n5 = BinaryConverter.byteArrayToInt(byArray2, 4);
        while (n4 < n5) {
            n3 += n5 * 2;
            try {
                programParameterArray[0].setOutputDataLength(n3);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n3));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byArray2 = programParameterArray[0].getOutputData();
            n4 = BinaryConverter.byteArrayToInt(byArray2, 0);
            n5 = BinaryConverter.byteArrayToInt(byArray2, 4);
        }
        this.dspFileName_ = convTable.byteArrayToString(byArray2, 38, 10).trim();
        this.dspFileLibrary_ = convTable.byteArrayToString(byArray2, 48, 10).trim();
        this.langLibrary_ = convTable.byteArrayToString(byArray2, 58, 10).trim();
        int n9 = BinaryConverter.byteArrayToInt(byArray2, 76);
        this.pools_ = new SystemPool[10];
        int n10 = 0;
        for (n = 0; n < n9; ++n) {
            int n11 = 80 + 28 * n;
            n10 = BinaryConverter.byteArrayToInt(byArray2, n11);
            String string = convTable.byteArrayToString(byArray2, n11 + 4, 10).trim();
            int n12 = BinaryConverter.byteArrayToInt(byArray2, n11 + 20);
            int n13 = BinaryConverter.byteArrayToInt(byArray2, n11 + 24);
            SystemPool systemPool = null;
            systemPool = string.equals("*USERPOOL") ? new SystemPool(this, n10, n12, n13) : new SystemPool(this.system_, string);
            systemPool.setCaching(true);
            this.pools_[n10 - 1] = systemPool;
        }
        for (n = n10; n < 10; ++n) {
            this.pools_[n] = null;
        }
        this.refreshed_ = true;
    }

    public void removePool(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (n < 1 || n > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber", 4);
        }
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") POOLS((" + n + " *RMV))");
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                throw new AS400Exception(aS400MessageArray);
            }
            throw new InternalErrorException("No messages returned from failed command.", 6);
        }
    }

    public void start() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall commandCall = new CommandCall(this.system_, "QSYS/STRSBS SBSD(" + this.library_ + "/" + this.name_ + ")");
        if (!commandCall.run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                if (aS400MessageArray[0].getID() != null && !aS400MessageArray[0].getID().equals("CPF1010")) {
                    throw new AS400Exception(aS400MessageArray);
                }
            } else {
                throw new InternalErrorException("No messages returned from failed command.", 6);
            }
        }
    }

    private static void end(AS400 aS400, String string, boolean bl, int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        CommandCall commandCall;
        String string2 = bl ? "*IMMED" : "*CNTRLD";
        StringBuffer stringBuffer = new StringBuffer("QSYS/ENDSBS SBS(" + string + ") OPTION(" + string2 + ")");
        if (!bl) {
            stringBuffer.append(" DELAY(" + n + ")");
        }
        if (!(commandCall = new CommandCall(aS400, stringBuffer.toString())).run()) {
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (aS400MessageArray.length > 0) {
                if (!(aS400MessageArray[0].getID() == null || aS400MessageArray[0].getID().equals("CPF1032") || aS400MessageArray[0].getID().equals("CPF1033") || aS400MessageArray[0].getID().equals("CPF1034") || aS400MessageArray[0].getID().equals("CPF1035") || aS400MessageArray[0].getID().equals("CPF1036") || aS400MessageArray[0].getID().equals("CPF1037") || aS400MessageArray[0].getID().equals("CPF1054") || aS400MessageArray[0].getID().equals("CPF1055") || aS400MessageArray[0].getID().equals("CPF1056"))) {
                    throw new AS400Exception(aS400MessageArray);
                }
            } else {
                throw new InternalErrorException("No messages returned from failed command.", 6);
            }
        }
    }

    private ObjectDescription getObjDesc() {
        return new ObjectDescription(this.system_, this.library_, this.name_, "SBSD");
    }
}

