/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBlob
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final byte[] default_ = new byte[0];
    private int maxLength_;
    private int truncated_;
    private byte[] value_ = default_;
    private Object savedObject_;
    private int scale_ = -1;

    SQLBlob(int n, SQLConversionSettings sQLConversionSettings) {
        this.maxLength_ = n;
    }

    public Object clone() {
        return new SQLBlob(this.maxLength_, null);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.value_ = new byte[n2];
        System.arraycopy(byArray, n + 4, this.value_, 0, this.value_.length);
        this.savedObject_ = null;
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        BinaryConverter.intToByteArray(this.value_.length, byArray, n);
        System.arraycopy(this.value_, 0, byArray, n + 4, this.value_.length);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.truncated_ = byArray.length > this.maxLength_ ? byArray.length - this.maxLength_ : 0;
        } else if (object instanceof String) {
            byte[] byArray = null;
            try {
                byArray = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
            object = byArray;
            this.truncated_ = 0;
        } else if (object instanceof Reader) {
            int n2 = n;
            byte[] byArray = null;
            if (n2 >= 0) {
                try {
                    int n3;
                    int n4 = n2 < 262144 ? n2 : 262144;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    HexReaderInputStream hexReaderInputStream = new HexReaderInputStream((Reader)object);
                    byte[] byArray2 = new byte[n4];
                    int n5 = 0;
                    int n6 = hexReaderInputStream.read(byArray2, 0, n4);
                    while (n6 > -1 && n5 < n2) {
                        byteArrayOutputStream.write(byArray2, 0, n6);
                        n3 = n2 - (n5 += n6);
                        if (n3 < n4) {
                            n4 = n3;
                        }
                        n6 = hexReaderInputStream.read(byArray2, 0, n4);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    if (byArray.length < n2) {
                        JDError.throwSQLException(this, "07006");
                    }
                    n3 = byArray.length;
                    if (byArray.length > this.maxLength_) {
                        byte[] byArray3 = new byte[this.maxLength_];
                        System.arraycopy(byArray, 0, byArray3, 0, this.maxLength_);
                        byArray = byArray3;
                    }
                    object = byArray;
                    this.truncated_ = n3 - byArray.length;
                }
                catch (ExtendedIOException extendedIOException) {
                    JDError.throwSQLException((Object)this, "07006", extendedIOException);
                }
                catch (IOException iOException) {
                    JDError.throwSQLException("HY000", iOException);
                }
            } else {
                JDError.throwSQLException("07006");
            }
        } else if (JDUtilities.JDBCLevel_ >= 20 && !(object instanceof Blob) && !(object instanceof InputStream)) {
            JDError.throwSQLException(this, "07006");
        }
        this.savedObject_ = object;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        block15: {
            try {
                Object object = this.savedObject_;
                if (object instanceof byte[]) {
                    this.value_ = (byte[])object;
                    int n = this.value_.length;
                    if (this.value_.length > this.maxLength_) {
                        byte[] byArray = new byte[this.maxLength_];
                        System.arraycopy(this.value_, 0, byArray, 0, this.maxLength_);
                        this.value_ = byArray;
                    }
                    this.truncated_ = n - this.value_.length;
                    break block15;
                }
                if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Blob) {
                    int n;
                    Blob blob = (Blob)object;
                    int n2 = (int)blob.length();
                    int n3 = n = n2 < 0 ? Integer.MAX_VALUE : n2;
                    if (n > this.maxLength_) {
                        n = this.maxLength_;
                    }
                    this.value_ = blob.getBytes(1L, n);
                    this.truncated_ = n2 - n;
                    break block15;
                }
                if (object instanceof InputStream) {
                    int n = this.scale_;
                    if (n >= 0) {
                        int n4;
                        InputStream inputStream = (InputStream)object;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        int n5 = n < 262144 ? n : 262144;
                        byte[] byArray = new byte[n5];
                        try {
                            n4 = 0;
                            int n6 = inputStream.read(byArray, 0, n5);
                            while (n6 > -1 && n4 < n) {
                                byteArrayOutputStream.write(byArray, 0, n6);
                                int n7 = n - (n4 += n6);
                                if (n7 < n5) {
                                    n5 = n7;
                                }
                                n6 = inputStream.read(byArray, 0, n5);
                            }
                        }
                        catch (IOException iOException) {
                            JDError.throwSQLException("HY000", iOException);
                        }
                        this.value_ = byteArrayOutputStream.toByteArray();
                        if (this.value_.length < n) {
                            JDError.throwSQLException(this, "07006");
                        }
                        n4 = this.value_.length;
                        if (this.value_.length > this.maxLength_) {
                            byte[] byArray2 = new byte[this.maxLength_];
                            System.arraycopy(this.value_, 0, byArray2, 0, this.maxLength_);
                            this.value_ = byArray2;
                        }
                        this.truncated_ = n4 - this.value_.length;
                        break block15;
                    }
                    JDError.throwSQLException("07006");
                    break block15;
                }
                JDError.throwSQLException("07006");
            }
            finally {
                this.savedObject_ = null;
            }
        }
    }

    public int getSQLType() {
        return 3;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCBlob";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "BLOB";
    }

    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 404;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2004;
    }

    public String getTypeName() {
        return "BLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToString(this.value_)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return new ByteArrayInputStream(this.value_);
    }

    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return new AS400JDBCBlob(this.value_, this.maxLength_);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return this.value_;
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return new StringReader(BinaryConverter.bytesToString(this.value_));
    }

    public Clob getClob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        String string = BinaryConverter.bytesToString(this.value_);
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return new AS400JDBCBlob(this.value_, this.maxLength_);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        return BinaryConverter.bytesToString(this.value_);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToString(this.value_)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }
}

