/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDLobLocator {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private boolean dataCompression_;
    private int id_;
    private int handle_ = -1;
    private long length_ = -1L;
    private int maxLength_;
    private int columnIndex_ = -1;
    private boolean graphic_;

    JDLobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, boolean bl) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.maxLength_ = n2;
        this.dataCompression_ = this.connection_.getDataCompression() == 1;
        this.graphic_ = bl;
    }

    JDLobLocator(JDLobLocator jDLobLocator) {
        this.connection_ = jDLobLocator.connection_;
        this.id_ = jDLobLocator.id_;
        this.maxLength_ = jDLobLocator.maxLength_;
        this.dataCompression_ = jDLobLocator.dataCompression_;
        this.graphic_ = jDLobLocator.graphic_;
        this.handle_ = jDLobLocator.handle_;
        this.length_ = jDLobLocator.length_;
        this.columnIndex_ = jDLobLocator.columnIndex_;
    }

    int getHandle() {
        return this.handle_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long getLength() throws SQLException {
        if (this.length_ < 0L) {
            try {
                DBSQLRequestDS dBSQLRequestDS = null;
                DBReplyRequestedDS dBReplyRequestedDS = null;
                try {
                    dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6166, this.id_, -2080374784, 0);
                    dBSQLRequestDS.setLOBLocatorHandle(this.handle_);
                    dBSQLRequestDS.setRequestedSize(0);
                    dBSQLRequestDS.setStartOffset(0);
                    dBSQLRequestDS.setCompressionIndicator(this.dataCompression_ ? 241 : 240);
                    dBSQLRequestDS.setReturnCurrentLengthIndicator(241);
                    if (this.columnIndex_ != -1) {
                        dBSQLRequestDS.setColumnIndex(this.columnIndex_);
                    }
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                    int n = dBReplyRequestedDS.getErrorClass();
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    if (n != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                    }
                    this.length_ = dBReplyRequestedDS.getCurrentLOBLength();
                    Object var6_6 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                    throw throwable;
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
            }
        }
        return this.length_;
    }

    int getMaxLength() {
        return this.maxLength_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DBLobData retrieveData(long l, int n) throws SQLException {
        if (l < 0L || n < 0) {
            JDError.throwSQLException(this, "HY024");
        }
        if (l >= (long)this.getMaxLength()) {
            JDError.throwSQLException(this, "HY024");
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        DBSQLRequestDS dBSQLRequestDS = null;
        DBReplyRequestedDS dBReplyRequestedDS = null;
        try {
            DBLobData dBLobData;
            block15: {
                dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6166, this.id_, -2080374784, 0);
                dBSQLRequestDS.setLOBLocatorHandle(this.handle_);
                dBSQLRequestDS.setRequestedSize(n);
                dBSQLRequestDS.setStartOffset((int)l);
                dBSQLRequestDS.setCompressionIndicator(this.dataCompression_ ? 241 : 240);
                dBSQLRequestDS.setReturnCurrentLengthIndicator(241);
                if (this.columnIndex_ != -1) {
                    dBSQLRequestDS.setColumnIndex(this.columnIndex_);
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this.connection_, "Retrieving lob data from handle: " + this.handle_ + " bytesToRead: " + n + " startingOffset: " + l + " dataCompression: " + this.dataCompression_ + " columnIndex: " + this.columnIndex_);
                }
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                int n2 = dBReplyRequestedDS.getErrorClass();
                int n3 = dBReplyRequestedDS.getReturnCode();
                if (n2 != 0) {
                    JDError.throwSQLException(this, this.connection_, this.id_, n2, n3);
                }
                this.length_ = dBReplyRequestedDS.getCurrentLOBLength();
                DBLobData dBLobData2 = dBReplyRequestedDS.getLOBData();
                if (this.graphic_) {
                    dBLobData2.adjustForGraphic();
                }
                dBLobData = dBLobData2;
                {
                    Object var11_10 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS == null) break block15;
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            return dBLobData;
        }
        catch (Throwable throwable) {
            try {
                Object var11_11 = null;
                if (dBSQLRequestDS != null) {
                    dBSQLRequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
                return null;
            }
        }
    }

    void setColumnIndex(int n) {
        this.columnIndex_ = n;
    }

    synchronized void setHandle(int n) {
        this.handle_ = n;
        this.length_ = -1L;
    }

    int writeData(long l, byte by, boolean bl) throws SQLException {
        return this.writeData(l, new byte[]{by}, 0, 1, bl);
    }

    int writeData(long l, byte[] byArray, boolean bl) throws SQLException {
        return this.writeData(l, byArray, 0, byArray.length, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int writeData(long l, byte[] byArray, int n, int n2, boolean bl) throws SQLException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (l < 0L || n2 < 0) {
            JDError.throwSQLException(this, "HY024");
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        int n3 = this.graphic_ ? n2 / 2 : n2;
        DBSQLRequestDS dBSQLRequestDS = null;
        DBReplyRequestedDS dBReplyRequestedDS = null;
        try {
            int n4;
            block13: {
                dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6167, this.id_, -2080374784, 0);
                dBSQLRequestDS.setLobTruncation(bl);
                dBSQLRequestDS.setLOBLocatorHandle(this.handle_);
                dBSQLRequestDS.setRequestedSize(n3);
                dBSQLRequestDS.setStartOffset((int)l);
                dBSQLRequestDS.setCompressionIndicator(240);
                dBSQLRequestDS.setLOBData(byArray, n, n2);
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this.connection_, "Writing lob data to handle: " + this.handle_ + " offset: " + l + " length: " + n2);
                }
                dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                int n5 = dBReplyRequestedDS.getErrorClass();
                int n6 = dBReplyRequestedDS.getReturnCode();
                if (n5 != 0) {
                    JDError.throwSQLException(this, this.connection_, this.id_, n5, n6);
                }
                this.length_ = -1L;
                n4 = n2;
                {
                    Object var14_13 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS == null) break block13;
                    dBReplyRequestedDS.inUse_ = false;
                }
            }
            return n4;
        }
        catch (Throwable throwable) {
            try {
                Object var14_14 = null;
                if (dBSQLRequestDS != null) {
                    dBSQLRequestDS.inUse_ = false;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.inUse_ = false;
                }
                throw throwable;
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
                return -1;
            }
        }
    }

    boolean isGraphic() {
        return this.graphic_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void free() throws SQLException {
        if (this.connection_.getVRM() < JDUtilities.vrm610) {
            JDError.throwSQLException(this, "IM001");
            return;
        }
        DBSQLRequestDS dBSQLRequestDS = null;
        DBReplyRequestedDS dBReplyRequestedDS = null;
        try {
            block11: {
                try {
                    dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6169, this.id_, Integer.MIN_VALUE, 0);
                    dBSQLRequestDS.setLOBLocatorHandle(this.handle_);
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS, this.id_);
                    int n = dBReplyRequestedDS.getErrorClass();
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    if (n == 0 || n == 7 && n2 == -401) break block11;
                    JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                }
                catch (DBDataStreamException dBDataStreamException) {
                    JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
                    Object var6_7 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.inUse_ = false;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.inUse_ = false;
                    }
                }
            }
            Object var6_6 = null;
            if (dBSQLRequestDS != null) {
                dBSQLRequestDS.inUse_ = false;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.inUse_ = false;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (dBSQLRequestDS != null) {
                dBSQLRequestDS.inUse_ = false;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.inUse_ = false;
            }
            throw throwable;
        }
    }
}

