/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;

class IFSWriteReq
extends IFSDataStreamReq {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private static final int HEADER_LENGTH = 20;
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int BASE_OFFSET_OFFSET = 26;
    private static final int RELATIVE_OFFSET_OFFSET = 30;
    private static final int DATA_FLAGS_OFFSET = 34;
    private static final int CCSID_OFFSET = 36;
    private static final int LARGE_BASE_OFFSET_OFFSET = 38;
    private static final int LARGE_RELATIVE_OFFSET_OFFSET = 46;

    IFSWriteReq(int n, long l, byte[] byArray, int n2, int n3, int n4, boolean bl, int n5) {
        super(20 + IFSWriteReq.getTemplateLength(n5) + 6 + n3);
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSWriteReq.getTemplateLength(n5));
        this.setReqRepID(4);
        this.set32bit(n, 22);
        this.setOffsetFields(l, n5);
        this.set16bit(bl ? 3 : 2, 34);
        this.set16bit(n4, 36);
        this.set32bit(n3 + 6, IFSWriteReq.getFileDataLLOffset(n5));
        this.set16bit(32, IFSWriteReq.getFileDataCPOffset(n5));
        System.arraycopy(byArray, n2, this.data_, IFSWriteReq.getFileDataOffset(n5), n3);
    }

    private static final int getTemplateLength(int n) {
        return n < 16 ? 18 : 34;
    }

    private static final int getFileDataLLOffset(int n) {
        return n < 16 ? 38 : 54;
    }

    private static final int getFileDataCPOffset(int n) {
        return n < 16 ? 42 : 58;
    }

    private static final int getFileDataOffset(int n) {
        return n < 16 ? 44 : 60;
    }

    private final void setOffsetFields(long l, int n) {
        if (n < 16) {
            this.set32bit(0, 26);
            this.set32bit((int)l, 30);
        } else {
            this.set32bit(0, 26);
            this.set32bit(0, 30);
            this.set64bit(0L, 38);
            this.set64bit(l, 46);
        }
    }
}

