/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400EndJobDS;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClassDecoupler;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

final class AS400ThreadedServer
extends AS400Server
implements Runnable {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static int threadCount = 0;
    private AS400ImplRemote system_;
    private int service_;
    private String jobString_;
    private SocketContainer socket_;
    private InputStream inStream_;
    private OutputStream outStream_;
    private Hashtable replyStreams_;
    private Hashtable instanceReplyStreams_ = new Hashtable();
    private Thread readDaemon_ = null;
    private IOException readDaemonException_ = null;
    private RuntimeException unlikelyException_ = null;
    private DataStream exchangeAttrReply_ = null;
    private final ReplyList replyList_ = new ReplyList();
    private final DiscardList discardList_ = new DiscardList();
    private int lastCorrelationId_ = 0;
    private final Object correlationIdLock_ = new Object();
    private final Object receiveLock_ = new Object();

    AS400ThreadedServer(AS400ImplRemote aS400ImplRemote, int n, SocketContainer socketContainer, String string) throws IOException {
        this.system_ = aS400ImplRemote;
        this.service_ = n;
        this.jobString_ = string;
        this.socket_ = socketContainer;
        this.connectionID_ = this.socket_.hashCode();
        this.inStream_ = socketContainer.getInputStream();
        this.outStream_ = socketContainer.getOutputStream();
        this.replyStreams_ = AS400Server.replyStreamsHashTables[n];
        this.readDaemon_ = new Thread((Runnable)this, "AS400 Read Daemon-" + ++threadCount);
        this.readDaemon_.setDaemon(true);
        this.readDaemon_.start();
    }

    final void addInstanceReplyStream(DataStream dataStream) {
        this.instanceReplyStreams_.put(dataStream, dataStream);
    }

    final void clearInstanceReplyStreams() {
        this.instanceReplyStreams_.clear();
    }

    final void forceDisconnect() {
        if (this.readDaemonException_ == null) {
            this.readDaemonException_ = new ConnectionDroppedException(4);
        }
        if (this.service_ == 4 || this.service_ == 2 || this.service_ == 6) {
            AS400EndJobDS aS400EndJobDS = new AS400EndJobDS(AS400Server.getServerId(this.service_));
            if (Trace.traceOn_) {
                aS400EndJobDS.setConnectionID(this.connectionID_);
            }
            try {
                aS400EndJobDS.write(this.outStream_);
            }
            catch (IOException iOException) {
                Trace.log(2, "Send end job data stream failed:", (Throwable)iOException);
            }
        }
        this.readDaemon_.interrupt();
        try {
            this.socket_.close();
        }
        catch (IOException iOException) {
            Trace.log(2, "Socket close failed:", (Throwable)iOException);
        }
        try {
            this.readDaemon_.join();
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Thread join failed:", (Throwable)interruptedException);
        }
    }

    final DataStream getExchangeAttrReply() {
        return this.exchangeAttrReply_;
    }

    final String getJobString() {
        return this.jobString_;
    }

    final int getService() {
        return this.service_;
    }

    final boolean isConnected() {
        return this.readDaemonException_ == null && this.unlikelyException_ == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int newCorrelationId() {
        Object object = this.correlationIdLock_;
        synchronized (object) {
            if (++this.lastCorrelationId_ == 0) {
                this.lastCorrelationId_ = 1;
            }
            return this.lastCorrelationId_;
        }
    }

    final DataStream receive(int n) throws IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "AS400Server.receive");
        }
        Object object = this.receiveLock_;
        synchronized (object) {
            while (true) {
                DataStream dataStream;
                if ((dataStream = this.replyList_.remove(n)) != null) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "receive(): Valid reply found:", n);
                    }
                    return dataStream;
                }
                if (this.readDaemonException_ != null) {
                    Trace.log(2, "receive(): Read daemon exception:", (Throwable)this.readDaemonException_);
                    throw this.readDaemonException_;
                }
                if (this.unlikelyException_ != null) {
                    Trace.log(2, "receive(): Read daemon exception:", (Throwable)this.unlikelyException_);
                    throw this.unlikelyException_;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "receive(): Reply not found. Waiting...");
                }
                this.receiveLock_.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.readDaemonException_ == null && this.unlikelyException_ == null) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Waiting for reply...");
                }
                DataStream dataStream = null;
                dataStream = this.service_ != 5 ? ClientAccessDataStream.construct(this.inStream_, this.instanceReplyStreams_, this.replyStreams_, this.system_, this.connectionID_) : ClassDecoupler.constructDDMDataStream(this.inStream_, this.replyStreams_, this.system_, this.connectionID_);
                int n = dataStream.getCorrelation();
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Adding reply:", n);
                }
                this.replyList_.add(dataStream);
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Notifying threads.");
                }
                Object object = this.receiveLock_;
                synchronized (object) {
                    this.receiveLock_.notifyAll();
                }
                if (!Trace.traceOn_) continue;
                Trace.log(1, "run(): Threads notified.");
            }
            catch (IOException iOException) {
                if (Trace.traceOn_) {
                    Trace.log(2, "run(): Caught IOException:", (Throwable)iOException);
                }
                if (this.readDaemonException_ == null) {
                    this.readDaemonException_ = iOException;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Notifying threads after IOException.");
                }
                Object object = this.receiveLock_;
                synchronized (object) {
                    this.receiveLock_.notifyAll();
                }
                if (!Trace.traceOn_) continue;
                Trace.log(1, "run(): Threads notified after IOException.");
            }
            catch (RuntimeException runtimeException) {
                if (Trace.traceOn_) {
                    Trace.log(2, "run(): Caught RuntimeException:", (Throwable)runtimeException);
                }
                if (this.unlikelyException_ == null) {
                    this.unlikelyException_ = runtimeException;
                }
                if (Trace.traceOn_) {
                    Trace.log(1, "run(): Notifying threads after RuntimeException.");
                }
                Object object = this.receiveLock_;
                synchronized (object) {
                    this.receiveLock_.notifyAll();
                }
                if (!Trace.traceOn_) continue;
                Trace.log(1, "run(): Threads notified after RuntimeException.");
            }
        }
    }

    final int send(DataStream dataStream) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send(): send request...");
            dataStream.setConnectionID(this.connectionID_);
        }
        if (this.readDaemonException_ != null) {
            Trace.log(2, "Read daemon generated exception:", (Throwable)this.readDaemonException_);
            throw this.readDaemonException_;
        }
        if (this.unlikelyException_ != null) {
            Trace.log(2, "Read daemon generated exception:", (Throwable)this.unlikelyException_);
            throw this.unlikelyException_;
        }
        int n = this.newCorrelationId();
        dataStream.setCorrelation(n);
        dataStream.write(this.outStream_);
        return n;
    }

    final void send(DataStream dataStream, int n) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send(): send request...");
            dataStream.setConnectionID(this.connectionID_);
        }
        if (this.readDaemonException_ != null) {
            Trace.log(2, "Read daemon generated exception:", (Throwable)this.readDaemonException_);
            throw this.readDaemonException_;
        }
        if (this.unlikelyException_ != null) {
            Trace.log(2, "Read daemon generated exception:", (Throwable)this.unlikelyException_);
            throw this.unlikelyException_;
        }
        dataStream.setCorrelation(n);
        dataStream.write(this.outStream_);
    }

    final void sendAndDiscardReply(DataStream dataStream) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and discard(): ...");
        }
        int n = this.send(dataStream);
        this.discardList_.add(n);
    }

    final DataStream sendAndReceive(DataStream dataStream) throws IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "send and receive(): ...");
        }
        int n = this.send(dataStream);
        return this.receive(n);
    }

    final synchronized DataStream sendExchangeAttrRequest(DataStream dataStream) throws IOException, InterruptedException {
        if (this.exchangeAttrReply_ == null) {
            this.exchangeAttrReply_ = this.sendAndReceive(dataStream);
        }
        return this.exchangeAttrReply_;
    }

    private final class DiscardList {
        int[] ids_ = new int[8];

        private DiscardList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void add(int n) {
            DataStream dataStream = AS400ThreadedServer.this.replyList_.remove(n);
            if (dataStream != null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "DiscardList: Discarded datastream:", n);
                }
                ClassDecoupler.freeDBReplyStream(dataStream);
                return;
            }
            int[] nArray = this.ids_;
            synchronized (this.ids_) {
                int n2 = this.ids_.length;
                for (int i = 0; i < n2; ++i) {
                    if (this.ids_[i] != 0) continue;
                    this.ids_[i] = n;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                int[] nArray2 = new int[n2 * 2];
                System.arraycopy(this.ids_, 0, nArray2, 0, n2);
                nArray2[n2] = n;
                this.ids_ = nArray2;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        final boolean remove(int n) {
            int n2 = this.ids_.length;
            for (int i = 0; i < this.ids_.length; ++i) {
                if (this.ids_[i] != n) continue;
                this.ids_[i] = 0;
                return true;
            }
            return false;
        }
    }

    private final class ReplyList {
        final DataStreamCollection[] streams_ = new DataStreamCollection[16];

        private ReplyList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void add(DataStream dataStream) {
            int n = dataStream.getCorrelation();
            if (AS400ThreadedServer.this.discardList_.remove(n)) {
                if (Trace.traceOn_) {
                    Trace.log(1, "ReplyList: Discarded datastream:", n);
                }
                ClassDecoupler.freeDBReplyStream(dataStream);
                return;
            }
            int n2 = dataStream.getCorrelation() % 16;
            DataStreamCollection dataStreamCollection = this.streams_[n2];
            if (dataStreamCollection == null) {
                this.streams_[n2] = new DataStreamCollection(dataStream);
                return;
            }
            DataStreamCollection dataStreamCollection2 = dataStreamCollection;
            synchronized (dataStreamCollection2) {
                DataStream[] dataStreamArray = dataStreamCollection.chain_;
                int n3 = dataStreamArray.length;
                for (int i = 0; i < n3; ++i) {
                    if (dataStreamArray[i] != null) continue;
                    dataStreamArray[i] = dataStream;
                    return;
                }
                DataStream[] dataStreamArray2 = new DataStream[n3 * 2];
                System.arraycopy(dataStreamArray, 0, dataStreamArray2, 0, n3);
                dataStreamArray2[n3] = dataStream;
                dataStreamCollection.chain_ = dataStreamArray2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final DataStream remove(int n) {
            int n2 = n % 16;
            DataStreamCollection dataStreamCollection = this.streams_[n2];
            if (dataStreamCollection == null) {
                return null;
            }
            DataStreamCollection dataStreamCollection2 = dataStreamCollection;
            synchronized (dataStreamCollection2) {
                DataStream[] dataStreamArray = dataStreamCollection.chain_;
                for (int i = 0; i < dataStreamArray.length; ++i) {
                    if (dataStreamArray[i] == null || dataStreamArray[i].getCorrelation() != n) continue;
                    DataStream dataStream = dataStreamArray[i];
                    if (i + 1 < dataStreamArray.length) {
                        System.arraycopy(dataStreamArray, i + 1, dataStreamArray, i, dataStreamArray.length - i - 1);
                    }
                    dataStreamArray[dataStreamArray.length - 1] = null;
                    return dataStream;
                }
                return null;
            }
        }
    }

    private final class DataStreamCollection {
        DataStream[] chain_;

        DataStreamCollection(DataStream dataStream) {
            this.chain_ = new DataStream[]{dataStream};
        }
    }
}

