/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.processor;

import com.ibm.as400.util.reportwriter.processor.ReportProcessor;
import com.ibm.as400.util.reportwriter.processor.ResourceBundleLoader_rw;
import com.ibm.xsl.composer.areas.AreaTree;
import com.ibm.xsl.composer.flo.FLODocument;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.FLOBuildingDocHandler_Sax1;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.apache.xalan.xpath.xdom.XercesLiaison;
import org.apache.xalan.xpath.xml.XMLParserLiaison;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLReportProcessor
extends ReportProcessor
implements Serializable {
    private transient FLODocument foDocument_;
    private transient boolean newXMLSource_;
    private transient boolean newXSLFOSource_;
    private transient Document xmlSourceDoc_;
    private transient Document xslSourceDoc_;
    private transient XSLTProcessor processor;
    private transient InputStreamReader xslreader = null;

    public XSLReportProcessor() {
        this.initializeTransient();
    }

    public XSLReportProcessor(Context context) throws NullPointerException {
        this();
        try {
            this.setContext(context);
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullcontext"));
        }
    }

    private void initializeTransient() {
        this.foDocument_ = null;
        this.newXMLSource_ = false;
        this.newXSLFOSource_ = false;
        this.xmlSourceDoc_ = null;
        this.xslSourceDoc_ = null;
    }

    public void processReport() throws IOException, SAXException, NullPointerException, DOMException {
        AreaTree areaTree = null;
        XSLTInputSource xSLTInputSource = null;
        XSLTInputSource xSLTInputSource2 = null;
        XSLTResultTarget xSLTResultTarget = null;
        FLOBuildingDocHandler_Sax1 fLOBuildingDocHandler_Sax1 = null;
        if (this.context_ == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullcontext"));
        }
        if (this.newXMLSource_) {
            fLOBuildingDocHandler_Sax1 = new FLOBuildingDocHandler_Sax1();
            XercesLiaison xercesLiaison = new XercesLiaison();
            this.processor = XSLTProcessorFactory.getProcessor((XMLParserLiaison)xercesLiaison);
            if (this.xmlSourceDoc_ == null) {
                throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullxml"));
            }
            xSLTInputSource = new XSLTInputSource((Node)this.xmlSourceDoc_);
            if (this.xslSourceDoc_ == null) {
                throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullxsl"));
            }
            xSLTInputSource2 = new XSLTInputSource((Node)this.xslSourceDoc_);
            xSLTResultTarget = new XSLTResultTarget((DocumentHandler)fLOBuildingDocHandler_Sax1);
            if (this.newXMLSource_) {
                this.processor.process(xSLTInputSource, xSLTInputSource2, xSLTResultTarget);
            }
            this.foDocument_ = (FLODocument)fLOBuildingDocHandler_Sax1.getDocument();
            this.newXMLSource_ = false;
        }
        areaTree = this.foDocument_.composeDocument(this.context_);
        areaTree.draw(this.context_);
    }

    public void setXMLDataSource(Document document) throws NullPointerException {
        if (document == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullxml"));
        }
        this.xmlSourceDoc_ = document;
        this.newXMLSource_ = true;
    }

    public void setXMLDataSource(String string) throws IOException, NullPointerException, SAXException, FileNotFoundException {
        if (string == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullxml"));
        }
        try {
            this.xslreader = new InputStreamReader(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException(ResourceBundleLoader_rw.getMessage("xmlnotfound"));
        }
        InputSource inputSource = new InputSource(this.xslreader);
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(inputSource);
        this.xmlSourceDoc_ = dOMParser.getDocument();
        this.newXMLSource_ = true;
    }

    public void setXMLDataSource(Reader reader) throws IOException, NullPointerException, SAXException {
        if (reader == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullxml"));
        }
        DOMParser dOMParser = new DOMParser();
        InputSource inputSource = new InputSource(reader);
        dOMParser.parse(inputSource);
        this.xmlSourceDoc_ = dOMParser.getDocument();
        this.newXMLSource_ = true;
    }

    public void setXMLDataSource(InputStream inputStream) throws IOException, NullPointerException, SAXException {
        if (inputStream == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullxml"));
        }
        DOMParser dOMParser = new DOMParser();
        InputSource inputSource = new InputSource(inputStream);
        dOMParser.parse(inputSource);
        this.xmlSourceDoc_ = dOMParser.getDocument();
        this.newXMLSource_ = true;
    }

    public void setXSLFOSource(String string) throws IOException, NullPointerException, SAXException, FileNotFoundException {
        if (string == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullfo"));
        }
        FLOBuildingDocHandler_Sax1 fLOBuildingDocHandler_Sax1 = new FLOBuildingDocHandler_Sax1();
        try {
            this.xslreader = new InputStreamReader(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException(ResourceBundleLoader_rw.getMessage("xslfonotfound"));
        }
        InputSource inputSource = new InputSource(this.xslreader);
        SAXParser sAXParser = new SAXParser();
        sAXParser.setDocumentHandler((DocumentHandler)fLOBuildingDocHandler_Sax1);
        sAXParser.parse(inputSource);
        this.foDocument_ = (FLODocument)fLOBuildingDocHandler_Sax1.getDocument();
        this.newXSLFOSource_ = true;
    }

    public void setXSLFOSource(Reader reader) throws IOException, NullPointerException, SAXException {
        if (reader == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullfo"));
        }
        FLOBuildingDocHandler_Sax1 fLOBuildingDocHandler_Sax1 = new FLOBuildingDocHandler_Sax1();
        InputSource inputSource = new InputSource(reader);
        SAXParser sAXParser = new SAXParser();
        sAXParser.setDocumentHandler((DocumentHandler)fLOBuildingDocHandler_Sax1);
        sAXParser.parse(inputSource);
        this.foDocument_ = (FLODocument)fLOBuildingDocHandler_Sax1.getDocument();
        this.newXSLFOSource_ = true;
    }

    public void setXSLFOSource(InputStream inputStream) throws IOException, NullPointerException, SAXException {
        if (inputStream == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullfo"));
        }
        FLOBuildingDocHandler_Sax1 fLOBuildingDocHandler_Sax1 = new FLOBuildingDocHandler_Sax1();
        InputSource inputSource = new InputSource(inputStream);
        SAXParser sAXParser = new SAXParser();
        sAXParser.setDocumentHandler((DocumentHandler)fLOBuildingDocHandler_Sax1);
        sAXParser.parse(inputSource);
        this.foDocument_ = (FLODocument)fLOBuildingDocHandler_Sax1.getDocument();
        this.newXSLFOSource_ = true;
    }

    public void setTemplate(Document document) throws NullPointerException {
        if (document == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullxsl"));
        }
        this.xslSourceDoc_ = document;
        this.newXMLSource_ = true;
    }

    public void setTemplate(String string) throws SAXException, IOException, NullPointerException, FileNotFoundException {
        if (string == null) {
            String string2 = ResourceBundleLoader_rw.getMessage("nullxsl");
            throw new NullPointerException(string2);
        }
        try {
            this.xslreader = new InputStreamReader(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException(ResourceBundleLoader_rw.getMessage("xslnotfound"));
        }
        InputSource inputSource = new InputSource(this.xslreader);
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(inputSource);
        this.xslSourceDoc_ = dOMParser.getDocument();
        this.newXMLSource_ = true;
    }

    public void setTemplate(Reader reader) throws SAXException, IOException, NullPointerException {
        if (reader == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullxsl"));
        }
        InputSource inputSource = new InputSource(reader);
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(inputSource);
        this.xslSourceDoc_ = dOMParser.getDocument();
        this.newXMLSource_ = true;
    }

    public void setTemplate(InputStream inputStream) throws SAXException, IOException, NullPointerException {
        if (inputStream == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullxsl"));
        }
        InputSource inputSource = new InputSource(inputStream);
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(inputSource);
        this.xslSourceDoc_ = dOMParser.getDocument();
        this.newXMLSource_ = true;
    }
}

