/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.reportwriter.processor;

import com.ibm.as400.util.reportwriter.processor.ReportProcessor;
import com.ibm.as400.util.reportwriter.processor.ResourceBundleLoader_rw;
import com.ibm.xsl.composer.areas.AreaTree;
import com.ibm.xsl.composer.flo.FLODocument;
import com.ibm.xsl.composer.framework.Context;
import com.ibm.xsl.composer.framework.FLOBuildingDocHandler_Sax1;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.DOMException;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JSPReportProcessor
extends ReportProcessor
implements Serializable {
    private transient FLODocument foDocument_ = null;
    private transient URL jspURL_ = null;
    private transient boolean newSource_ = false;

    public JSPReportProcessor() {
        this.initializeTransient();
    }

    public JSPReportProcessor(Context context) throws NullPointerException {
        this();
        try {
            this.setContext(context);
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullcontext"));
        }
    }

    private void initializeTransient() {
        this.newSource_ = false;
        this.foDocument_ = null;
    }

    public void processReport() throws IOException, NullPointerException, SAXException, DOMException {
        InputStreamReader inputStreamReader = null;
        AreaTree areaTree = null;
        FLOBuildingDocHandler_Sax1 fLOBuildingDocHandler_Sax1 = null;
        if (this.context_ == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullcontext"));
        }
        if (this.jspURL_ == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullurl"));
        }
        if (this.newSource_) {
            try {
                inputStreamReader = new InputStreamReader(this.jspURL_.openStream());
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                System.out.println(string);
                throw new IOException(ResourceBundleLoader_rw.getMessage("jsperror"));
            }
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            fLOBuildingDocHandler_Sax1 = new FLOBuildingDocHandler_Sax1();
            InputSource inputSource = new InputSource(bufferedReader);
            SAXParser sAXParser = new SAXParser();
            sAXParser.setDocumentHandler((DocumentHandler)fLOBuildingDocHandler_Sax1);
            sAXParser.parse(inputSource);
            this.foDocument_ = (FLODocument)fLOBuildingDocHandler_Sax1.getDocument();
            this.newSource_ = true;
        }
        areaTree = this.foDocument_.composeDocument(this.context_);
        areaTree.draw(this.context_);
    }

    public void setTemplate(URL uRL) throws NullPointerException {
        if (uRL == null) {
            throw new NullPointerException(ResourceBundleLoader_rw.getMessage("nullurl"));
        }
        this.jspURL_ = uRL;
        this.newSource_ = true;
    }
}

