/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPSelection;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectListEvent;
import com.ibm.as400.access.PrintObjectListImpl;
import com.ibm.as400.access.PrintObjectListListener;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class PrintObjectList
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String SYSTEM = "system";
    private NPCPAttributeIDList attrsToRetrieve_ = null;
    private NPCPID idFilter_ = null;
    private NPCPSelection selection_ = null;
    AS400 system_ = null;
    private int typeOfObject_ = 0;
    private boolean listOutOfSync_ = false;
    private boolean objectAddedEvent_ = false;
    private transient boolean open_;
    private transient Vector printObjectListListeners_;
    private transient Vector theList_;
    transient PrintObjectListImpl impl_;
    transient PropertyChangeSupport changes;
    transient VetoableChangeSupport vetos;
    transient PrintObjectListListener dispatcher_;
    boolean useCache_ = true;

    public void setCache(boolean bl) {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.useCache_ = bl;
        this.impl_.setCache(bl);
    }

    PrintObjectList(int n, NPCPSelection nPCPSelection) {
        this.typeOfObject_ = n;
        this.selection_ = nPCPSelection;
        this.initializeTransient();
    }

    PrintObjectList(int n, NPCPSelection nPCPSelection, AS400 aS400) {
        this(n, nPCPSelection);
        if (aS400 == null) {
            Trace.log(2, "printObjectList: Parameter 'system' is null.");
            throw new NullPointerException(SYSTEM);
        }
        this.system_ = aS400;
    }

    public void addPrintObjectListListener(PrintObjectListListener printObjectListListener) {
        this.printObjectListListeners_.addElement(printObjectListListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    abstract void chooseImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PrintObjectList printObjectList = this;
        synchronized (printObjectList) {
            if (!this.open_) {
                this.theList_.removeAllElements();
                return;
            }
            this.impl_.close();
            this.open_ = false;
        }
    }

    private PrintObjectListEvent createPrintObjectListEvent(int n, PrintObject printObject, Exception exception) {
        PrintObjectListEvent printObjectListEvent = exception != null ? new PrintObjectListEvent((Object)this, exception) : (printObject != null ? new PrintObjectListEvent((Object)this, printObject) : new PrintObjectListEvent((Object)this, n));
        return printObjectListEvent;
    }

    private void firePrintObjectList(PrintObjectListEvent printObjectListEvent) {
        printObjectListEvent.setSource(this);
        if (this.printObjectListListeners_.isEmpty()) {
            return;
        }
        Vector vector = (Vector)this.printObjectListListeners_.clone();
        block7: for (int i = 0; i < vector.size(); ++i) {
            switch (printObjectListEvent.getID()) {
                case 5: {
                    PrintObject printObject = printObjectListEvent.getObject();
                    if (this.useCache_) {
                        this.theList_.addElement(printObject);
                    }
                    this.objectAddedEvent_ = true;
                    ((PrintObjectListListener)vector.elementAt(i)).listObjectAdded(printObjectListEvent);
                    continue block7;
                }
                case 1: {
                    ((PrintObjectListListener)vector.elementAt(i)).listClosed(printObjectListEvent);
                    continue block7;
                }
                case 2: {
                    ((PrintObjectListListener)vector.elementAt(i)).listCompleted(printObjectListEvent);
                    continue block7;
                }
                case 3: {
                    ((PrintObjectListListener)vector.elementAt(i)).listErrorOccurred(printObjectListEvent);
                    continue block7;
                }
                case 4: {
                    ((PrintObjectListListener)vector.elementAt(i)).listOpened(printObjectListEvent);
                }
            }
        }
    }

    private void firePrintObjectList(int n, PrintObject printObject, Exception exception) {
        this.firePrintObjectList(this.createPrintObjectListEvent(n, printObject, exception));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintObject getObject(int n) {
        if (!this.open_) {
            Trace.log(2, "getObject: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        Vector vector = this.theList_;
        synchronized (vector) {
            if (this.theList_.size() > n && (!this.listOutOfSync_ || this.listOutOfSync_ && this.objectAddedEvent_ && this.theList_.size() == this.impl_.size())) {
                this.objectAddedEvent_ = false;
                return (PrintObject)this.theList_.elementAt(n);
            }
            PrintObject printObject = null;
            if (this.listOutOfSync_) {
                this.theList_.removeAllElements();
                this.listOutOfSync_ = false;
            }
            if (this.useCache_) {
                for (int i = this.theList_.size(); i <= n; ++i) {
                    NPCPAttribute nPCPAttribute;
                    NPCPID nPCPID;
                    block10: {
                        nPCPID = this.impl_.getNPCPID(i);
                        nPCPAttribute = this.impl_.getNPCPAttribute(i);
                        try {
                            nPCPID.setConverter(new Converter((int)this.system_.getCcsid(), (AS400)this.system_).impl);
                            nPCPAttribute.setConverter(new Converter((int)this.system_.getCcsid(), (AS400)this.system_).impl);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            if (!Trace.isTraceErrorOn()) break block10;
                            Trace.log(2, "Error initializing converter for print object", (Throwable)unsupportedEncodingException);
                        }
                    }
                    printObject = this.newNPObject(nPCPID, nPCPAttribute);
                    this.theList_.addElement(printObject);
                }
                return printObject;
            }
            return null;
        }
    }

    public Enumeration getObjects() {
        if (!this.open_) {
            Trace.log(2, "getObjects: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        this.getObject(this.impl_.size() - 1);
        return this.theList_.elements();
    }

    NPCPSelection getSelectionCP() {
        return this.selection_;
    }

    public final AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.impl_ = null;
        this.printObjectListListeners_ = new Vector();
        this.changes = new PropertyChangeSupport(this);
        this.vetos = new VetoableChangeSupport(this);
        this.theList_ = new Vector();
        this.open_ = false;
        this.dispatcher_ = new PrintObjectListListener(){

            public void listClosed(PrintObjectListEvent printObjectListEvent) {
                PrintObjectList.this.firePrintObjectList(printObjectListEvent);
            }

            public void listCompleted(PrintObjectListEvent printObjectListEvent) {
                PrintObjectList.this.firePrintObjectList(printObjectListEvent);
            }

            public void listErrorOccurred(PrintObjectListEvent printObjectListEvent) {
                PrintObjectList.this.firePrintObjectList(printObjectListEvent);
            }

            public void listOpened(PrintObjectListEvent printObjectListEvent) {
                PrintObjectList.this.firePrintObjectList(printObjectListEvent);
            }

            public void listObjectAdded(PrintObjectListEvent printObjectListEvent) {
                PrintObjectList.this.firePrintObjectList(printObjectListEvent);
            }
        };
    }

    public boolean isCompleted() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (!this.open_) {
            Trace.log(2, "isCompleted: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        return this.impl_.isCompleted();
    }

    abstract PrintObject newNPObject(NPCPID var1, NPCPAttribute var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAsynchronously() {
        PrintObjectList printObjectList = this;
        synchronized (printObjectList) {
            if (this.open_) {
                Trace.log(2, "open: List is already opened.");
                throw new ExtendedIllegalStateException(2);
            }
            if (this.impl_ == null) {
                if (this.system_ == null) {
                    ExtendedIllegalStateException extendedIllegalStateException = new ExtendedIllegalStateException(SYSTEM, 4);
                    this.firePrintObjectList(3, null, extendedIllegalStateException);
                }
                this.chooseImpl();
            }
            if (!this.getSystem().isThreadUsed()) {
                Trace.log(2, "open: Threads can not be started.");
                throw new ExtendedIllegalStateException(9);
            }
            this.open_ = true;
            this.listOutOfSync_ = true;
            this.impl_.openAsynchronously();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSynchronously() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        PrintObjectList printObjectList = this;
        synchronized (printObjectList) {
            if (this.open_) {
                Trace.log(2, "open: List is already opened.");
                throw new ExtendedIllegalStateException(2);
            }
            if (this.impl_ == null) {
                if (this.system_ == null) {
                    ExtendedIllegalStateException extendedIllegalStateException = new ExtendedIllegalStateException(SYSTEM, 4);
                    this.firePrintObjectList(3, null, extendedIllegalStateException);
                }
                this.chooseImpl();
            }
            this.open_ = true;
            this.listOutOfSync_ = true;
            this.impl_.openSynchronously();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removePrintObjectListListener(PrintObjectListListener printObjectListListener) {
        this.printObjectListListeners_.removeElement(printObjectListListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void resetAttributesToRetrieve() {
        if (this.open_) {
            Trace.log(2, "resetAttributesToRetrieve: List is already opened.");
            throw new ExtendedIllegalStateException(2);
        }
        this.attrsToRetrieve_ = null;
        if (this.impl_ != null) {
            this.impl_.resetAttributesToRetrieve();
        }
    }

    public void resetFilter() {
        if (this.open_) {
            Trace.log(2, "resetFilter: List is already opened.");
            throw new ExtendedIllegalStateException(2);
        }
        this.selection_.reset();
        this.idFilter_ = null;
        if (this.impl_ != null) {
            this.impl_.resetFilter();
        }
    }

    public synchronized void setAttributesToRetrieve(int[] nArray) {
        if (nArray == null) {
            Trace.log(2, "setAttributesToRetrieve: Parameter 'attributes' is null.");
            throw new NullPointerException("attributes");
        }
        if (this.open_) {
            Trace.log(2, "setAttributesToRetrieve: List is already opened.");
            throw new ExtendedIllegalStateException(2);
        }
        if (this.attrsToRetrieve_ != null) {
            this.attrsToRetrieve_.reset();
        } else {
            this.attrsToRetrieve_ = new NPCPAttributeIDList();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.attrsToRetrieve_.addAttrID(nArray[i]);
        }
        if (this.impl_ != null) {
            this.impl_.setAttributesToRetrieve(nArray);
        }
    }

    void setIDCodePointFilter(NPCPID nPCPID) {
        this.idFilter_ = nPCPID;
        if (this.impl_ != null) {
            this.impl_.setIDCodePointFilter(nPCPID);
        }
    }

    void setImpl() {
        int n = this.printObjectListListeners_.size();
        try {
            this.system_.connectService(1);
            this.impl_.setSystem(this.system_.getImpl());
            this.impl_.addPrintObjectListListener(this.dispatcher_);
        }
        catch (Exception exception) {
            Trace.log(2, "Error occurred connecting to Print service.");
        }
        this.impl_.setPrintObjectListAttrs(this.attrsToRetrieve_, this.idFilter_, this.selection_, this.typeOfObject_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            Trace.log(2, "setSystem: Parameter 'system' is null.");
            throw new NullPointerException(SYSTEM);
        }
        AS400 aS4002 = this.getSystem();
        this.vetos.fireVetoableChange(SYSTEM, aS4002, aS400);
        PrintObjectList printObjectList = this;
        synchronized (printObjectList) {
            if (this.open_) {
                Trace.log(2, "setSystem: List is already opened.");
                throw new ExtendedIllegalStateException(2);
            }
            this.system_ = aS400;
            if (this.impl_ != null) {
                this.impl_.setSystem(aS400.getImpl());
            }
        }
        this.changes.firePropertyChange(SYSTEM, aS4002, aS400);
    }

    public synchronized int size() {
        if (!this.open_) {
            Trace.log(2, "size: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        return this.impl_.size();
    }

    public void waitForItem(int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (!this.open_) {
            Trace.log(2, "waitForItem: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        if (n < 1) {
            Trace.log(2, "waitForItem: Parameter 'itemNumber' is less than 1.");
            throw new ExtendedIllegalArgumentException("itemNumber(" + n + ")", 4);
        }
        this.impl_.waitForItem(n);
    }

    public void waitForListToComplete() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (!this.open_) {
            Trace.log(2, "waitForListToComplete: List has not been opened.");
            throw new ExtendedIllegalStateException(3);
        }
        this.impl_.waitForListToComplete();
    }
}

