/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import net.phbwt.jtans.AbstractApplication;
import net.phbwt.jtans.guicommon.Config;

public class jTansWebstart
extends AbstractApplication {
    private static final String CONFIG_NAME = "jTansConfig";
    private PersistenceService persistenceService = null;
    private BasicService basicService = null;
    private URL configURL = null;

    public static void main(String[] stringArray) {
        jTansWebstart jTansWebstart2 = new jTansWebstart();
        jTansWebstart2.start();
    }

    public Config retrieveConfig() {
        Config config;
        try {
            this.persistenceService = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
            this.basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL uRL = this.basicService.getCodeBase();
            this.configURL = new URL(uRL.toString() + CONFIG_NAME);
            FileContents fileContents = this.persistenceService.get(this.configURL);
            InputStream inputStream = fileContents.getInputStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(inputStream)));
            config = (Config)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("*INFO*:can't find/load preferences:");
            exception.printStackTrace(System.err);
            config = new Config();
        }
        return config;
    }

    public void saveConfig(Config config) {
        try {
            if (this.persistenceService == null || this.basicService == null) {
                throw new RuntimeException("Service Unavailable");
            }
            long l = 4096L;
            try {
                this.persistenceService.delete(this.configURL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.persistenceService.create(this.configURL, l) < l) {
                throw new RuntimeException("not enough space to save config");
            }
            FileContents fileContents = this.persistenceService.get(this.configURL);
            OutputStream outputStream = fileContents.getOutputStream(false);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(outputStream)));
            objectOutputStream.writeObject(this.config);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("*INFO*: Can't save config:");
            exception.printStackTrace(System.err);
        }
    }
}

