/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guimain;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class LayoutCarre
implements LayoutManager {
    private Dimension minDim = new Dimension();
    private Dimension prefDim = new Dimension();
    private double proportion;
    private boolean tailleInconnue = true;

    private void resetDim(Container container) {
        if (container.getComponentCount() > 0) {
            Component component = container.getComponent(0);
            this.proportion = 1.0;
            this.minDim = component.getMinimumSize();
            this.prefDim = component.getPreferredSize();
            this.prefDim.width = Math.max(this.prefDim.width, (int)((double)this.prefDim.height / this.proportion));
            this.prefDim.height = Math.max(this.prefDim.height, (int)((double)this.prefDim.width * this.proportion));
            this.tailleInconnue = false;
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        if (this.tailleInconnue) {
            this.resetDim(container);
        }
        return this.minDim;
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this.tailleInconnue) {
            this.resetDim(container);
        }
        return this.prefDim;
    }

    public void layoutContainer(Container container) {
        if (this.tailleInconnue) {
            this.resetDim(container);
        }
        switch (container.getComponentCount()) {
            case 0: {
                break;
            }
            case 1: {
                Dimension dimension = container.getSize();
                Insets insets = container.getInsets();
                dimension.width -= insets.left + insets.right;
                dimension.height -= insets.top + insets.bottom;
                int n = Math.min(dimension.width, (int)((double)dimension.height / this.proportion));
                int n2 = Math.min(dimension.height, (int)((double)dimension.width * this.proportion));
                container.getComponent(0).setBounds((dimension.width - n) / 2 + insets.left, (dimension.height - n2) / 2 + insets.top, n, n2);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("pas plus de 1 object");
            }
        }
    }
}

