/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.guimain;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import net.phbwt.jtans.calc.DisplayFigure;
import net.phbwt.jtans.calc.EditableFigure;
import net.phbwt.jtans.calc.PixelOutlinePolygon;
import net.phbwt.jtans.guicommon.Config;
import net.phbwt.jtans.guicommon.Surface;
import net.phbwt.jtans.guicommon.Trait;

public final class EditableFigureComponent
extends JPanel
implements Observer {
    public static final String PROPERTY_SELECTION = "jt.selection";
    public static final String PROPERTY_FOUND = "jt.found";
    private static final boolean DEBUG = false;
    public static final int MODE_NONE = 1;
    public static final int MODE_MOVE = 2;
    public static final int MODE_ROTATION = 3;
    private boolean gfxIsConfigured = false;
    private Surface bgSurface;
    private Paint bgPaint;
    private Surface unselectedFiguresSurface;
    private Paint unselectedFiguresPaint;
    private Surface selectedFigureSurface;
    private Paint selectedFigurePaint;
    private Composite selectedFigureComposite;
    private Paint traitPaint;
    private Stroke traitStroke;
    private int traitGrow;
    private Paint borderPaint;
    private Stroke borderStroke;
    private int borderGrow;
    private Paint outlinePaint;
    private Stroke outlineStroke;
    private Shape foundMarkShapeScaled;
    private Stroke foundMarkStroke;
    private Composite foundMarkComposite = AlphaComposite.getInstance(3, 0.2f);
    private RenderingHints hints;
    public EditableFigure fig;
    public DisplayFigure outlineFig;
    private double refScale;
    protected BufferedImage offImg;
    protected Graphics2D offImgGr;
    protected int offImgW;
    protected int offImgH;
    int compBorderTop;
    int compBorderLeft;
    Rectangle selectedPieceLastBounds;
    Rectangle selectedPieceActualBounds = new Rectangle();
    Rectangle traitLastBounds;
    Rectangle traitActualBounds = new Rectangle();
    Line2D.Double traitShape = new Line2D.Double();
    int lastX;
    int lastY;
    boolean isSelected = false;
    boolean withOutline = false;
    boolean isFound = false;
    int compareAccuracy;
    int actualMode = 1;
    int rotOriginX;
    int rotOriginY;
    double rotOriginAngle;
    double rotRefAngle;
    private static ResourceBundle i18n = null;

    EditableFigureComponent(EditableFigure editableFigure, DisplayFigure displayFigure, Config config) {
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.fig = editableFigure;
        this.outlineFig = displayFigure;
        this.config(config);
        config.addObserver(this);
        if (i18n == null) {
            i18n = ResourceBundle.getBundle("net.phbwt.jtans.i18n.main");
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                EditableFigureComponent.this.setScale(EditableFigureComponent.this.refScale);
                EditableFigureComponent.this.offImg = null;
                EditableFigureComponent.this.foundMarkShapeScaled = null;
                EditableFigureComponent.this.foundMarkStroke = new BasicStroke((float)EditableFigureComponent.this.getWidth() / 150.0f, 1, 1);
                EditableFigureComponent.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                EditableFigureComponent.this.traitShape.setLine(EditableFigureComponent.this.rotOriginX, EditableFigureComponent.this.rotOriginY, EditableFigureComponent.this.rotOriginX, EditableFigureComponent.this.rotOriginY);
                EditableFigureComponent.this.refreshSelectedPiece();
                EditableFigureComponent.this.actualMode = 1;
                if (!EditableFigureComponent.this.isFound && EditableFigureComponent.this.fig.getCalcFigure().compare(EditableFigureComponent.this.outlineFig.getCalcFigure(), EditableFigureComponent.this.compareAccuracy)) {
                    EditableFigureComponent.this.isFound = true;
                    EditableFigureComponent.this.unselect();
                    EditableFigureComponent.this.repaint();
                    EditableFigureComponent.this.firePropertyChange(EditableFigureComponent.PROPERTY_FOUND, false, true);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (EditableFigureComponent.this.isFound) {
                    return;
                }
                int n2 = mouseEvent.getX();
                int n3 = EditableFigureComponent.this.fig.selectAt(n2, n = mouseEvent.getY());
                if (n3 == -1 && EditableFigureComponent.this.isSelected && (mouseEvent.getModifiers() & 0x10) != 0) {
                    EditableFigureComponent.this.actualMode = 3;
                    EditableFigureComponent.this.rotOriginX = EditableFigureComponent.this.fig.getSelectedPiece().getPosX();
                    EditableFigureComponent.this.rotOriginY = EditableFigureComponent.this.fig.getSelectedPiece().getPosY();
                    EditableFigureComponent.this.rotOriginAngle = EditableFigureComponent.this.fig.getSelectedPiece().getRotation();
                    EditableFigureComponent.this.rotRefAngle = Math.atan2(n2 - EditableFigureComponent.this.rotOriginX, n - EditableFigureComponent.this.rotOriginY);
                    EditableFigureComponent.this.traitShape.setLine(EditableFigureComponent.this.rotOriginX, EditableFigureComponent.this.rotOriginY, n2, n);
                    EditableFigureComponent.this.refreshSelectedPiece();
                }
                if (n3 != -1) {
                    EditableFigureComponent.this.actualMode = 2;
                    if (n3 == 1 || !EditableFigureComponent.this.isSelected) {
                        boolean bl = EditableFigureComponent.this.isSelected;
                        EditableFigureComponent.this.isSelected = true;
                        EditableFigureComponent.this.redrawOffscreenImage(true);
                        EditableFigureComponent.this.repaint();
                        EditableFigureComponent.this.firePropertyChange(EditableFigureComponent.PROPERTY_SELECTION, bl, true);
                    }
                }
                if ((mouseEvent.getClickCount() == 2 || (mouseEvent.getModifiers() & 4) != 0) && EditableFigureComponent.this.isSelected) {
                    EditableFigureComponent.this.fig.flipSelectedPiece();
                    EditableFigureComponent.this.refreshSelectedPiece();
                }
                EditableFigureComponent.this.lastX = n2;
                EditableFigureComponent.this.lastY = n;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                switch (EditableFigureComponent.this.actualMode) {
                    case 2: {
                        Point point = EditableFigureComponent.this.fig.translateSelectedPiece(mouseEvent.getX() - EditableFigureComponent.this.lastX, mouseEvent.getY() - EditableFigureComponent.this.lastY);
                        EditableFigureComponent.this.lastX += point.x;
                        EditableFigureComponent.this.lastY += point.y;
                        EditableFigureComponent.this.refreshSelectedPiece();
                        break;
                    }
                    case 3: {
                        double d = EditableFigureComponent.this.rotOriginAngle - EditableFigureComponent.this.rotRefAngle + Math.atan2(mouseEvent.getX() - EditableFigureComponent.this.rotOriginX, mouseEvent.getY() - EditableFigureComponent.this.rotOriginY);
                        EditableFigureComponent.this.fig.setRotationForSelectedPiece(d);
                        EditableFigureComponent.this.lastX = mouseEvent.getX();
                        EditableFigureComponent.this.lastY = mouseEvent.getY();
                        EditableFigureComponent.this.traitShape.setLine(EditableFigureComponent.this.rotOriginX, EditableFigureComponent.this.rotOriginY, EditableFigureComponent.this.lastX, EditableFigureComponent.this.lastY);
                        EditableFigureComponent.this.refreshSelectedPiece();
                    }
                }
            }
        });
    }

    public void update(Observable observable, Object object) {
        this.config((Config)observable);
        this.refreshAll();
    }

    private void config(Config config) {
        this.bgSurface = config.getSurface("main.background");
        this.unselectedFiguresSurface = config.getSurface("main.piece.normal");
        this.selectedFigureSurface = config.getSurface("main.piece.selected");
        this.selectedFigureComposite = config.getComposite("main.piece.selected.alpha");
        Trait trait = config.getTrait("main.rotation");
        this.traitPaint = trait.getColor();
        this.traitStroke = trait.getStroke();
        this.traitGrow = trait.getGrow();
        trait = config.getTrait("main.piece.border");
        this.borderPaint = trait.getColor();
        this.borderStroke = trait.getStroke();
        this.borderGrow = trait.getGrow();
        trait = config.getTrait("main.outline");
        this.outlinePaint = trait.getColor();
        this.outlineStroke = trait.getStroke();
        this.setScale(config.getDouble("main.scale", 0.1));
        switch (config.getInt("main.rotationStep", 14)) {
            case 13: {
                this.fig.setSteppedRotation(-1.0, 0.0);
                break;
            }
            case 14: {
                this.fig.setSteppedRotation(0.19634954084936207, 0.0);
                break;
            }
            case 15: {
                this.fig.setSteppedRotation(0.19634954084936207, 0.0);
            }
        }
        this.compareAccuracy = config.getInt("main.compareAccuracy", 17);
        this.hints = config.getRenderingHints();
        this.offImg = null;
        this.gfxIsConfigured = false;
    }

    private void configGfx() {
        this.bgPaint = this.bgSurface.getPaintNoError(this);
        this.unselectedFiguresPaint = this.unselectedFiguresSurface.getPaintNoError(this);
        this.selectedFigurePaint = this.selectedFigureSurface.getPaintNoError(this);
        this.gfxIsConfigured = true;
    }

    public final void paintComponent(Graphics graphics) {
        if (!this.gfxIsConfigured) {
            this.configGfx();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Composite composite = null;
        if (this.offImg == null) {
            this.redrawOffscreenImage(false);
        }
        graphics2D.drawImage((Image)this.offImg, this.compBorderLeft, this.compBorderTop, this);
        if (this.actualMode == 3) {
            graphics2D.setPaint(this.traitPaint);
            graphics2D.setStroke(this.traitStroke);
            graphics2D.draw(this.traitShape);
            if (this.traitLastBounds == null) {
                this.traitLastBounds = new Rectangle();
            }
            this.traitLastBounds.setBounds(this.traitShape.getBounds());
            this.traitLastBounds.grow(this.traitGrow, this.traitGrow);
        }
        if (this.isSelected) {
            graphics2D.setPaint(this.selectedFigurePaint);
            if (this.selectedFigureComposite != null) {
                composite = graphics2D.getComposite();
                graphics2D.setComposite(this.selectedFigureComposite);
            }
        } else {
            graphics2D.setPaint(this.unselectedFiguresPaint);
        }
        graphics2D.fill(this.fig.getSelectedPiece());
        graphics2D.setPaint(this.borderPaint);
        graphics2D.setStroke(this.borderStroke);
        graphics2D.draw(this.fig.getSelectedPiece());
        if (this.selectedPieceLastBounds == null) {
            this.selectedPieceLastBounds = new Rectangle();
        }
        this.selectedPieceLastBounds.setBounds(this.fig.getSelectedPiece().getBounds());
        this.selectedPieceLastBounds.grow(this.borderGrow, this.borderGrow);
        if (this.isFound) {
            long l = System.currentTimeMillis();
            if (this.foundMarkShapeScaled == null) {
                this.foundMarkShapeScaled = this.createFoundMarkShape(graphics2D);
            }
            if (composite == null) {
                composite = graphics2D.getComposite();
            }
            graphics2D.setComposite(this.foundMarkComposite);
            graphics2D.setPaint(Color.white);
            graphics2D.fill(this.foundMarkShapeScaled);
            graphics2D.setStroke(this.foundMarkStroke);
            graphics2D.setPaint(Color.black);
            graphics2D.draw(this.foundMarkShapeScaled);
        }
        graphics2D.setStroke(stroke);
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
    }

    protected void redrawOffscreenImage(boolean bl) {
        if (this.offImg == null) {
            Insets insets = this.getInsets();
            this.compBorderLeft = insets.left;
            this.compBorderTop = insets.top;
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.top - insets.bottom;
            this.offImg = (BufferedImage)this.createImage(n, n2);
            this.offImgGr = this.offImg.createGraphics();
            this.offImgGr.translate(-this.compBorderLeft, -this.compBorderTop);
            this.offImgGr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.offImgGr.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            this.offImgGr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.offImgGr.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            this.offImgGr.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            this.offImgGr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.offImgGr.addRenderingHints(this.hints);
            this.offImgW = n;
            this.offImgH = n2;
            bl = false;
        }
        long l = System.currentTimeMillis();
        if (bl && this.fig.getPreviousSelectedPiece() != null) {
            Rectangle rectangle = this.fig.getPreviousSelectedPiece().getBounds().union(this.fig.getSelectedPiece().getBounds());
            rectangle.grow(this.traitGrow, this.traitGrow);
            this.offImgGr.setClip(rectangle);
        } else {
            this.offImgGr.setClip(null);
        }
        this.offImgGr.setPaint(this.bgPaint);
        this.offImgGr.fill(new Rectangle(this.compBorderLeft, this.compBorderTop, this.offImgW, this.offImgH));
        if (this.withOutline) {
            this.offImgGr.setPaint(this.outlinePaint);
            this.offImgGr.setStroke(this.outlineStroke);
            Iterator iterator = this.outlineFig.outlineIterator();
            while (iterator.hasNext()) {
                this.offImgGr.draw((PixelOutlinePolygon)iterator.next());
            }
        }
        Iterator iterator = this.fig.pieceIteratorBottomUp();
        while (iterator.hasNext()) {
            Shape shape = (Shape)iterator.next();
            this.offImgGr.setPaint(this.unselectedFiguresPaint);
            this.offImgGr.fill(shape);
            this.offImgGr.setPaint(this.borderPaint);
            this.offImgGr.setStroke(this.borderStroke);
            this.offImgGr.draw(shape);
        }
    }

    public void refreshSelectedPiece() {
        if (this.actualMode == 3) {
            if (this.traitLastBounds != null) {
                this.repaint(this.traitLastBounds);
            }
            this.traitActualBounds.setBounds(this.traitShape.getBounds());
            this.traitActualBounds.grow(this.traitGrow, this.traitGrow);
            this.repaint(this.traitActualBounds);
        }
        if (this.selectedPieceLastBounds != null) {
            this.repaint(this.selectedPieceLastBounds);
        }
        this.selectedPieceActualBounds.setBounds(this.fig.getSelectedPiece().getBounds());
        this.selectedPieceActualBounds.grow(this.borderGrow, this.borderGrow);
        this.repaint(this.selectedPieceActualBounds);
    }

    public void refreshAll() {
        if (!this.gfxIsConfigured) {
            this.configGfx();
        }
        this.redrawOffscreenImage(false);
        this.repaint();
    }

    public void toggleOutline() {
        this.withOutline = !this.withOutline;
        this.refreshAll();
    }

    public void setOutlineFigure(DisplayFigure displayFigure) {
        this.outlineFig = displayFigure;
        if (this.isFound) {
            this.isFound = false;
            this.firePropertyChange(PROPERTY_FOUND, true, false);
            this.repaint();
        }
        this.setScale(this.refScale);
        if (this.withOutline) {
            this.toggleOutline();
        }
    }

    public void unselect() {
        if (this.isSelected) {
            this.isSelected = false;
            this.refreshSelectedPiece();
            this.firePropertyChange(PROPERTY_SELECTION, true, false);
        }
    }

    public void flip() {
        if (!this.isFound) {
            this.fig.flipSelectedPiece();
            this.refreshSelectedPiece();
        }
    }

    public void setScale(double d) {
        this.refScale = d;
        Insets insets = this.getInsets();
        double d2 = this.refScale * (double)(this.getWidth() - insets.left - insets.right);
        this.fig.setScale(d2);
        this.fig.setLimits(insets.left, insets.top, this.getWidth() - insets.right, this.getHeight() - insets.bottom);
        this.outlineFig.setScale(d2);
        this.outlineFig.center(insets.left, insets.top, this.getWidth() - insets.right, this.getHeight() - insets.bottom);
    }

    protected final Graphics getComponentGraphics(Graphics graphics) {
        ((Graphics2D)graphics).addRenderingHints(this.hints);
        return graphics;
    }

    private Shape createFoundMarkShape(Graphics2D graphics2D) {
        double d;
        double d2;
        GlyphVector glyphVector;
        Font font = new Font("SansSerif", 0, 10);
        String string = i18n.getString("foundMarkSymbol");
        if (font.canDisplayUpTo(string) < 0) {
            glyphVector = font.createGlyphVector(graphics2D.getFontRenderContext(), string);
            d2 = 0.75;
            d = 0.75;
        } else {
            glyphVector = font.createGlyphVector(graphics2D.getFontRenderContext(), i18n.getString("foundMarkText"));
            d = 1.0;
            d2 = 0.5;
        }
        Shape shape = glyphVector.getOutline();
        AffineTransform affineTransform = new AffineTransform();
        Insets insets = this.getInsets();
        affineTransform.translate(insets.left, insets.top);
        affineTransform.scale(this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        affineTransform.translate((1.0 - d) / 2.0, (1.0 - d2) / 2.0);
        affineTransform.scale(d, d2);
        Rectangle rectangle = shape.getBounds();
        affineTransform.scale(1.0 / (rectangle.getMaxX() - rectangle.getMinX()), 1.0 / (rectangle.getMaxY() - rectangle.getMinY()));
        affineTransform.translate(-rectangle.getMinX(), -rectangle.getMinY());
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }
}

