/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.calc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.phbwt.jtans.calc.CalcFigure;
import net.phbwt.jtans.calc.CalcOutlinePolygon;
import net.phbwt.jtans.calc.CalcPiece;
import net.phbwt.jtans.calc.CalcPolyPoints;

public class StaticCalcOutline {
    private static final boolean DEBUG = false;
    private static final int MAX_PNTS = 100;
    private static final int MAX_POLY = 10;
    private static final double SEUIL_DIST = 1.0E-10;
    private static final double SEUIL_ANGLE = 0.02454369260617026;
    private static CalcPolyPoints pointBuffer = new CalcPolyPoints(0, 100);
    private static double[] xBuf = StaticCalcOutline.pointBuffer.xpoints;
    private static double[] yBuf = StaticCalcOutline.pointBuffer.ypoints;
    private static int[] nextPoint = new int[100];
    private static CalcPolyPoints dumBuffer = new CalcPolyPoints(0, 100);
    private static int polyNbr;
    private static Poly[] polyBuffer;
    private static CalcPolyPoints delta;
    private static double[] xDelta;
    private static double[] yDelta;

    public static synchronized List createOutline(CalcFigure calcFigure) {
        boolean bl;
        StaticCalcOutline.init(calcFigure);
        long l = System.currentTimeMillis();
        StaticCalcOutline.merge();
        StaticCalcOutline.removeConsec();
        do {
            bl = false;
            StaticCalcOutline.addInterPoints();
            bl |= StaticCalcOutline.merge();
            bl |= StaticCalcOutline.removeConsec();
            if (StaticCalcOutline.checkIncluded()) {
                StaticCalcOutline.checkIncluded();
                bl = true;
            }
            StaticCalcOutline.removeAligned();
            StaticCalcOutline.compact();
        } while (bl);
        ArrayList<CalcOutlinePolygon> arrayList = new ArrayList<CalcOutlinePolygon>();
        for (int i = 0; i < polyNbr; ++i) {
            Poly poly = polyBuffer[i];
            CalcOutlinePolygon calcOutlinePolygon = new CalcOutlinePolygon(0, poly.pointNbr, poly.type);
            int n = poly.firstPoint;
            for (int j = poly.pointNbr; j > 0; --j) {
                calcOutlinePolygon.addPoint(xBuf[n], yBuf[n]);
                n = nextPoint[n];
            }
            arrayList.add(calcOutlinePolygon);
        }
        return arrayList;
    }

    private static void init(CalcFigure calcFigure) {
        pointBuffer.clear();
        polyNbr = 0;
        for (int i = 99; i >= 0; --i) {
            StaticCalcOutline.nextPoint[i] = i + 1;
        }
        Iterator iterator = calcFigure.pieceIterator();
        while (iterator.hasNext()) {
            int n;
            CalcPolyPoints calcPolyPoints = ((CalcPiece)iterator.next()).getPolygon();
            StaticCalcOutline.nextPoint[n + calcPolyPoints.npoints - 1] = n = pointBuffer.addCalcPolyPoints(calcPolyPoints);
            StaticCalcOutline.polyBuffer[StaticCalcOutline.polyNbr++] = new Poly(n, calcPolyPoints.npoints);
        }
    }

    private static boolean addInterPoints() {
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            for (int i = polyNbr - 1; i >= 0 && !bl2; --i) {
                for (int j = polyNbr - 1; j >= 0 && !bl2; --j) {
                    if (i == j && i != j) continue;
                    int n = StaticCalcOutline.polyBuffer[i].firstPoint;
                    for (int k = StaticCalcOutline.polyBuffer[i].pointNbr; k > 0 && !bl2; --k) {
                        int n2 = nextPoint[n];
                        int n3 = StaticCalcOutline.polyBuffer[j].firstPoint;
                        for (int i2 = StaticCalcOutline.polyBuffer[j].pointNbr; i2 > 0 && !bl2; --i2) {
                            int n4 = nextPoint[n3];
                            if (pointBuffer.distSqr(n, n3) > 1.0E-10 && pointBuffer.distSqr(n2, n3) > 1.0E-10 && pointBuffer.distSegSqr(n, n2, n3, delta) < 2.5E-11) {
                                if (i == j) {
                                    // empty if block
                                }
                                int n5 = pointBuffer.addPoint(xBuf[n3] - xDelta[0], yBuf[n3] - yDelta[0]);
                                StaticCalcOutline.nextPoint[n5] = nextPoint[n];
                                StaticCalcOutline.nextPoint[n] = n5;
                                ++StaticCalcOutline.polyBuffer[i].pointNbr;
                                StaticCalcOutline.polyBuffer[i].firstPoint = n;
                                bl = true;
                                bl2 = true;
                            }
                            n3 = n4;
                        }
                        n = n2;
                    }
                }
            }
        }
        return bl;
    }

    private static void compact() {
        int n;
        int n2;
        Poly poly;
        int n3;
        dumBuffer.clear();
        for (n3 = polyNbr - 1; n3 >= 0; --n3) {
            poly = polyBuffer[n3];
            n2 = poly.firstPoint;
            poly.firstPoint = dumBuffer.addPoint(xBuf[n2], yBuf[n2]);
            for (n = poly.pointNbr - 1; n > 0; --n) {
                n2 = nextPoint[n2];
                dumBuffer.addPoint(xBuf[n2], yBuf[n2]);
            }
        }
        for (n3 = polyNbr - 1; n3 >= 0; --n3) {
            poly = polyBuffer[n3];
            n2 = poly.firstPoint;
            for (n = poly.pointNbr - 1; n > 0; --n) {
                StaticCalcOutline.nextPoint[n2] = n2 + 1;
                ++n2;
            }
            StaticCalcOutline.nextPoint[n2] = poly.firstPoint;
        }
        CalcPolyPoints calcPolyPoints = dumBuffer;
        dumBuffer = pointBuffer;
        pointBuffer = calcPolyPoints;
        xBuf = StaticCalcOutline.pointBuffer.xpoints;
        yBuf = StaticCalcOutline.pointBuffer.ypoints;
    }

    private static boolean removeAligned() {
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            for (int i = polyNbr - 1; i >= 0 && !bl2; --i) {
                int n = StaticCalcOutline.polyBuffer[i].firstPoint;
                int n2 = nextPoint[n];
                double d = pointBuffer.angle(n2, n);
                for (int j = StaticCalcOutline.polyBuffer[i].pointNbr; j > 0 && !bl2; --j) {
                    n2 = nextPoint[n];
                    int n3 = nextPoint[n2];
                    double d2 = pointBuffer.angle(n3, n2);
                    double d3 = d2 - d;
                    if (d3 < 0.02454369260617026 && d3 > -0.02454369260617026 || d3 > 6.258641614573416 || d3 < -6.258641614573416) {
                        StaticCalcOutline.nextPoint[n] = n3;
                        --StaticCalcOutline.polyBuffer[i].pointNbr;
                        StaticCalcOutline.polyBuffer[i].firstPoint = n;
                        bl = true;
                        bl2 = true;
                    }
                    n = n2;
                    d = d2;
                }
            }
        }
        return bl;
    }

    private static boolean removeConsec() {
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            for (int i = polyNbr - 1; i >= 0 && !bl2; --i) {
                int n = StaticCalcOutline.polyBuffer[i].firstPoint;
                for (int j = StaticCalcOutline.polyBuffer[i].pointNbr; j > 0 && !bl2; --j) {
                    int n2 = nextPoint[n];
                    int n3 = nextPoint[n2];
                    if (pointBuffer.distSqr(n, n3) < 1.0E-10) {
                        StaticCalcOutline.nextPoint[n] = nextPoint[n3];
                        StaticCalcOutline.polyBuffer[i].pointNbr -= 2;
                        StaticCalcOutline.polyBuffer[i].firstPoint = n;
                        bl = true;
                        bl2 = true;
                    }
                    n = n2;
                }
            }
        }
        return bl;
    }

    private static boolean merge() {
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            bl2 = false;
            for (int i = polyNbr - 1; i >= 0 && !bl2; --i) {
                for (int j = i + 1; j < polyNbr && !bl2; ++j) {
                    int n = StaticCalcOutline.polyBuffer[i].firstPoint;
                    for (int k = StaticCalcOutline.polyBuffer[i].pointNbr; k > 0 && !bl2; --k) {
                        int n2 = nextPoint[n];
                        int n3 = StaticCalcOutline.polyBuffer[j].firstPoint;
                        for (int i2 = StaticCalcOutline.polyBuffer[j].pointNbr; i2 > 0 && !bl2; --i2) {
                            int n4 = nextPoint[n3];
                            if (pointBuffer.distSqr(n, n4) < 1.0E-10 && pointBuffer.distSqr(n2, n3) < 1.0E-10) {
                                StaticCalcOutline.nextPoint[n] = nextPoint[n4];
                                StaticCalcOutline.nextPoint[n3] = nextPoint[n2];
                                StaticCalcOutline.polyBuffer[i].pointNbr += StaticCalcOutline.polyBuffer[j].pointNbr - 2;
                                StaticCalcOutline.polyBuffer[i].firstPoint = n;
                                for (int i3 = j; i3 < polyNbr - 1; ++i3) {
                                    StaticCalcOutline.polyBuffer[i3] = polyBuffer[i3 + 1];
                                }
                                --polyNbr;
                                bl = true;
                                bl2 = true;
                            }
                            n3 = n4;
                        }
                        n = n2;
                    }
                }
            }
        }
        return bl;
    }

    private static boolean checkIncluded() {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = polyNbr - 1;
        while (n2 >= 0 && !bl) {
            int n3;
            int n4 = StaticCalcOutline.polyBuffer[n2].pointNbr;
            int n5 = StaticCalcOutline.polyBuffer[n2].firstPoint;
            double d = xBuf[n5];
            n = n5;
            for (n3 = n4; n3 > 0; --n3) {
                if (xBuf[n5] < d) {
                    d = xBuf[n5];
                    n = n5;
                }
                n5 = nextPoint[n5];
            }
            n5 = n;
            for (int i = 0; i < n4 - 2 && !bl; ++i) {
                int n6 = nextPoint[n5];
                int n7 = nextPoint[n6];
                for (int j = i + 2; j < n4 && !bl; ++j) {
                    int n8 = nextPoint[n7];
                    if (pointBuffer.distSqr(n5, n8) < 1.0E-10 && pointBuffer.distSqr(n6, n7) < 1.0E-10) {
                        int n9;
                        StaticCalcOutline.nextPoint[n5] = nextPoint[n8];
                        StaticCalcOutline.nextPoint[n7] = nextPoint[n6];
                        Poly poly = polyBuffer[n2];
                        for (n9 = n2; n9 < polyNbr - 1; ++n9) {
                            StaticCalcOutline.polyBuffer[n9] = polyBuffer[n9 + 1];
                        }
                        --polyNbr;
                        for (n3 = 0; StaticCalcOutline.polyBuffer[n3].type == 6 && n3 < polyNbr; ++n3) {
                        }
                        for (n9 = polyNbr + 1; n9 > n3 + 1; --n9) {
                            StaticCalcOutline.polyBuffer[n9] = polyBuffer[n9 - 2];
                        }
                        poly.pointNbr -= j - i + 1;
                        poly.firstPoint = n5;
                        poly.type = poly.type != 7 ? 6 : 7;
                        StaticCalcOutline.polyBuffer[n3] = poly;
                        StaticCalcOutline.polyBuffer[n3 + 1] = new Poly(n7, j - i - 1, 7);
                        polyNbr += 2;
                        bl2 = true;
                        bl = true;
                    }
                    n7 = n8;
                }
                n5 = n6;
            }
            --n2;
        }
        return bl2;
    }

    static {
        polyBuffer = new Poly[10];
        delta = new CalcPolyPoints(1);
        xDelta = StaticCalcOutline.delta.xpoints;
        yDelta = StaticCalcOutline.delta.ypoints;
    }

    static class Poly {
        int firstPoint;
        int pointNbr;
        int type;

        Poly(int n, int n2) {
            this(n, n2, 5);
        }

        Poly(int n, int n2, int n3) {
            this.firstPoint = n;
            this.pointNbr = n2;
            this.type = n3;
        }
    }
}

