/*
 * Decompiled with CFR 0.152.
 */
package net.phbwt.jtans.calc;

import net.phbwt.jtans.calc.CalcPiece;
import net.phbwt.jtans.calc.CalcPolyPoints;
import net.phbwt.jtans.calc.PixelFigure;
import net.phbwt.jtans.calc.PixelPolygon;

public final class PixelPiece
extends PixelPolygon {
    private CalcPiece calcPiece;

    public PixelPiece(PixelFigure pixelFigure, CalcPiece calcPiece) {
        super(pixelFigure, calcPiece.getPolygon().npoints);
        this.calcPiece = calcPiece;
        this.resetShape();
    }

    protected CalcPolyPoints getPolygon() {
        return this.calcPiece.getPolygon();
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        this.calcPiece.translate((double)n / this.figure.scale, (double)n2 / this.figure.scale);
    }

    public void flip() {
        this.calcPiece.flip();
        this.resetShape();
    }

    public void setRotation(double d) {
        this.calcPiece.setRotation(d);
        this.resetShape();
    }

    public double getRotation() {
        return this.calcPiece.rotation;
    }

    public int getPosX() {
        return (int)(this.calcPiece.posX * this.figure.scale + 0.39999) + this.figure.refX;
    }

    public int getPosY() {
        return (int)(this.calcPiece.posY * this.figure.scale + 0.39999) + this.figure.refY;
    }

    public boolean contains(double d, double d2) {
        return this.calcPiece.contains(d, d2);
    }
}

